/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sedona.shaded.jiffle.parser.node.Expression;
import org.apache.sedona.shaded.jiffle.parser.node.FunctionCall;
import org.apache.sedona.shaded.jiffle.parser.node.GetSourceValue;
import org.apache.sedona.shaded.jiffle.parser.node.ImagePos;
import org.apache.sedona.shaded.jiffle.parser.node.ScalarLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.SourceWriter;

public class RepeatedReadOptimizer {
    Map<GetSourceValue, List<GetSourceValue>> sourceValues = new LinkedHashMap<GetSourceValue, List<GetSourceValue>>();

    public void add(GetSourceValue node) {
        List sourceValues = this.sourceValues.computeIfAbsent(node, f -> new ArrayList());
        sourceValues.add(node);
    }

    public void declareRepeatedReads(SourceWriter w) {
        for (GetSourceValue sourceValue : this.sourceValues.keySet()) {
            List<GetSourceValue> valuesList = this.sourceValues.get(sourceValue);
            if (valuesList.size() <= 1) continue;
            ImagePos pos = sourceValue.getPos();
            Expression band = pos.getBand().getIndex();
            Expression x = pos.getPixel().getX();
            Expression y = pos.getPixel().getY();
            SourceWriter varWriter = new SourceWriter(w.getRuntimeModel());
            if (!(band instanceof ScalarLiteral) || !this.isPosition(x) || !this.isPosition(y)) continue;
            varWriter.append("sv_").append(sourceValue.getVarName()).append("_");
            x.write(varWriter);
            varWriter.append("_");
            y.write(varWriter);
            varWriter.append("_");
            band.write(varWriter);
            String variableName = varWriter.getSource().replace("-", "_");
            w.indent();
            w.append("double ").append(variableName).append(" = ");
            sourceValue.write(w);
            w.append(";");
            w.newLine();
            for (GetSourceValue reference : valuesList) {
                reference.setVariableName(variableName);
            }
        }
    }

    private boolean isPosition(Expression x) {
        return x instanceof FunctionCall && ((FunctionCall)x).isProxy() || x instanceof ScalarLiteral;
    }

    public void resetVariables() {
        for (GetSourceValue sourceValue : this.sourceValues.keySet()) {
            List<GetSourceValue> valuesList = this.sourceValues.get(sourceValue);
            if (valuesList.size() <= 1) continue;
            for (GetSourceValue reference : valuesList) {
                reference.setVariableName(null);
            }
        }
    }
}

