/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.common.geometrySerde.GeometrySerde;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.quadtree.Node;
import org.locationtech.jts.index.quadtree.Quadtree;

public class IndexSerde {
    GeometrySerde geometrySerde = new GeometrySerde();

    public Object read(Kryo kryo, Input input) {
        int i;
        boolean notEmpty;
        Quadtree index = new Quadtree();
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (!notEmpty) {
            return index;
        }
        int itemSize = input.readInt();
        ArrayList<Object> items = new ArrayList<Object>();
        for (i = 0; i < itemSize; ++i) {
            items.add(this.geometrySerde.read(kryo, input, Geometry.class));
        }
        index.getRoot().items = items;
        for (i = 0; i < 4; ++i) {
            index.getRoot().subnode[i] = this.readQuadTreeNode(kryo, input);
        }
        return index;
    }

    public void write(Kryo kryo, Output output, Quadtree tree) {
        if (tree.isEmpty()) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            List items = tree.getRoot().getItems();
            output.writeInt(items.size());
            for (Object item : items) {
                this.geometrySerde.write(kryo, output, item);
            }
            Node[] subNodes = tree.getRoot().subnode;
            for (int i = 0; i < 4; ++i) {
                this.writeQuadTreeNode(kryo, output, subNodes[i]);
            }
        }
    }

    private void writeQuadTreeNode(Kryo kryo, Output output, Node node) {
        if (node == null || node.isEmpty()) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            this.geometrySerde.write(kryo, output, node.getEnvelope());
            output.writeInt(node.getLevel());
            List items = node.getItems();
            output.writeInt(items.size());
            for (Object obj : items) {
                this.geometrySerde.write(kryo, output, obj);
            }
            Node[] subNodes = node.subnode;
            for (int i = 0; i < 4; ++i) {
                this.writeQuadTreeNode(kryo, output, subNodes[i]);
            }
        }
    }

    private Node readQuadTreeNode(Kryo kryo, Input input) {
        int i;
        boolean notEmpty;
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (!notEmpty) {
            return null;
        }
        Envelope envelope = (Envelope)this.geometrySerde.read(kryo, input, Envelope.class);
        int level = input.readInt();
        Node node = new Node(envelope, level);
        int itemSize = input.readInt();
        ArrayList<Object> items = new ArrayList<Object>();
        for (i = 0; i < itemSize; ++i) {
            items.add(this.geometrySerde.read(kryo, input, Geometry.class));
        }
        node.items = items;
        for (i = 0; i < 4; ++i) {
            node.subnode[i] = this.readQuadTreeNode(kryo, input);
        }
        return node;
    }
}

