/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.sedona.core.formatMapper.shapefileParser.ShapefileRDD;
import org.apache.sedona.core.knnJudgement.EuclideanItemDistance;
import org.apache.sedona.core.spatialPartitioning.QuadtreePartitioning;
import org.apache.sedona.core.spatialPartitioning.quadtree.QuadRectangle;
import org.apache.sedona.core.utils.SedonaConf;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;

public class QuadTreeRTPartitioning
extends QuadtreePartitioning {
    static final Logger log = Logger.getLogger(QuadTreeRTPartitioning.class);
    private SedonaConf sedonaConf;
    private STRtree strTree;
    private HashMap<Integer, List<Envelope>> mbrs;
    private STRtree mbrSpatialIndex;

    public QuadTreeRTPartitioning(List<Envelope> samples, Envelope boundary, int partitions) throws Exception {
        super(samples, boundary, partitions);
    }

    public QuadTreeRTPartitioning(List<Envelope> samples, Envelope boundary, int partitions, int minTreeLevel) throws Exception {
        super(samples, boundary, partitions, minTreeLevel);
    }

    public HashMap<Integer, List<Envelope>> getMbrs() {
        return this.mbrs;
    }

    public STRtree getMbrSpatialIndex() {
        return this.mbrSpatialIndex;
    }

    public STRtree buildSTRTree(List<Envelope> samples, int k) {
        this.mbrs = new HashMap();
        this.strTree = new STRtree();
        List<QuadRectangle> partitionMBRs = this.partitionTree.getAllZones().stream().filter(quadRect -> quadRect.partitionId != null).collect(Collectors.toList());
        for (QuadRectangle quadRect2 : partitionMBRs) {
            Envelope mbr = quadRect2.getEnvelope();
            this.strTree.insert(mbr, (Object)mbr);
        }
        STRtree sampleTree = new STRtree();
        for (Envelope sample : samples) {
            Point point = ShapefileRDD.geometryFactory.createPoint(new Coordinate(sample.centre().getX(), sample.centre().getY()));
            sampleTree.insert(sample, (Object)point);
        }
        this.processPartitions(partitionMBRs, this.mbrs, k, sampleTree, ShapefileRDD.geometryFactory);
        this.mbrSpatialIndex = new STRtree();
        for (Integer id : this.mbrs.keySet()) {
            for (Envelope envelope : this.mbrs.get(id)) {
                this.mbrSpatialIndex.insert(envelope, (Object)id);
            }
        }
        return this.strTree;
    }

    public void processPartitions(List<QuadRectangle> partitionMBRs, Map<Integer, List<Envelope>> mbrs, int k, STRtree sampleTree, GeometryFactory geometryFactory) {
        for (QuadRectangle quadRect : partitionMBRs) {
            this.processPartition(partitionMBRs, quadRect, mbrs, k, sampleTree, geometryFactory);
        }
    }

    private void processPartition(List<QuadRectangle> partitionMBRs, QuadRectangle quadRect, Map<Integer, List<Envelope>> mbrs, int k, STRtree sampleTree, GeometryFactory geometryFactory) {
        Envelope partitionMBR = quadRect.getEnvelope();
        double centroidX = (partitionMBR.getMinX() + partitionMBR.getMaxX()) / 2.0;
        double centroidY = (partitionMBR.getMinY() + partitionMBR.getMaxY()) / 2.0;
        Coordinate centroidCoord = new Coordinate(centroidX, centroidY);
        Point centroid = geometryFactory.createPoint(centroidCoord);
        double ui = QuadTreeRTPartitioning.getUi(centroid, partitionMBR);
        double maxDistance = QuadTreeRTPartitioning.getMaxDistanceFromSamples(k, sampleTree, centroid);
        List<Envelope> intersectingMBRs = this.getMBRIntersectEnvelopes(ui, maxDistance, centroidX, centroidY);
        mbrs.put(quadRect.partitionId, intersectingMBRs);
    }

    public double getMinimalEnvelopeWidth(List<QuadRectangle> partitionMBRs) {
        double minEnvelopeWidth = Double.MAX_VALUE;
        for (QuadRectangle quadRect : partitionMBRs) {
            Envelope partitionMBR = quadRect.getEnvelope();
            double width = partitionMBR.getMaxX() - partitionMBR.getMinX();
            if (!(width < minEnvelopeWidth)) continue;
            minEnvelopeWidth = width;
        }
        return minEnvelopeWidth;
    }

    private static double getUi(Point centroid, Envelope partitionMBR) {
        double ui = Math.max(centroid.distance(ShapefileRDD.geometryFactory.createPoint(new Coordinate(partitionMBR.getMinX(), partitionMBR.getMinY()))), Math.max(centroid.distance(ShapefileRDD.geometryFactory.createPoint(new Coordinate(partitionMBR.getMinX(), partitionMBR.getMaxY()))), Math.max(centroid.distance(ShapefileRDD.geometryFactory.createPoint(new Coordinate(partitionMBR.getMaxX(), partitionMBR.getMinY()))), centroid.distance(ShapefileRDD.geometryFactory.createPoint(new Coordinate(partitionMBR.getMaxX(), partitionMBR.getMaxY()))))));
        return ui;
    }

    private static double getMaxDistanceFromSamples(int k, STRtree sampleTree, Point centroid) {
        Object[] kNearestNeighbors = sampleTree.nearestNeighbour(centroid.getEnvelopeInternal(), centroid, new EuclideanItemDistance(), k);
        double maxDistance = 0.0;
        for (Object neighbor : kNearestNeighbors) {
            Envelope neighborEnvelope;
            Coordinate neighborCoord;
            Point neighborPoint;
            double distance;
            if (!(neighbor instanceof Geometry) || !((distance = centroid.distance(neighborPoint = ShapefileRDD.geometryFactory.createPoint(neighborCoord = new Coordinate((neighborEnvelope = ((Geometry)neighbor).getEnvelopeInternal()).centre().getX(), neighborEnvelope.centre().getY())))) > maxDistance)) continue;
            maxDistance = distance;
        }
        return maxDistance;
    }

    private List<Envelope> getMBRIntersectEnvelopes(double ui, double maxDistance, double centroidX, double centroidY) {
        double gamma_i = 2.0 * ui + maxDistance;
        Envelope circleEnvelope = new Envelope(centroidX - gamma_i, centroidX + gamma_i, centroidY - gamma_i, centroidY + gamma_i);
        Coordinate center = new Coordinate(centroidX, centroidY);
        Geometry circle = ShapefileRDD.geometryFactory.createPoint(center).buffer(gamma_i);
        List candidateEnvelopes = this.strTree.query(circleEnvelope);
        ArrayList<Envelope> intersectingMBRs = new ArrayList<Envelope>();
        for (Envelope candidateEnvelope : candidateEnvelopes) {
            Geometry envelopeGeometry = ShapefileRDD.geometryFactory.toGeometry(candidateEnvelope);
            if (!circle.intersects(envelopeGeometry)) continue;
            intersectingMBRs.add(candidateEnvelope);
        }
        return intersectingMBRs;
    }
}

