/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.lib.ConnectedComponents;
import org.graphframes.lib.ConnectedComponents$;
import org.graphframes.lib.GraphXConversions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class ConnectedComponents$
implements Logging {
    public static final ConnectedComponents$ MODULE$ = new ConnectedComponents$();
    private static final String COMPONENT;
    private static final String ORIG_ID;
    private static final String MIN_NBR;
    private static final String CNT;
    private static final String CHECKPOINT_NAME_PREFIX;
    private static final String ALGO_GRAPHX;
    private static final String org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES;
    private static final String[] supportedAlgorithms;
    private static transient Logger org$graphframes$Logging$$logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$(MODULE$);
        COMPONENT = "component";
        ORIG_ID = "orig_id";
        MIN_NBR = "min_nbr";
        CNT = "cnt";
        CHECKPOINT_NAME_PREFIX = "connected-components";
        ALGO_GRAPHX = "graphx";
        org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES = "graphframes";
        supportedAlgorithms = (String[])((Object[])new String[]{MODULE$.ALGO_GRAPHX(), MODULE$.org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES()});
    }

    @Override
    public void logDebug(Function0<String> s2) {
        Logging.logDebug$(this, s2);
    }

    @Override
    public void logWarn(Function0<String> s2) {
        Logging.logWarn$(this, s2);
    }

    @Override
    public void logInfo(Function0<String> s2) {
        Logging.logInfo$(this, s2);
    }

    @Override
    public void logTrace(Function0<String> s2) {
        Logging.logTrace$(this, s2);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        ConnectedComponents$ connectedComponents$ = this;
        synchronized (connectedComponents$) {
            if (!bitmap$trans$0) {
                org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                bitmap$trans$0 = true;
            }
        }
        return org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        return !bitmap$trans$0 ? this.org$graphframes$Logging$$logger$lzycompute() : org$graphframes$Logging$$logger;
    }

    private String COMPONENT() {
        return COMPONENT;
    }

    private String ORIG_ID() {
        return ORIG_ID;
    }

    private String MIN_NBR() {
        return MIN_NBR;
    }

    private String CNT() {
        return CNT;
    }

    private String CHECKPOINT_NAME_PREFIX() {
        return CHECKPOINT_NAME_PREFIX;
    }

    private String ALGO_GRAPHX() {
        return ALGO_GRAPHX;
    }

    public String org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES() {
        return org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES;
    }

    public String[] supportedAlgorithms() {
        return supportedAlgorithms;
    }

    private Dataset<Row> symmetrize(Dataset<Row> ee) {
        String EDGE = "_edge";
        return ee.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})), functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))}))).as(EDGE)})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.SRC()).toString()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.DST()).toString()).as(GraphFrame$.MODULE$.DST())}));
    }

    private GraphFrame prepare(GraphFrame graph) {
        Dataset vertices = graph.indexedVertices().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_ID()).as(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(GraphFrame$.MODULE$.ATTR())}));
        Dataset edges = graph.indexedEdges().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_SRC()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_DST()).as(GraphFrame$.MODULE$.DST())}));
        Dataset orderedEdges = edges.filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.SRC()), this.maxValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.DST())})).distinct();
        return GraphFrame$.MODULE$.apply((Dataset<Row>)vertices, (Dataset<Row>)orderedEdges);
    }

    private Dataset<Row> minNbrs(Dataset<Row> ee) {
        return this.symmetrize(ee).groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).withColumn(this.MIN_NBR(), this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR())));
    }

    private Column minValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$less((Object)y), (Object)x).otherwise((Object)y);
    }

    private Column maxValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$greater((Object)y), (Object)x).otherwise((Object)y);
    }

    private Dataset<Row> skewedJoin(Dataset<Row> edges, Dataset<Row> minNbrs, int broadcastThreshold, String logPrefix) {
        Set hubs = Predef$.MODULE$.wrapLongArray((long[])minNbrs.filter(functions$.MODULE$.col(this.CNT()).$greater((Object)BoxesRunTime.boxToInteger((int)broadcastThreshold))).select(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).as(edges.sparkSession().implicits().newLongEncoder()).collect()).toSet();
        return GraphFrame$.MODULE$.skewedJoin(edges, minNbrs, GraphFrame$.MODULE$.SRC(), hubs, logPrefix, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Long());
    }

    public Dataset<Row> run(GraphFrame graph) {
        return new ConnectedComponents(graph).run();
    }

    private Dataset<Row> runGraphX(GraphFrame graph) {
        Graph components = org.apache.spark.graphx.lib.ConnectedComponents$.MODULE$.run(graph.cachedTopologyGraphX(), (ClassTag)ClassTag$.MODULE$.Unit(), (ClassTag)ClassTag$.MODULE$.Unit());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_lib_ConnectedComponents$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphx")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$);
            }

            public Org_graphframes_lib_ConnectedComponents$$typecreator1$1() {
            }
        }
        return GraphXConversions$.MODULE$.fromGraphX(graph, components, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.COMPONENT()}))), GraphXConversions$.MODULE$.fromGraphX$default$4(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_lib_ConnectedComponents$$typecreator1$1()), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Unit()).vertices();
    }

    public Dataset<Row> org$graphframes$lib$ConnectedComponents$$run(GraphFrame graph, String algorithm, int broadcastThreshold, int checkpointInterval, StorageLevel intermediateStorageLevel) {
        None$ none$;
        boolean shouldCheckpoint;
        Predef$.MODULE$.require(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.supportedAlgorithms()), (Object)algorithm), (Function0 & Serializable)() -> new StringBuilder(38).append("Supported algorithms are {").append(Predef$.MODULE$.wrapRefArray((Object[])MODULE$.supportedAlgorithms()).mkString(", ")).append("}, but got ").append(algorithm).append(".").toString());
        String string = algorithm;
        String string2 = this.ALGO_GRAPHX();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.runGraphX(graph);
        }
        String runId = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 8);
        String logPrefix = new StringBuilder(5).append("[CC ").append(runId).append("]").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append(logPrefix).append(" Start connected components with run ID ").append(runId).append(".").toString());
        SparkSession spark = graph.spark();
        SparkContext sc = spark.sparkContext();
        boolean bl = shouldCheckpoint = checkpointInterval > 0;
        if (shouldCheckpoint) {
            String dir = (String)sc.getCheckpointDir().map((Function1 & Serializable)d -> new Path(d, new StringBuilder(1).append(MODULE$.CHECKPOINT_NAME_PREFIX()).append("-").append(runId).toString()).toString()).getOrElse((Function0 & Serializable)() -> {
                throw new IOException("Checkpoint directory is not set. Please set it first using sc.setCheckpointDir().");
            });
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append(logPrefix).append(" Using ").append(dir).append(" for checkpointing with interval ").append(checkpointInterval).append(".").toString());
            none$ = new Some((Object)dir);
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append(logPrefix).append(" Checkpointing is disabled because checkpointInterval=").append(checkpointInterval).append(".").toString());
            none$ = None$.MODULE$;
        }
        None$ checkpointDir = none$;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append(logPrefix).append(" Preparing the graph for connected component computation ...").toString());
        GraphFrame g2 = this.prepare(graph);
        Dataset<Row> vv = g2.vertices();
        Dataset ee = g2.edges().persist(intermediateStorageLevel);
        long numEdges = ee.count();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append(logPrefix).append(" Found ").append(numEdges).append(" edges after preparation.").toString());
        boolean converged = false;
        IntRef iteration = IntRef.create((int)1);
        BigDecimal prevSum = null;
        while (!converged) {
            Dataset minNbrs1 = this.minNbrs((Dataset<Row>)ee).persist(intermediateStorageLevel);
            ee = this.skewedJoin((Dataset<Row>)ee, (Dataset<Row>)minNbrs1, broadcastThreshold, logPrefix).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.DST())})).distinct().persist(intermediateStorageLevel);
            Dataset minNbrs2 = ee.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())})).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).persist(intermediateStorageLevel);
            ee = this.skewedJoin((Dataset<Row>)ee, (Dataset<Row>)minNbrs2, broadcastThreshold, logPrefix).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})).filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())));
            ee = ee.union(minNbrs2.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))).distinct();
            if (shouldCheckpoint && iteration.elem % checkpointInterval == 0) {
                Object object;
                String out = new StringBuilder(1).append(checkpointDir.get()).append("/").append(iteration.elem).toString();
                ee.write().parquet(out);
                ee = spark.read().parquet(out);
                if (iteration.elem > checkpointInterval) {
                    Path path = new Path(new StringBuilder(1).append(checkpointDir.get()).append("/").append(iteration.elem - checkpointInterval).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)path.getFileSystem(sc.hadoopConfiguration()).delete(path, true));
                } else {
                    object = BoxedUnit.UNIT;
                }
                System.gc();
            }
            ee.persist(intermediateStorageLevel);
            Tuple2 tuple2 = (Tuple2)ee.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).cast((DataType)new DecimalType(20, 0))), functions$.MODULE$.count("*")})).rdd().map((Function1 & Serializable)r -> new Tuple2(r.getAs(0), (Object)BoxesRunTime.boxToLong((long)r.getLong(1))), ClassTag$.MODULE$.apply(Tuple2.class)).first();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigDecimal currSum = (BigDecimal)tuple2._1();
            long cnt = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)currSum, (Object)BoxesRunTime.boxToLong((long)cnt));
            Tuple2 tuple23 = tuple22;
            BigDecimal currSum2 = (BigDecimal)tuple23._1();
            long cnt2 = tuple23._2$mcJ$sp();
            if (cnt2 != 0L && currSum2 == null) {
                throw new ArithmeticException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(378).append("\n             |The total sum of edge src IDs is used to determine convergence during iterations.\n             |However, the total sum at iteration ").append(iteration.elem).append(" exceeded 30 digits (1e30),\n             |which should happen only if the graph contains more than 200 billion edges.\n             |If not, please file a bug report at https://github.com/graphframes/graphframes/issues.\n            ").toString())));
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append(logPrefix).append(" Sum of assigned components in iteration ").append(iteration$1.elem).append(": ").append(currSum2).append(".").toString());
            if (BoxesRunTime.equalsNumNum((Number)currSum2, prevSum)) {
                converged = true;
            } else {
                prevSum = currSum2;
            }
            ++iteration.elem;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append(logPrefix).append(" Connected components converged in ").append(iteration$1.elem - 1).append(" iterations.").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append(logPrefix).append(" Join and return component assignments with original vertex IDs.").toString());
        return vv.join(ee, vv.apply(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)ee.apply(GraphFrame$.MODULE$.DST())), "left_outer").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vv.apply(GraphFrame$.MODULE$.ATTR()), functions$.MODULE$.when(ee.apply(GraphFrame$.MODULE$.SRC()).isNull(), (Object)vv.apply(GraphFrame$.MODULE$.ID())).otherwise((Object)ee.apply(GraphFrame$.MODULE$.SRC())).as(this.COMPONENT())})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(GraphFrame$.MODULE$.ATTR()).append(".*").toString()), functions$.MODULE$.col(this.COMPONENT())}));
    }

    private ConnectedComponents$() {
    }
}

