/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoDateTimeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$GeometryColumnBoundingBox$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011\ra\u0001\u0002.\\\u0001)Dq!!\u0001\u0001\t\u0003\t\u0019!\u0002\u0004\u0002\n\u0001!\u00111\u0002\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA-\u0011-\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003c\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\bC\u0006\u0002x\u0001\u0001\r\u0011!Q!\n\u0005\r\u0004bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003wB1\"a!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0006\"Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA?\u0011-\tY\t\u0001a\u0001\u0002\u0004%I!!$\t\u0017\u0005-\u0006\u00011AA\u0002\u0013%\u0011Q\u0016\u0005\f\u0003c\u0003\u0001\u0019!A!B\u0013\ty\tC\u0005\u00024\u0002\u0011\r\u0011\"\u0003\u00026\"A\u0011q\u0018\u0001!\u0002\u0013\t9\fC\u0005\u0002B\u0002\u0011\r\u0011\"\u0003\u00026\"A\u00111\u0019\u0001!\u0002\u0013\t9\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011Q\u001e\u0001!\u0002\u0013\tI\rC\u0005\u0002p\u0002\u0011\r\u0011\"\u0003\u0002r\"A\u0011\u0011 \u0001!\u0002\u0013\t\u0019\u0010C\u0005\u0002|\u0002\u0011\r\u0011\"\u0003\u0002~\"A!q\u0001\u0001!\u0002\u0013\ty\u0010C\u0005\u0003\n\u0001\u0011\r\u0011\"\u0003\u0002H\"A!1\u0002\u0001!\u0002\u0013\tI\rC\u0005\u0003\u000e\u0001\u0011\r\u0011\"\u0003\u0002~\"A!q\u0002\u0001!\u0002\u0013\ty\u0010C\u0005\u0003\u0012\u0001\u0011\r\u0011\"\u0003\u0003\u0014!A!\u0011 \u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003|\u0002\u0001\r\u0011\"\u0003\u0003~\"I1Q\u0001\u0001A\u0002\u0013%1q\u0001\u0005\t\u0007\u0017\u0001\u0001\u0015)\u0003\u0003\u0000\"I1Q\u0002\u0001A\u0002\u0013%1q\u0002\u0005\n\u0007S\u0001\u0001\u0019!C\u0005\u0007WA\u0001ba\f\u0001A\u0003&1\u0011\u0003\u0005\n\u0007c\u0001!\u0019!C\u0005\u0007gA\u0001ba\u000e\u0001A\u0003%1Q\u0007\u0005\n\u0007s\u0001!\u0019!C\u0005\u0007wA\u0001b!\u0012\u0001A\u0003%1Q\b\u0005\b\u0007\u000f\u0002A\u0011IB%\u0011\u001d\u00199\b\u0001C!\u0007sBqa! \u0001\t\u0003\u001ay\bC\u0004\u0004\n\u0002!\tea#\t\u000f\rE\u0005\u0001\"\u0003\u0004\u0014\"91Q\u0014\u0001\u0005\n\r}\u0005\"CBY\u0001E\u0005I\u0011BBZ\u0011\u001d\u00199\f\u0001C\u0005\u0007sCqaa1\u0001\t\u0003\u0019)\rC\u0004\u0004R\u0002!Iaa5\t\u000f\r}\u0007\u0001\"\u0003\u0004b\"91Q\u001e\u0001\u0005\n\r=\bbBBz\u0001\u0011%1Q_\u0004\b\u0005kY\u0006\u0012\u0001B\u001c\r\u0019Q6\f#\u0001\u0003:!9\u0011\u0011\u0001\u001e\u0005\u0002\t\u0005cA\u0002B\"u\u0001\u0011)\u0005C\u0004\u0002\u0002q\"\tAa\u0012\t\u0013\t5CH1A\u0005\u0002\t=\u0003\u0002\u0003BVy\u0001\u0006IA!\u0015\t\u0013\t5FH1A\u0005\u0002\t=\u0006\u0002\u0003Bdy\u0001\u0006IA!-\t\u000f\tEE\b\"\u0001\u0003J\u001a1!1\u000b\u001e\u0001\u0005+B!Ba\u0016D\u0005\u0003\u0007I\u0011\u0001B-\u0011)\u0011\tg\u0011BA\u0002\u0013\u0005!1\r\u0005\u000b\u0005O\u001a%\u0011!Q!\n\tm\u0003B\u0003B5\u0007\n\u0005\r\u0011\"\u0001\u0003Z!Q!1N\"\u0003\u0002\u0004%\tA!\u001c\t\u0015\tE4I!A!B\u0013\u0011Y\u0006\u0003\u0006\u0003t\r\u0013\t\u0019!C\u0001\u00053B!B!\u001eD\u0005\u0003\u0007I\u0011\u0001B<\u0011)\u0011Yh\u0011B\u0001B\u0003&!1\f\u0005\u000b\u0005{\u001a%\u00111A\u0005\u0002\te\u0003B\u0003B@\u0007\n\u0005\r\u0011\"\u0001\u0003\u0002\"Q!QQ\"\u0003\u0002\u0003\u0006KAa\u0017\t\u000f\u0005\u00051\t\"\u0001\u0003\b\"9!\u0011S\"\u0005\u0002\tMu!\u0003Bgu\u0005\u0005\t\u0012\u0001Bh\r%\u0011\u0019FOA\u0001\u0012\u0003\u0011\t\u000eC\u0004\u0002\u0002M#\tAa5\t\u0013\tU7+%A\u0005\u0002\t]\u0007\"\u0003Bw'F\u0005I\u0011\u0001Bl\u0011%\u0011yoUI\u0001\n\u0003\u00119\u000eC\u0005\u0003rN\u000b\n\u0011\"\u0001\u0003X\"9!1\u001f\u001e\u0005\n\tU(AF$f_B\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005qk\u0016a\u00029beF,X\r\u001e\u0006\u0003=~\u000b1\u0002Z1uCN|WO]2fg*\u0011\u0001-Y\u0001\nKb,7-\u001e;j_:T!AY2\u0002\u0007M\fHN\u0003\u0002eK\u0006)1\u000f]1sW*\u0011amZ\u0001\u0007CB\f7\r[3\u000b\u0003!\f1a\u001c:h\u0007\u0001\u00192\u0001A6{!\ra'\u000f^\u0007\u0002[*\u0011an\\\u0001\u0004CBL'B\u00019r\u0003\u0019A\u0017\rZ8pa*\u0011A,Z\u0005\u0003g6\u0014Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"!\u001e=\u000e\u0003YT!a^1\u0002\u0011\r\fG/\u00197zgRL!!\u001f<\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003wzl\u0011\u0001 \u0006\u0003{\u000e\f\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u007fr\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000b\u00012!a\u0002\u0001\u001b\u0005Y&a\u0003,bYV,wK]5uKJ\u0004\"\"!\u0004\u0002\u0014\u0005]\u00111EA\u0015\u001b\t\tyA\u0003\u0002\u0002\u0012\u0005)1oY1mC&!\u0011QCA\b\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiB^\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\"\u0005m!AE*qK\u000eL\u0017\r\\5{K\u0012<U\r\u001e;feN\u0004B!!\u0004\u0002&%!\u0011qEA\b\u0005\rIe\u000e\u001e\t\u0005\u0003\u001b\tY#\u0003\u0003\u0002.\u0005=!\u0001B+oSR\faa]2iK6\fWCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dC\u0006)A/\u001f9fg&!\u0011QHA\u001c\u0005)\u0019FO];diRK\b/Z\u0001\u000bg\u000eDW-\\1`I\u0015\fH\u0003BA\u0015\u0003\u0007B\u0011\"!\u0012\u0005\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\u0004tG\",W.\u0019\u0011\u0002!I|w\u000e\u001e$jK2$wK]5uKJ\u001cXCAA'!\u0019\ti!a\u0014\u0002T%!\u0011\u0011KA\b\u0005\u0015\t%O]1z!\r\t)FA\u0007\u0002\u0001\u0005!\"o\\8u\r&,G\u000eZ,sSR,'o]0%KF$B!!\u000b\u0002\\!I\u0011QI\u0004\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0012e>|GOR5fY\u0012<&/\u001b;feN\u0004\u0013A\u0004:fG>\u0014HmQ8ogVlWM]\u000b\u0003\u0003G\u0002B!!\u001a\u0002n5\u0011\u0011q\r\u0006\u0004]\u0006%$bAA6c\u0006\u0011\u0011n\\\u0005\u0005\u0003_\n9G\u0001\bSK\u000e|'\u000fZ\"p]N,X.\u001a:\u0002%I,7m\u001c:e\u0007>t7/^7fe~#S-\u001d\u000b\u0005\u0003S\t)\bC\u0005\u0002F)\t\t\u00111\u0001\u0002d\u0005y!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014\b%\u0001\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR,\"!! \u0011\t\u00055\u0011qP\u0005\u0005\u0003\u0003\u000byAA\u0004C_>dW-\u00198\u00029]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fGo\u0018\u0013fcR!\u0011\u0011FAD\u0011%\t)%DA\u0001\u0002\u0004\ti(A\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR\u0004\u0013aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,WCAAH!\u0011\t\t*a)\u000f\t\u0005M\u0015Q\u0014\b\u0005\u0003+\u000bI*\u0004\u0002\u0002\u0018*\u0011Q0Y\u0005\u0005\u00037\u000b9*A\u0004T#2\u001buN\u001c4\n\t\u0005}\u0015\u0011U\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0005\u00037\u000b9*\u0003\u0003\u0002&\u0006\u001d&!\u0002,bYV,\u0017\u0002BAU\u0003\u001f\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\u00069r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK~#S-\u001d\u000b\u0005\u0003S\ty\u000bC\u0005\u0002FA\t\t\u00111\u0001\u0002\u0010\u0006!r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK\u0002\nq\u0002^5nKN$\u0018-\u001c9Ck\u001a4WM]\u000b\u0003\u0003o\u0003b!!\u0004\u0002P\u0005e\u0006\u0003BA\u0007\u0003wKA!!0\u0002\u0010\t!!)\u001f;f\u0003A!\u0018.\\3ti\u0006l\u0007OQ;gM\u0016\u0014\b%A\u0007eK\u000eLW.\u00197Ck\u001a4WM]\u0001\u000fI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:!\u0003I!\u0017\r^3uS6,'+\u001a2bg\u0016lu\u000eZ3\u0016\u0005\u0005%\u0007\u0003BAf\u0003GsA!!4\u0002j:!\u0011qZAM\u001d\u0011\t\t.a:\u000f\t\u0005M\u0017Q\u001d\b\u0005\u0003+\f\u0019O\u0004\u0003\u0002X\u0006\u0005h\u0002BAm\u0003?l!!a7\u000b\u0007\u0005u\u0017.\u0001\u0004=e>|GOP\u0005\u0002Q&\u0011amZ\u0005\u0003I\u0016L!AY2\n\u0005u\f\u0017\u0002BAv\u0003C\u000bA\u0003T3hC\u000eL()\u001a5bm&|'\u000fU8mS\u000eL\u0018a\u00053bi\u0016$\u0018.\\3SK\n\f7/Z'pI\u0016\u0004\u0013A\u00043bi\u0016\u0014VMY1tK\u001a+hnY\u000b\u0003\u0003g\u0004\u0002\"!\u0004\u0002v\u0006\r\u00121E\u0005\u0005\u0003o\fyAA\u0005Gk:\u001cG/[8oc\u0005yA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001c\u0007%A\nuS6,7\u000f^1naJ+'-Y:f\rVt7-\u0006\u0002\u0002\u0000BA\u0011QBA{\u0005\u0003\u0011\t\u0001\u0005\u0003\u0002\u000e\t\r\u0011\u0002\u0002B\u0003\u0003\u001f\u0011A\u0001T8oO\u0006!B/[7fgR\fW\u000e\u001d*fE\u0006\u001cXMR;oG\u0002\nq\"\u001b8usY\u0012VMY1tK6{G-Z\u0001\u0011S:$\u0018H\u000e*fE\u0006\u001cX-T8eK\u0002\nq\"\u001b8usY\u0012VMY1tK\u001a+hnY\u0001\u0011S:$\u0018H\u000e*fE\u0006\u001cXMR;oG\u0002\nQcZ3p[\u0016$(/_\"pYVlg.\u00138g_6\u000b\u0007/\u0006\u0002\u0003\u0016AA!q\u0003B\u0011\u0003G\u0011)#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003\u001diW\u000f^1cY\u0016TAAa\b\u0002\u0010\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0004\u001b\u0006\u0004\bc\u0001B\u0014y9\u0019!\u0011F\u001d\u000f\t\t-\"1\u0007\b\u0005\u0005[\u0011\tD\u0004\u0003\u0002R\n=\u0012B\u00011b\u0013\tqv,\u0003\u0002];\u00061r)Z8QCJ\fX/\u001a;Xe&$XmU;qa>\u0014H\u000fE\u0002\u0002\bi\u001a2A\u000fB\u001e!\u0011\tiA!\u0010\n\t\t}\u0012q\u0002\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t]\"AE$f_6,GO]=D_2,XN\\%oM>\u001c2\u0001\u0010B\u001e)\t\u0011I\u0005E\u0002\u0003Lqj\u0011AO\u0001\u0005E\n|\u00070\u0006\u0002\u0003RA\u0019!1J\"\u00033\u001d+w.\\3uef\u001cu\u000e\\;n]\n{WO\u001c3j]\u001e\u0014u\u000e_\n\u0004\u0007\nm\u0012\u0001B7j]b+\"Aa\u0017\u0011\t\u00055!QL\u0005\u0005\u0005?\nyA\u0001\u0004E_V\u0014G.Z\u0001\t[&t\u0007l\u0018\u0013fcR!\u0011\u0011\u0006B3\u0011%\t)%RA\u0001\u0002\u0004\u0011Y&A\u0003nS:D\u0006%\u0001\u0003nS:L\u0016\u0001C7j]f{F%Z9\u0015\t\u0005%\"q\u000e\u0005\n\u0003\u000bB\u0015\u0011!a\u0001\u00057\nQ!\\5o3\u0002\nA!\\1y1\u0006AQ.\u0019=Y?\u0012*\u0017\u000f\u0006\u0003\u0002*\te\u0004\"CA#\u0017\u0006\u0005\t\u0019\u0001B.\u0003\u0015i\u0017\r\u001f-!\u0003\u0011i\u0017\r_-\u0002\u00115\f\u00070W0%KF$B!!\u000b\u0003\u0004\"I\u0011Q\t(\u0002\u0002\u0003\u0007!1L\u0001\u0006[\u0006D\u0018\f\t\u000b\u000b\u0005#\u0012IIa#\u0003\u000e\n=\u0005\"\u0003B,!B\u0005\t\u0019\u0001B.\u0011%\u0011I\u0007\u0015I\u0001\u0002\u0004\u0011Y\u0006C\u0005\u0003tA\u0003\n\u00111\u0001\u0003\\!I!Q\u0010)\u0011\u0002\u0003\u0007!1L\u0001\u0007kB$\u0017\r^3\u0015\t\u0005%\"Q\u0013\u0005\b\u0005/\u000b\u0006\u0019\u0001BM\u0003\u00119Wm\\7\u0011\t\tm%qU\u0007\u0003\u0005;SAAa&\u0003 *!!\u0011\u0015BR\u0003\rQGo\u001d\u0006\u0004\u0005K;\u0017\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD\u0017\u0002\u0002BU\u0005;\u0013\u0001bR3p[\u0016$(/_\u0001\u0006E\n|\u0007\u0010I\u0001\u0012g\u0016,gnR3p[\u0016$(/\u001f+za\u0016\u001cXC\u0001BY!\u0019\u00119Ba-\u00038&!!Q\u0017B\r\u0005\r\u0019V\r\u001e\t\u0005\u0005s\u0013\tM\u0004\u0003\u0003<\nu\u0006\u0003BAm\u0003\u001fIAAa0\u0002\u0010\u00051\u0001K]3eK\u001aLAAa1\u0003F\n11\u000b\u001e:j]\u001eTAAa0\u0002\u0010\u0005\u00112/Z3o\u000f\u0016|W.\u001a;ssRK\b/Z:!)\u0011\tICa3\t\u000f\t]%\t1\u0001\u0003\u001a\u0006Ir)Z8nKR\u0014\u0018pQ8mk6t'i\\;oI&twMQ8y!\r\u0011YeU\n\u0004'\nmBC\u0001Bh\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u001c\u0016\u0005\u00057\u0012Yn\u000b\u0002\u0003^B!!q\u001cBu\u001b\t\u0011\tO\u0003\u0003\u0003d\n\u0015\u0018!C;oG\",7m[3e\u0015\u0011\u00119/a\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003l\n\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000fhKR\u001c\u0006/\u0019:l'Fd\u0007+\u0019:rk\u0016$(k\\<NKR\fG-\u0019;b)\u0011\u00119La>\t\u000f\u0005=\u0012\f1\u0001\u00024\u00051r-Z8nKR\u0014\u0018pQ8mk6t\u0017J\u001c4p\u001b\u0006\u0004\b%A\thK>\u0004\u0016M]9vKR4VM]:j_:,\"Aa@\u0011\r\u000551\u0011\u0001B\\\u0013\u0011\u0019\u0019!a\u0004\u0003\r=\u0003H/[8o\u0003U9Wm\u001c)beF,X\r\u001e,feNLwN\\0%KF$B!!\u000b\u0004\n!I\u0011QI\u0012\u0002\u0002\u0003\u0007!q`\u0001\u0013O\u0016|\u0007+\u0019:rk\u0016$h+\u001a:tS>t\u0007%\u0001\u000beK\u001a\fW\u000f\u001c;HK>\u0004\u0016M]9vKR\u001c%o]\u000b\u0003\u0007#\u0001b!!\u0004\u0004\u0002\rM\u0001\u0003BB\u000b\u0007GqAaa\u0006\u0004\u001e9!\u0011q[B\r\u0013\r\u0019YbZ\u0001\u0007UN|g\u000eN:\n\t\r}1\u0011E\u0001\ba\u0006\u001c7.Y4f\u0015\r\u0019YbZ\u0005\u0005\u0007K\u00199C\u0001\u0004K-\u0006dW/\u001a\u0006\u0005\u0007?\u0019\t#\u0001\reK\u001a\fW\u000f\u001c;HK>\u0004\u0016M]9vKR\u001c%o]0%KF$B!!\u000b\u0004.!I\u0011Q\t\u0014\u0002\u0002\u0003\u00071\u0011C\u0001\u0016I\u00164\u0017-\u001e7u\u000f\u0016|\u0007+\u0019:rk\u0016$8I]:!\u0003Y9Wm\u001c)beF,X\r^\"pYVlgn\u0011:t\u001b\u0006\u0004XCAB\u001b!!\u00119B!\t\u00038\u000eE\u0011aF4f_B\u000b'/];fi\u000e{G.^7o\u0007J\u001cX*\u00199!\u0003m9Wm\u001c)beF,X\r^\"pYVlgnQ8wKJLgnZ'baV\u00111Q\b\t\t\u0005/\u0011\tCa.\u0004@A!\u0011qAB!\u0013\r\u0019\u0019e\u0017\u0002\t\u0007>4XM]5oO\u0006ar-Z8QCJ\fX/\u001a;D_2,XN\\\"pm\u0016\u0014\u0018N\\4NCB\u0004\u0013\u0001B5oSR$Baa\u0013\u0004fA!1QJB0\u001d\u0011\u0019yea\u0017\u000f\t\rE3\u0011\f\b\u0005\u0007'\u001a9F\u0004\u0003\u0002V\u000eU\u0013B\u0001/f\u0013\t\u0001\u0018/\u0003\u0002o_&\u00191QL7\u0002\u0019]\u0013\u0018\u000e^3TkB\u0004xN\u001d;\n\t\r\u000541\r\u0002\r/JLG/Z\"p]R,\u0007\u0010\u001e\u0006\u0004\u0007;j\u0007bBB4Y\u0001\u00071\u0011N\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\r-41O\u0007\u0003\u0007[RAaa\u001c\u0004r\u0005!1m\u001c8g\u0015\t\u0001X-\u0003\u0003\u0004v\r5$!D\"p]\u001aLw-\u001e:bi&|g.A\bqe\u0016\u0004\u0018M]3G_J<&/\u001b;f)\u0011\tIca\u001f\t\u000f\u0005}S\u00061\u0001\u0002d\u0005ia-\u001b8bY&TXm\u0016:ji\u0016$\"a!!\u0011\t\r\r5Q\u0011\b\u0004Y\u000em\u0013\u0002BBD\u0007G\u0012QCR5oC2L'0\u001a3Xe&$XmQ8oi\u0016DH/A\u0003xe&$X\r\u0006\u0003\u0002*\r5\u0005BBBH_\u0001\u0007A/A\u0002s_^\f1b\u001e:ji\u00164\u0015.\u001a7egRA\u0011\u0011FBK\u0007/\u001bI\n\u0003\u0004\u0004\u0010B\u0002\r\u0001\u001e\u0005\b\u0003_\u0001\u0004\u0019AA\u001a\u0011\u001d\u0019Y\n\ra\u0001\u0003\u001b\nABZ5fY\u0012<&/\u001b;feN\f!\"\\1lK^\u0013\u0018\u000e^3s)\u0019\t\u0019f!)\u0004,\"911U\u0019A\u0002\r\u0015\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005U2qU\u0005\u0005\u0007S\u000b9D\u0001\u0005ECR\fG+\u001f9f\u0011%\u0019i+\rI\u0001\u0002\u0004\u0019y+A\u0006s_>$xJ\u001d3j]\u0006d\u0007CBA\u0007\u0007\u0003\t\u0019#\u0001\u000bnC.,wK]5uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007kSCaa,\u0003\\\u0006\tR.Y6f\t\u0016\u001c\u0017.\\1m/JLG/\u001a:\u0015\r\u0005M31XB`\u0011\u001d\u0019il\ra\u0001\u0003G\t\u0011\u0002\u001d:fG&\u001c\u0018n\u001c8\t\u000f\r\u00057\u00071\u0001\u0002$\u0005)1oY1mK\u0006yQ.Y6f\u0003J\u0014\u0018-_,sSR,'\u000f\u0006\u0003\u0002T\r\u001d\u0007bBBei\u0001\u000711Z\u0001\nCJ\u0014\u0018-\u001f+za\u0016\u0004B!!\u000e\u0004N&!1qZA\u001c\u0005%\t%O]1z)f\u0004X-A\u0007nC.,W*\u00199Xe&$XM\u001d\u000b\u0005\u0003'\u001a)\u000eC\u0004\u0004XV\u0002\ra!7\u0002\u000f5\f\u0007\u000fV=qKB!\u0011QGBn\u0013\u0011\u0019i.a\u000e\u0003\u000f5\u000b\u0007\u000fV=qK\u0006q1m\u001c8tk6,W*Z:tC\u001e,G\u0003BA\u0015\u0007GD\u0001b!:7\t\u0003\u00071q]\u0001\u0002MB1\u0011QBBu\u0003SIAaa;\u0002\u0010\tAAHY=oC6,g(\u0001\u0007d_:\u001cX/\\3He>,\b\u000f\u0006\u0003\u0002*\rE\b\u0002CBso\u0011\u0005\raa:\u0002\u0019\r|gn];nK\u001aKW\r\u001c3\u0015\r\r]81`B\u0000)\u0011\tIc!?\t\u0011\r\u0015\b\b\"a\u0001\u0007ODqa!@9\u0001\u0004\u00119,A\u0003gS\u0016dG\rC\u0004\u0005\u0002a\u0002\r!a\t\u0002\u000b%tG-\u001a=")
public class GeoParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private final scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap;
    private Option<String> geoParquetVersion;
    private Option<JsonAST.JValue> defaultGeoParquetCrs;
    private final scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap;
    private final scala.collection.mutable.Map<String, Covering> geoParquetColumnCoveringMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    private scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap() {
        return this.geometryColumnInfoMap;
    }

    private Option<String> geoParquetVersion() {
        return this.geoParquetVersion;
    }

    private void geoParquetVersion_$eq(Option<String> x$1) {
        this.geoParquetVersion = x$1;
    }

    private Option<JsonAST.JValue> defaultGeoParquetCrs() {
        return this.defaultGeoParquetCrs;
    }

    private void defaultGeoParquetCrs_$eq(Option<JsonAST.JValue> x$1) {
        this.defaultGeoParquetCrs = x$1;
    }

    private scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap() {
        return this.geoParquetColumnCrsMap;
    }

    private scala.collection.mutable.Map<String, Covering> geoParquetColumnCoveringMap() {
        return this.geoParquetColumnCoveringMap;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        Some some;
        Some some2;
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.schema().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                return this.makeWriter(field.dataType(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)ordinal)));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        if (this.geometryColumnInfoMap().isEmpty()) {
            throw new RuntimeException("No geometry column found in the schema");
        }
        String string = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_VERSION_KEY());
        if (string == null) {
            some2 = new Some((Object)GeoParquetMetaData$.MODULE$.VERSION());
        } else if (string != null) {
            String string2 = string;
            some2 = new Some((Object)string2);
        } else {
            throw new MatchError((Object)string);
        }
        this.geoParquetVersion_$eq((Option<String>)some2);
        String string3 = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY());
        if (string3 == null) {
            some = new Some((Object)org.json4s.package$.MODULE$.JNull());
        } else if ("".equals(string3)) {
            some = None$.MODULE$;
        } else if (string3 != null) {
            String string4 = string3;
            some = new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string4), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        } else {
            throw new MatchError((Object)string3);
        }
        this.defaultGeoParquetCrs_$eq((Option<JsonAST.JValue>)some);
        ((IterableOnceOps)this.geometryColumnInfoMap().keys().map((Function1 & Serializable)x$6 -> GeoParquetWriteSupport.$anonfun$init$2(this, BoxesRunTime.unboxToInt((Object)x$6)))).foreach((Function1 & Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$3(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY())).foreach((Function1 & Serializable)coveringColumnName -> {
            if (this.geometryColumnInfoMap().size() > 1) {
                throw new IllegalArgumentException(new StringBuilder(115).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(" is ambiguous when there are multiple geometry columns.").append("Please specify ").append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(".<columnName> for configured geometry column.").toString());
            }
            String geometryColumnName = this.schema().apply(BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head())).name();
            Covering covering = GeoParquetMetaData$.MODULE$.createCoveringColumnMetadata((String)coveringColumnName, this.schema());
            return this.geoParquetColumnCoveringMap().put((Object)geometryColumnName, (Object)covering);
        });
        ((IterableOnceOps)this.geometryColumnInfoMap().keys().map((Function1 & Serializable)x$7 -> GeoParquetWriteSupport.$anonfun$init$6(this, BoxesRunTime.unboxToInt((Object)x$7)))).foreach((Function1 & Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$7(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        String sparkSqlParquetRowMetadata = GeoParquetWriteSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetWriteSupport$$getSparkSqlParquetRowMetadata(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)sparkSqlParquetRowMetadata)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyDateTime"), (Object)"")) : None$.MODULE$))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyINT96"), (Object)"")) : None$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())));
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Object object;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.geometryColumnInfoMap().nonEmpty()) {
            int primaryColumnIndex = BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head());
            String primaryColumn = this.schema().fields()[primaryColumnIndex].name();
            scala.collection.immutable.Map columns = this.geometryColumnInfoMap().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int ordinal = tuple2._1$mcI$sp();
                    GeometryColumnInfo columnInfo = (GeometryColumnInfo)tuple2._2();
                    String columnName = this.schema().fields()[ordinal].name();
                    Seq geometryTypes = columnInfo.seenGeometryTypes().toSeq();
                    Seq bbox = geometryTypes.nonEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{columnInfo.bbox().minX(), columnInfo.bbox().minY(), columnInfo.bbox().maxX(), columnInfo.bbox().maxY()})) : (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}));
                    Option crs = (Option)this.geoParquetColumnCrsMap().getOrElse((Object)columnName, (Function0 & Serializable)() -> this.defaultGeoParquetCrs());
                    Option covering = this.geoParquetColumnCoveringMap().get((Object)columnName);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)crs, (Option<Covering>)covering));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            GeoParquetMetaData geoParquetMetadata = new GeoParquetMetaData(this.geoParquetVersion(), primaryColumn, (scala.collection.immutable.Map<String, GeometryFieldMetaData>)columns);
            String geoParquetMetadataJson = GeoParquetMetaData$.MODULE$.toJson(geoParquetMetadata);
            object = metadata.put("geo", geoParquetMetadataJson);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new WriteSupport.FinalizedWriteContext(metadata);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, Option<Object> rootOrdinal) {
        while (true) {
            DecimalType decimalType;
            Option option;
            DataType dataType2;
            if (BooleanType$.MODULE$.equals(dataType2 = dataType)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                Enumeration.Value value = this.outputTimestampType();
                Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                throw new MatchError((Object)value);
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                return this.makeDecimalWriter(precision, scale);
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$9 -> x$9.dataType())).map((Function1 & Serializable)x$10 -> this.makeWriter((DataType)x$10, (Option<Object>)None$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return this.makeArrayWriter(arrayType);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return this.makeMapWriter(mapType);
            }
            if (((Object)((Object)GeometryUDT$.MODULE$)).equals(dataType2)) {
                GeometryColumnInfo geometryColumnInfo;
                Option<Object> option2 = rootOrdinal;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int ordinal2 = BoxesRunTime.unboxToInt((Object)some.value());
                    geometryColumnInfo = (GeometryColumnInfo)this.geometryColumnInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ordinal2), (Function0 & Serializable)() -> new GeometryColumnInfo());
                } else if (None$.MODULE$.equals(option2)) {
                    geometryColumnInfo = null;
                } else {
                    throw new MatchError(option2);
                }
                GeometryColumnInfo geometryColumnInfo2 = geometryColumnInfo;
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$19(this, geometryColumnInfo2, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            rootOrdinal = this.makeWriter$default$2();
            dataType = userDefinedType.sqlType();
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType).append(".").toString());
    }

    private Option<Object> makeWriter$default$2() {
        return None$.MODULE$;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (bl3 && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return binaryWriterUsingUnscaledLong;
        }
        return binaryWriterUsingUnscaledBytes;
    }

    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), this.makeWriter$default$2());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                return this.twoLevelArrayWriter$1("array", elementWriter);
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), this.makeWriter$default$2());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), this.makeWriter$default$2());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ String $anonfun$init$2(GeoParquetWriteSupport $this, int x$6) {
        return $this.schema().apply(x$6).name();
    }

    public static final /* synthetic */ void $anonfun$init$3(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable)x0$2 -> {
            String string = x0$2;
            if ("".equals(string)) {
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)None$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
            }
            throw new MatchError((Object)string);
        });
    }

    public static final /* synthetic */ String $anonfun$init$6(GeoParquetWriteSupport $this, int x$7) {
        return $this.schema().apply(x$7).name();
    }

    public static final /* synthetic */ void $anonfun$init$7(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable)coveringColumnName -> {
            Covering covering = GeoParquetMetaData$.MODULE$.createCoveringColumnMetadata((String)coveringColumnName, $this.schema());
            return $this.geoParquetColumnCoveringMap().put((Object)name, (Object)covering);
        });
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        int julianDay2 = sp2._1$mcI$sp();
        long timeOfDayNanos2 = sp2._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = GeoDateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$19(GeoParquetWriteSupport $this, GeometryColumnInfo geometryColumnInfo$1, SpecializedGetters row, int ordinal) {
        byte[] serializedGeometry = row.getBinary(ordinal);
        Geometry geom = GeometryUDT$.MODULE$.deserialize(serializedGeometry);
        WKBWriter wkbWriter = new WKBWriter(GeomUtils.getDimension(geom));
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])wkbWriter.write(geom)));
        if (geometryColumnInfo$1 != null) {
            geometryColumnInfo$1.update(geom);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (!array.isNullAt(i$2.elem)) {
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(GeoParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
                return;
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (map.numElements() > 0) {
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            if (!map.valueArray().isNullAt(i$3.elem)) {
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    public GeoParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = GeoDataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
        this.geometryColumnInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.geoParquetVersion = None$.MODULE$;
        this.defaultGeoParquetCrs = None$.MODULE$;
        this.geoParquetColumnCrsMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.geoParquetColumnCoveringMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static class GeometryColumnBoundingBox {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        public double minX() {
            return this.minX;
        }

        public void minX_$eq(double x$1) {
            this.minX = x$1;
        }

        public double minY() {
            return this.minY;
        }

        public void minY_$eq(double x$1) {
            this.minY = x$1;
        }

        public double maxX() {
            return this.maxX;
        }

        public void maxX_$eq(double x$1) {
            this.maxX = x$1;
        }

        public double maxY() {
            return this.maxY;
        }

        public void maxY_$eq(double x$1) {
            this.maxY = x$1;
        }

        public void update(Geometry geom) {
            Envelope env = geom.getEnvelopeInternal();
            this.minX_$eq(scala.math.package$.MODULE$.min(this.minX(), env.getMinX()));
            this.minY_$eq(scala.math.package$.MODULE$.min(this.minY(), env.getMinY()));
            this.maxX_$eq(scala.math.package$.MODULE$.max(this.maxX(), env.getMaxX()));
            this.maxY_$eq(scala.math.package$.MODULE$.max(this.maxY(), env.getMaxY()));
        }

        public GeometryColumnBoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    public static class GeometryColumnInfo {
        private final GeometryColumnBoundingBox bbox = new GeometryColumnBoundingBox(GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$1(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$2(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$3(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$4());
        private final Set<String> seenGeometryTypes = (Set)Set$.MODULE$.empty();

        public GeometryColumnBoundingBox bbox() {
            return this.bbox;
        }

        public Set<String> seenGeometryTypes() {
            return this.seenGeometryTypes;
        }

        public void update(Geometry geom) {
            this.bbox().update(geom);
            Coordinate coordinate = geom.getCoordinate();
            boolean hasZ = coordinate != null ? !Double.isNaN(coordinate.getZ()) : false;
            String geometryType = !hasZ ? geom.getGeometryType() : new StringBuilder(2).append(geom.getGeometryType()).append(" Z").toString();
            this.seenGeometryTypes().add((Object)geometryType);
        }
    }
}

