/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDateUnit;

public class WriterCFTrajectoryProfileCollection
extends CFPointWriter {
    public static final String trajectoryIndexName = "trajectoryIndex";
    private int ntraj;
    private int traj_strlen;
    private Structure trajStructure;
    private HashMap<String, Integer> trajIndexMap;
    private Map<String, Variable> trajVarMap = new HashMap<String, Variable>();
    private Structure profileStruct;
    private Map<String, Variable> profileVarMap = new HashMap<String, Variable>();
    private boolean headerDone;
    private int trajRecno;
    private int profileRecno;
    private int obsRecno;

    public WriterCFTrajectoryProfileCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.trajectoryProfile.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Contiguous ragged array representation of trajectory profile, H.6.3"));
    }

    public void setFeatureAuxInfo2(int ntraj, int traj_strlen) {
        this.ntraj = ntraj;
        this.traj_strlen = traj_strlen;
        this.trajIndexMap = new HashMap(2 * ntraj);
    }

    public int writeProfile(TrajectoryProfileFeature section, ProfileFeature profile) throws IOException {
        int count = 0;
        for (PointFeature pf : profile) {
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = profile.getName().length() * 2;
                }
                this.writeHeader(section, profile, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        Integer sectionIndex = this.trajIndexMap.get(section.getName());
        if (sectionIndex == null) {
            sectionIndex = this.writeSectionData(section);
            this.trajIndexMap.put(section.getName(), sectionIndex);
        }
        this.writeProfileData(sectionIndex, profile, count);
        return count;
    }

    private void writeHeader(TrajectoryProfileFeature section, ProfileFeature profile, PointFeature obs) throws IOException {
        StructureData sectionData = section.getFeatureData();
        StructureData profileData = profile.getFeatureData();
        StructureData obsData = obs.getFeatureData();
        Formatter coordNames = new Formatter().format("%s %s %s", "profileTime", "latitude", "longitude");
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        if (this.useAlt) {
            obsCoords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
            coordNames.format(" %s", this.altitudeCoordinateName);
        }
        super.writeHeader2(obsCoords, sectionData, profileData, obsData, coordNames.toString());
    }

    @Override
    protected void makeFeatureVariables(StructureData trajData, boolean isExtended) {
        Dimension trajDim = this.writer.addDimension(null, "traj", this.ntraj);
        ArrayList<VariableSimpleIF> trajVars = new ArrayList<VariableSimpleIF>();
        trajVars.add(VariableSimpleBuilder.makeString("trajectoryId", "trajectory identifier", null, this.traj_strlen).addAttribute("cf_role", "trajectory_id").build());
        for (StructureMembers.Member m3 : trajData.getMembers()) {
            if (this.getDataVar(m3.getName()) == null) continue;
            trajVars.add(VariableSimpleBuilder.fromMember(m3).build());
        }
        if (isExtended) {
            this.trajStructure = (Structure)this.writer.addVariable(null, "trajectory", DataType.STRUCTURE, "traj");
            this.addCoordinatesExtended(this.trajStructure, trajVars);
        } else {
            this.addCoordinatesClassic(trajDim, trajVars, this.trajVarMap);
        }
    }

    private int writeSectionData(TrajectoryProfileFeature section) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberString("trajectoryId", null, null, section.getName().trim(), this.traj_strlen);
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, section.getFeatureData()));
        this.trajRecno = super.writeStructureData(this.trajRecno, this.trajStructure, sdall, this.trajVarMap);
        return this.trajRecno - 1;
    }

    @Override
    protected void makeMiddleVariables(StructureData profileData, boolean isExtended) {
        Dimension profileDim = this.writer.addDimension(null, "profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").addAttribute("missing_value", String.valueOf(-9999)).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("latitude", "profile latitude", "degrees_north", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("longitude", "profile longitude", "degrees_east", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        profileVars.add(VariableSimpleBuilder.makeScalar(trajectoryIndexName, "trajectory index for this profile", null, DataType.INT).addAttribute("instance_dimension", "traj").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        for (StructureMembers.Member m3 : profileData.getMembers()) {
            VariableSimpleIF dv = this.getDataVar(m3.getName());
            if (dv == null) continue;
            profileVars.add(dv);
        }
        if (isExtended) {
            this.profileStruct = (Structure)this.writer.addVariable(null, "profile", DataType.STRUCTURE, "profile");
            this.addCoordinatesExtended(this.profileStruct, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    public void writeProfileData(int sectionIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeOffsetFromRefDate(profile.getTime());
        smb.addMemberScalar("profileTime", null, null, DataType.DOUBLE, timeInMyUnits);
        smb.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        smb.addMemberScalar(trajectoryIndexName, null, null, DataType.INT, sectionIndex);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile.getFeatureData()));
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    private void writeObsData(PointFeature pf) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        if (this.useAlt) {
            smb.addMemberScalar(this.altitudeCoordinateName, null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

