/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.DbfParseUtil;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;

public class DbfFileReader
extends RecordReader<ShapeKey, String> {
    DbfParseUtil dbfParser = null;
    private FSDataInputStream inputStream = null;
    private List<byte[]> value = null;
    private ShapeKey key = null;
    private int id = 0;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        Path inputPath = fileSplit.getPath();
        FileSystem fileSys = inputPath.getFileSystem(context.getConfiguration());
        FSDataInputStream stream = fileSys.open(inputPath);
        this.initialize(stream);
    }

    public void initialize(FSDataInputStream stream) throws IOException {
        this.inputStream = stream;
        this.dbfParser = new DbfParseUtil();
        this.dbfParser.parseFileHead((DataInputStream)this.inputStream);
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return this.dbfParser.getFieldDescriptors();
    }

    public boolean nextKeyValue() throws IOException {
        List<byte[]> fieldBytesList = this.dbfParser.parse((DataInputStream)this.inputStream);
        if (fieldBytesList == null) {
            this.value = null;
            return false;
        }
        this.value = fieldBytesList;
        this.key = new ShapeKey();
        this.key.setIndex(this.id++);
        return true;
    }

    public ShapeKey getCurrentKey() {
        return this.key;
    }

    public List<byte[]> getCurrentFieldBytes() {
        return this.value;
    }

    public String getCurrentValue() {
        if (this.value == null) {
            return null;
        }
        return DbfParseUtil.fieldBytesToString(this.value);
    }

    public float getProgress() {
        return this.dbfParser.getProgress();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

