/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.format.json.debezium.DebeziumJsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumJsonDeserializationSchemaDispatcher
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DebeziumJsonDeserializationSchemaDispatcher.class);
    private final Map<TablePath, DebeziumJsonDeserializationSchema> tableDeserializationMap;
    private final boolean debeziumEnabledSchema;
    private boolean ignoreParseErrors;
    private static final String SOURCE = "source";
    private static final String TABLE = "table";
    private static final String SCHEMA = "schema";
    private static final String DATABASE = "db";
    private static final String CONNECTOR = "connector";

    public DebeziumJsonDeserializationSchemaDispatcher(Map<TablePath, DebeziumJsonDeserializationSchema> tableDeserializationMap, boolean ignoreParseErrors, boolean debeziumEnabledSchema) {
        this.tableDeserializationMap = tableDeserializationMap;
        this.debeziumEnabledSchema = debeziumEnabledSchema;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) {
        block6: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                JsonNode payload = this.getPayload(JsonUtils.readTree((byte[])message));
                JsonNode source = payload.get(SOURCE);
                String database = DebeziumJsonDeserializationSchemaDispatcher.getNodeValue(source, DATABASE);
                String schema = DebeziumJsonDeserializationSchemaDispatcher.getNodeValue(source, SCHEMA);
                String table = DebeziumJsonDeserializationSchemaDispatcher.getNodeValue(source, TABLE);
                TablePath tablePath = TablePath.of((String)database, (String)schema, (String)table);
                if (this.tableDeserializationMap.containsKey(tablePath)) {
                    this.tableDeserializationMap.get(tablePath).parsePayload(out, payload);
                } else {
                    if (this.isConnectorCanWithOutDB(source.get(CONNECTOR)) && this.tableDeserializationMap.containsKey(tablePath = TablePath.of(null, (String)schema, (String)table))) {
                        this.tableDeserializationMap.get(tablePath).parsePayload(out, payload);
                        return;
                    }
                    log.debug("Unsupported table path {}, just skip.", (Object)tablePath);
                }
            }
            catch (Exception e) {
                if (this.ignoreParseErrors) break block6;
                throw CommonError.jsonOperationError((String)"Debezium", (String)new String(message), (Throwable)e);
            }
        }
    }

    private static String getNodeValue(JsonNode source, String key) {
        return source.has(key) && !source.get(key).isNull() ? source.get(key).asText() : null;
    }

    private JsonNode getPayload(JsonNode jsonNode) {
        if (this.debeziumEnabledSchema) {
            return jsonNode.get("payload");
        }
        return jsonNode;
    }

    private boolean isConnectorCanWithOutDB(JsonNode connectorNode) {
        if (connectorNode == null || connectorNode.isNull()) {
            return true;
        }
        String connector = connectorNode.asText().toLowerCase(Locale.ROOT);
        return connector.equals("oracle") || connector.equals("dameng");
    }

    @VisibleForTesting
    public Map<TablePath, DebeziumJsonDeserializationSchema> getTableDeserializationMap() {
        return this.tableDeserializationMap;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        throw new UnsupportedOperationException("Unreachable method.");
    }
}

