/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.config.MultipleTableFakeSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceReader;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.fake.state.FakeSourceState;

public class FakeSource
implements SeaTunnelSource<SeaTunnelRow, FakeSourceSplit, FakeSourceState>,
SupportParallelism,
SupportColumnProjection {
    private JobContext jobContext;
    private final MultipleTableFakeSourceConfig multipleTableFakeSourceConfig;

    public FakeSource(ReadonlyConfig readonlyConfig) {
        this.multipleTableFakeSourceConfig = new MultipleTableFakeSourceConfig(readonlyConfig);
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.multipleTableFakeSourceConfig.getFakeConfigs().stream().map(FakeConfig::getCatalogTable).collect(Collectors.toList());
    }

    public SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> createEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext) {
        return new FakeSourceSplitEnumerator(enumeratorContext, this.multipleTableFakeSourceConfig, Collections.emptySet());
    }

    public SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> restoreEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext, FakeSourceState checkpointState) {
        return new FakeSourceSplitEnumerator(enumeratorContext, this.multipleTableFakeSourceConfig, checkpointState.getAssignedSplits());
    }

    public SourceReader<SeaTunnelRow, FakeSourceSplit> createReader(SourceReader.Context readerContext) {
        return new FakeSourceReader(readerContext, this.multipleTableFakeSourceConfig);
    }

    public String getPluginName() {
        return "FakeSource";
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}

