/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class PlacementConstraints {
    public static final String NODE = "node";
    public static final String RACK = "rack";
    public static final String NODE_PARTITION = "yarn_node_partition/";

    private PlacementConstraints() {
    }

    public static PlacementConstraint.AbstractConstraint targetIn(String scope, PlacementConstraint.TargetExpression ... targetExpressions) {
        return new PlacementConstraint.SingleConstraint(scope, 1, Integer.MAX_VALUE, targetExpressions);
    }

    public static PlacementConstraint.AbstractConstraint targetNotIn(String scope, PlacementConstraint.TargetExpression ... targetExpressions) {
        return new PlacementConstraint.SingleConstraint(scope, 0, 0, targetExpressions);
    }

    public static PlacementConstraint.AbstractConstraint cardinality(String scope, int minCardinality, int maxCardinality, String ... allocationTags) {
        return new PlacementConstraint.SingleConstraint(scope, minCardinality, maxCardinality, PlacementTargets.allocationTag(allocationTags));
    }

    public static PlacementConstraint.AbstractConstraint cardinality(String scope, String namespace, int minCardinality, int maxCardinality, String ... allocationTags) {
        return new PlacementConstraint.SingleConstraint(scope, minCardinality, maxCardinality, PlacementTargets.allocationTagWithNamespace(namespace, allocationTags));
    }

    public static PlacementConstraint.AbstractConstraint minCardinality(String scope, int minCardinality, String ... allocationTags) {
        return PlacementConstraints.cardinality(scope, minCardinality, Integer.MAX_VALUE, allocationTags);
    }

    public static PlacementConstraint.AbstractConstraint minCardinality(String scope, String namespace, int minCardinality, String ... allocationTags) {
        return PlacementConstraints.cardinality(scope, namespace, minCardinality, Integer.MAX_VALUE, allocationTags);
    }

    public static PlacementConstraint.AbstractConstraint maxCardinality(String scope, int maxCardinality, String ... allocationTags) {
        return PlacementConstraints.cardinality(scope, 0, maxCardinality, allocationTags);
    }

    public static PlacementConstraint.AbstractConstraint maxCardinality(String scope, String tagNamespace, int maxCardinality, String ... allocationTags) {
        return PlacementConstraints.cardinality(scope, tagNamespace, 0, maxCardinality, allocationTags);
    }

    public static PlacementConstraint.AbstractConstraint targetCardinality(String scope, int minCardinality, int maxCardinality, PlacementConstraint.TargetExpression ... targetExpressions) {
        return new PlacementConstraint.SingleConstraint(scope, minCardinality, maxCardinality, targetExpressions);
    }

    public static PlacementConstraint.And and(PlacementConstraint.AbstractConstraint ... children) {
        return new PlacementConstraint.And(children);
    }

    public static PlacementConstraint.Or or(PlacementConstraint.AbstractConstraint ... children) {
        return new PlacementConstraint.Or(children);
    }

    public static PlacementConstraint.DelayedOr delayedOr(PlacementConstraint.TimedPlacementConstraint ... children) {
        return new PlacementConstraint.DelayedOr(children);
    }

    public static PlacementConstraint.TimedPlacementConstraint timedClockConstraint(PlacementConstraint.AbstractConstraint constraint, long delay, TimeUnit timeUnit) {
        return new PlacementConstraint.TimedPlacementConstraint(constraint, timeUnit.toMillis(delay), PlacementConstraint.TimedPlacementConstraint.DelayUnit.MILLISECONDS);
    }

    public static PlacementConstraint.TimedPlacementConstraint timedOpportunitiesConstraint(PlacementConstraint.AbstractConstraint constraint, long delay) {
        return new PlacementConstraint.TimedPlacementConstraint(constraint, delay, PlacementConstraint.TimedPlacementConstraint.DelayUnit.OPPORTUNITIES);
    }

    public static PlacementConstraint build(PlacementConstraint.AbstractConstraint constraintExpr) {
        return constraintExpr.build();
    }

    public static class PlacementTargets {
        public static PlacementConstraint.TargetExpression nodeAttribute(String attributeKey, String ... attributeValues) {
            return new PlacementConstraint.TargetExpression(PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE, attributeKey, attributeValues);
        }

        public static PlacementConstraint.TargetExpression nodePartition(String ... nodePartitions) {
            return new PlacementConstraint.TargetExpression(PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE, PlacementConstraints.NODE_PARTITION, nodePartitions);
        }

        public static PlacementConstraint.TargetExpression allocationTag(String ... allocationTags) {
            return PlacementTargets.allocationTagWithNamespace(AllocationTagNamespaceType.SELF.toString(), allocationTags);
        }

        public static PlacementConstraint.TargetExpression allocationTagWithNamespace(String namespace, String ... allocationTags) {
            return new PlacementConstraint.TargetExpression(PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG, namespace, allocationTags);
        }
    }
}

