/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.TextFormat;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class CollectorInfoPBImpl
extends CollectorInfo {
    private YarnProtos.CollectorInfoProto proto = YarnProtos.CollectorInfoProto.getDefaultInstance();
    private YarnProtos.CollectorInfoProto.Builder builder = null;
    private boolean viaProto = false;
    private String collectorAddr = null;
    private Token collectorToken = null;

    public CollectorInfoPBImpl() {
        this.builder = YarnProtos.CollectorInfoProto.newBuilder();
    }

    public CollectorInfoPBImpl(YarnProtos.CollectorInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.CollectorInfoProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.CollectorInfoProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((CollectorInfoPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    @Override
    public String getCollectorAddr() {
        YarnProtos.CollectorInfoProtoOrBuilder p;
        YarnProtos.CollectorInfoProtoOrBuilder collectorInfoProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.collectorAddr == null && p.hasCollectorAddr()) {
            this.collectorAddr = p.getCollectorAddr();
        }
        return this.collectorAddr;
    }

    @Override
    public void setCollectorAddr(String addr) {
        this.maybeInitBuilder();
        if (this.collectorAddr == null) {
            this.builder.clearCollectorAddr();
        }
        this.collectorAddr = addr;
    }

    @Override
    public Token getCollectorToken() {
        YarnProtos.CollectorInfoProtoOrBuilder p;
        YarnProtos.CollectorInfoProtoOrBuilder collectorInfoProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.collectorToken != null) {
            return this.collectorToken;
        }
        if (!p.hasCollectorToken()) {
            return null;
        }
        this.collectorToken = this.convertFromProtoFormat(p.getCollectorToken());
        return this.collectorToken;
    }

    @Override
    public void setCollectorToken(Token token) {
        this.maybeInitBuilder();
        if (token == null) {
            this.builder.clearCollectorToken();
        }
        this.collectorToken = token;
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private void mergeLocalToBuilder() {
        if (this.collectorAddr != null) {
            this.builder.setCollectorAddr(this.collectorAddr);
        }
        if (this.collectorToken != null) {
            this.builder.setCollectorToken(this.convertToProtoFormat(this.collectorToken));
        }
    }
}

