/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.table;

import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.table.TableMergeConfig;

public class TableMergeTransform
extends AbstractCatalogSupportMapTransform {
    public static String PLUGIN_NAME = "TableMerge";
    private final CatalogTable inputTable;
    private final TablePath outputTablePath;
    private final String outputTableId;

    public TableMergeTransform(TableMergeConfig config, CatalogTable table) {
        super(table);
        this.inputTable = table;
        this.outputTablePath = config.getTablePath();
        this.outputTableId = config.getTablePath().getFullName();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected TableSchema transformTableSchema() {
        return this.inputTable.getTableSchema();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return TableIdentifier.of((String)this.inputTable.getTableId().getCatalogName(), (TablePath)this.outputTablePath);
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        if (inputRow.getTableId() == null || !this.outputTableId.equals(inputRow.getTableId())) {
            inputRow.setTableId(this.outputTableId);
        }
        return inputRow;
    }
}

