/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.filter.FilterFieldTransformConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFieldTransform
extends AbstractCatalogSupportMapTransform {
    private static final Logger log = LoggerFactory.getLogger(FilterFieldTransform.class);
    public static final String PLUGIN_NAME = "Filter";
    private int[] inputValueIndexList;
    private final List<String> includeFields;
    private final List<String> excludeFields;

    public FilterFieldTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.includeFields = (List)config.get(FilterFieldTransformConfig.INCLUDE_FIELDS);
        this.excludeFields = (List)config.get(FilterFieldTransformConfig.EXCLUDE_FIELDS);
        ConfigValidator.of((ReadonlyConfig)config).validate(OptionRule.builder().exclusive(new Option[]{FilterFieldTransformConfig.INCLUDE_FIELDS, FilterFieldTransformConfig.EXCLUDE_FIELDS}).build());
        List<String> canNotFoundFields = Stream.concat(((List)Optional.ofNullable(this.includeFields).orElse(new ArrayList())).stream(), ((List)Optional.ofNullable(this.excludeFields).orElse(new ArrayList())).stream()).filter(field -> seaTunnelRowType.indexOf(field, false) == -1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(canNotFoundFields)) {
            throw TransformCommonError.cannotFindInputFieldsError(this.getPluginName(), canNotFoundFields);
        }
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        return inputRow.copy(this.inputValueIndexList);
    }

    @Override
    protected TableSchema transformTableSchema() {
        ArrayList<Column> outputColumns = new ArrayList<Column>();
        SeaTunnelRowType seaTunnelRowType = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType();
        ArrayList<String> outputFieldNames = new ArrayList<String>();
        List inputColumns = this.inputCatalogTable.getTableSchema().getColumns();
        if (Objects.nonNull(this.includeFields)) {
            this.inputValueIndexList = new int[this.includeFields.size()];
            for (int i = 0; i < this.includeFields.size(); ++i) {
                int inputFieldIndex;
                String fieldName = this.includeFields.get(i);
                this.inputValueIndexList[i] = inputFieldIndex = seaTunnelRowType.indexOf(fieldName);
                outputColumns.add(((Column)inputColumns.get(inputFieldIndex)).copy());
                outputFieldNames.add(((Column)inputColumns.get(inputFieldIndex)).getName());
            }
        }
        if (Objects.nonNull(this.excludeFields)) {
            this.inputValueIndexList = new int[inputColumns.size() - this.excludeFields.size()];
            int index = 0;
            for (int i = 0; i < inputColumns.size(); ++i) {
                if (this.excludeFields.contains(((Column)inputColumns.get(i)).getName())) continue;
                String fieldName = ((Column)inputColumns.get(i)).getName();
                int inputFieldIndex = seaTunnelRowType.indexOf(fieldName);
                this.inputValueIndexList[index++] = inputFieldIndex;
                outputColumns.add(((Column)inputColumns.get(i)).copy());
                outputFieldNames.add(((Column)inputColumns.get(i)).getName());
            }
        }
        List outputConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> {
            List constraintColumnNames = key.getColumnNames().stream().map(ConstraintKey.ConstraintKeyColumn::getColumnName).collect(Collectors.toList());
            return outputFieldNames.containsAll(constraintColumnNames);
        }).map(ConstraintKey::copy).collect(Collectors.toList());
        PrimaryKey copiedPrimaryKey = null;
        PrimaryKey primaryKey = this.inputCatalogTable.getTableSchema().getPrimaryKey();
        if (primaryKey != null && outputFieldNames.containsAll(primaryKey.getColumnNames())) {
            copiedPrimaryKey = primaryKey.copy();
        }
        return TableSchema.builder().columns(outputColumns).primaryKey(copiedPrimaryKey).constraintKey(outputConstraintKeys).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }
}

