/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.common.TransformCommonOptions;

public abstract class AbstractMultiCatalogTransform
implements SeaTunnelTransform<SeaTunnelRow> {
    protected List<CatalogTable> inputCatalogTables;
    protected List<CatalogTable> outputCatalogTables;
    protected Map<String, SeaTunnelTransform<SeaTunnelRow>> transformMap;

    public AbstractMultiCatalogTransform(List<CatalogTable> inputCatalogTables, ReadonlyConfig config) {
        this.inputCatalogTables = inputCatalogTables;
        this.transformMap = new HashMap<String, SeaTunnelTransform<SeaTunnelRow>>();
        Pattern tableMatchRegex = Pattern.compile((String)config.get(TransformCommonOptions.TABLE_MATCH_REGEX));
        Map singleTableConfig = ((List)config.get(TransformCommonOptions.MULTI_TABLES)).stream().map(ReadonlyConfig::fromMap).filter(c -> c.get(TransformCommonOptions.TABLE_PATH) != null).collect(Collectors.toMap(c -> (String)c.get(TransformCommonOptions.TABLE_PATH), Function.identity()));
        inputCatalogTables.forEach(inputCatalogTable -> {
            String tableId = inputCatalogTable.getTableId().toTablePath().toString();
            Object tableConfig = singleTableConfig.containsKey(tableId) ? (ReadonlyConfig)singleTableConfig.get(tableId) : (tableMatchRegex.matcher(tableId).matches() ? config : null);
            if (tableConfig != null) {
                this.transformMap.put(tableId, this.buildTransform((CatalogTable)inputCatalogTable, (ReadonlyConfig)tableConfig));
            } else {
                this.transformMap.put(tableId, new IdentityTransform((CatalogTable)inputCatalogTable));
            }
        });
        this.outputCatalogTables = inputCatalogTables.stream().map(inputCatalogTable -> {
            String tableName = inputCatalogTable.getTableId().toTablePath().toString();
            return this.transformMap.get(tableName).getProducedCatalogTable();
        }).collect(Collectors.toList());
    }

    protected abstract SeaTunnelTransform<SeaTunnelRow> buildTransform(CatalogTable var1, ReadonlyConfig var2);

    public List<CatalogTable> getProducedCatalogTables() {
        return this.outputCatalogTables;
    }

    public CatalogTable getProducedCatalogTable() {
        return this.outputCatalogTables.get(0);
    }

    public void setTypeInfo(SeaTunnelDataType<SeaTunnelRow> inputDataType) {
    }

    public static class IdentityTransform
    extends AbstractCatalogSupportMapTransform {
        private final CatalogTable catalogTable;

        public String getPluginName() {
            return "Identity";
        }

        public IdentityTransform(CatalogTable catalogTable) {
            super(catalogTable);
            this.catalogTable = catalogTable;
        }

        @Override
        protected SeaTunnelRow transformRow(SeaTunnelRow row) {
            return row;
        }

        @Override
        protected TableSchema transformTableSchema() {
            return this.catalogTable.getTableSchema();
        }

        @Override
        protected TableIdentifier transformTableIdentifier() {
            return this.catalogTable.getTableId();
        }

        public void setTypeInfo(SeaTunnelDataType<SeaTunnelRow> inputDataType) {
        }
    }
}

