/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.factory;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.AuthenticationEvaluator;
import org.apache.rocketmq.auth.authentication.context.AuthenticationContext;
import org.apache.rocketmq.auth.authentication.manager.AuthenticationMetadataManager;
import org.apache.rocketmq.auth.authentication.manager.AuthenticationMetadataManagerImpl;
import org.apache.rocketmq.auth.authentication.provider.AuthenticationMetadataProvider;
import org.apache.rocketmq.auth.authentication.provider.AuthenticationProvider;
import org.apache.rocketmq.auth.authentication.provider.DefaultAuthenticationProvider;
import org.apache.rocketmq.auth.authentication.strategy.AuthenticationStrategy;
import org.apache.rocketmq.auth.authentication.strategy.StatelessAuthenticationStrategy;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AuthenticationFactory {
    private static final Map<String, Object> INSTANCE_MAP = new HashMap<String, Object>();
    private static final String PROVIDER_PREFIX = "PROVIDER_";
    private static final String METADATA_PROVIDER_PREFIX = "METADATA_PROVIDER_";
    private static final String EVALUATOR_PREFIX = "EVALUATOR_";

    public static AuthenticationProvider<AuthenticationContext> getProvider(AuthConfig config) {
        if (config == null) {
            return null;
        }
        return AuthenticationFactory.computeIfAbsent(PROVIDER_PREFIX + config.getConfigName(), key -> {
            try {
                Class clazz = DefaultAuthenticationProvider.class;
                if (StringUtils.isNotBlank((CharSequence)config.getAuthenticationProvider())) {
                    clazz = Class.forName(config.getAuthenticationProvider());
                }
                return (AuthenticationProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load the authentication provider.", e);
            }
        });
    }

    public static AuthenticationMetadataProvider getMetadataProvider(AuthConfig config) {
        return AuthenticationFactory.getMetadataProvider(config, null);
    }

    public static AuthenticationMetadataManager getMetadataManager(AuthConfig config) {
        return new AuthenticationMetadataManagerImpl(config);
    }

    public static AuthenticationMetadataProvider getMetadataProvider(AuthConfig config, Supplier<?> metadataService) {
        if (config == null) {
            return null;
        }
        return AuthenticationFactory.computeIfAbsent(METADATA_PROVIDER_PREFIX + config.getConfigName(), key -> {
            try {
                if (StringUtils.isBlank((CharSequence)config.getAuthenticationMetadataProvider())) {
                    return null;
                }
                Class<?> clazz = Class.forName(config.getAuthenticationMetadataProvider());
                AuthenticationMetadataProvider result = (AuthenticationMetadataProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result.initialize(config, metadataService);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load the authentication metadata provider", e);
            }
        });
    }

    public static AuthenticationEvaluator getEvaluator(AuthConfig config) {
        return AuthenticationFactory.computeIfAbsent(EVALUATOR_PREFIX + config.getConfigName(), key -> new AuthenticationEvaluator(config));
    }

    public static AuthenticationEvaluator getEvaluator(AuthConfig config, Supplier<?> metadataService) {
        return AuthenticationFactory.computeIfAbsent(EVALUATOR_PREFIX + config.getConfigName(), key -> new AuthenticationEvaluator(config, metadataService));
    }

    public static AuthenticationStrategy getStrategy(AuthConfig config, Supplier<?> metadataService) {
        try {
            Class clazz = StatelessAuthenticationStrategy.class;
            if (StringUtils.isNotBlank((CharSequence)config.getAuthenticationStrategy())) {
                clazz = Class.forName(config.getAuthenticationStrategy());
            }
            return (AuthenticationStrategy)clazz.getDeclaredConstructor(AuthConfig.class, Supplier.class).newInstance(config, metadataService);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AuthenticationContext newContext(AuthConfig config, Metadata metadata, GeneratedMessageV3 request) {
        AuthenticationProvider<AuthenticationContext> authenticationProvider = AuthenticationFactory.getProvider(config);
        if (authenticationProvider == null) {
            return null;
        }
        return authenticationProvider.newContext(metadata, request);
    }

    public static AuthenticationContext newContext(AuthConfig config, ChannelHandlerContext context, RemotingCommand command) {
        AuthenticationProvider<AuthenticationContext> authenticationProvider = AuthenticationFactory.getProvider(config);
        if (authenticationProvider == null) {
            return null;
        }
        return authenticationProvider.newContext(context, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V computeIfAbsent(String key, Function<String, ? extends V> function) {
        Object result = null;
        if (INSTANCE_MAP.containsKey(key)) {
            result = INSTANCE_MAP.get(key);
        }
        if (result == null) {
            Map<String, Object> map = INSTANCE_MAP;
            synchronized (map) {
                if (INSTANCE_MAP.containsKey(key)) {
                    result = INSTANCE_MAP.get(key);
                }
                if (result == null && (result = function.apply(key)) != null) {
                    INSTANCE_MAP.put(key, result);
                }
            }
        }
        return (V)(result != null ? result : null);
    }
}

