/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidator
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordValidator.class);
    private static String validatorProgram = null;
    private static List<String> adminUserList;
    private static String adminRoleNames;
    private Socket client;

    public PasswordValidator(Socket client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BufferedReader reader = null;
        PrintWriter writer = null;
        String userName = null;
        try {
            String line;
            int passwordAt;
            reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            writer = new PrintWriter(new OutputStreamWriter(this.client.getOutputStream()));
            String request = reader.readLine();
            if (request.startsWith("LOGIN:") && (passwordAt = (line = request.substring(6).trim()).indexOf(32)) != -1) {
                userName = line.substring(0, passwordAt).trim();
            }
            if (validatorProgram == null) {
                String res = "FAILED: Unable to validate credentials.";
                writer.println(res);
                writer.flush();
                LOG.error("Response [" + res + "] for user: " + userName + " as ValidatorProgram is not defined in configuration.");
                return;
            }
            BufferedReader pReader = null;
            PrintWriter pWriter = null;
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(validatorProgram);
                pReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                pWriter = new PrintWriter(new OutputStreamWriter(p.getOutputStream()));
                pWriter.println(request);
                pWriter.flush();
                String res = pReader.readLine();
                if (res != null && res.startsWith("OK") && adminRoleNames != null && adminUserList != null && adminUserList.contains(userName)) {
                    res = res + " " + adminRoleNames;
                }
                LOG.info("Response [" + res + "] for user: " + userName);
                writer.println(res);
                writer.flush();
                return;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
        }
        catch (Throwable t) {
            if (userName == null) return;
            if (writer == null) return;
            String res = "FAILED: unable to validate due to error " + t.getMessage();
            writer.println(res);
            LOG.error("Response [" + res + "] for user: " + userName + ", " + t.getMessage());
            return;
        }
        finally {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException ioe) {
                LOG.debug("Close socket failure. Detail: \n", (Throwable)ioe);
            }
            finally {
                this.client = null;
            }
        }
    }

    public static String getValidatorProgram() {
        return validatorProgram;
    }

    public static void setValidatorProgram(String validatorProgram) {
        PasswordValidator.validatorProgram = validatorProgram;
    }

    public static List<String> getAdminUserList() {
        return adminUserList;
    }

    public static void setAdminUserList(List<String> adminUserList) {
        PasswordValidator.adminUserList = adminUserList;
    }

    public static String getAdminRoleNames() {
        return adminRoleNames;
    }

    public static void setAdminRoleNames(String adminRoleNames) {
        PasswordValidator.adminRoleNames = adminRoleNames;
    }
}

