/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIFileServer;
import com.microsoft.azure.management.batchai.BatchAIFileServers;
import com.microsoft.azure.management.batchai.implementation.BatchAIFileServerImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.BatchAIWorkspaceImpl;
import com.microsoft.azure.management.batchai.implementation.FileServerInner;
import com.microsoft.azure.management.batchai.implementation.FileServersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIFileServersImpl
extends CreatableResourcesImpl<BatchAIFileServer, BatchAIFileServerImpl, FileServerInner>
implements BatchAIFileServers {
    private final BatchAIWorkspaceImpl workspace;

    BatchAIFileServersImpl(BatchAIWorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public BatchAIFileServerImpl define(String name) {
        return this.wrapModel(name);
    }

    protected BatchAIFileServerImpl wrapModel(String name) {
        FileServerInner inner = new FileServerInner();
        return new BatchAIFileServerImpl(name, this.workspace, inner);
    }

    protected BatchAIFileServerImpl wrapModel(FileServerInner inner) {
        if (inner == null) {
            return null;
        }
        return new BatchAIFileServerImpl(inner.name(), this.workspace, inner);
    }

    public PagedList<BatchAIFileServer> list() {
        return this.wrapList(this.inner().listByWorkspace(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public Observable<BatchAIFileServer> listAsync() {
        return this.wrapPageAsync(this.inner().listByWorkspaceAsync(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public BatchAIFileServerImpl getById(String id) {
        return (BatchAIFileServerImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<BatchAIFileServer> getByIdAsync(String id) {
        String fileServerName = ResourceId.fromString((String)id).name();
        return ((BatchAIManagementClientImpl)((Object)this.manager().inner())).fileServers().getAsync(this.workspace.resourceGroupName(), this.workspace.name(), fileServerName).map((Func1)new Func1<FileServerInner, BatchAIFileServer>(){

            public BatchAIFileServer call(FileServerInner fileServerInner) {
                if (fileServerInner == null) {
                    return null;
                }
                return new BatchAIFileServerImpl(fileServerInner.name(), BatchAIFileServersImpl.this.workspace, fileServerInner);
            }
        });
    }

    public ServiceFuture<BatchAIFileServer> getByIdAsync(String id, ServiceCallback<BatchAIFileServer> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public BatchAIManager manager() {
        return (BatchAIManager)this.workspace.manager();
    }

    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), this.workspace.name(), resourceId.name()).toCompletable();
    }

    public FileServersInner inner() {
        return ((BatchAIManagementClientImpl)((Object)this.manager().inner())).fileServers();
    }

    public Observable<BatchAIFileServer> getByNameAsync(String name) {
        return this.inner().getAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).map((Func1)new Func1<FileServerInner, BatchAIFileServer>(){

            public BatchAIFileServer call(FileServerInner inner) {
                return BatchAIFileServersImpl.this.wrapModel(inner);
            }
        });
    }

    public BatchAIFileServerImpl getByName(String name) {
        return (BatchAIFileServerImpl)this.getByNameAsync(name).toBlocking().single();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromResponse(this.inner().deleteWithServiceResponseAsync(this.workspace.resourceGroupName(), this.workspace.name(), name), callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).toCompletable();
    }
}

