/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.redis.CheckNameAvailabilityParameters;
import com.microsoft.azure.management.redis.ExportRDBParameters;
import com.microsoft.azure.management.redis.ImportRDBParameters;
import com.microsoft.azure.management.redis.RedisCreateParameters;
import com.microsoft.azure.management.redis.RedisKeyType;
import com.microsoft.azure.management.redis.RedisRebootParameters;
import com.microsoft.azure.management.redis.RedisRegenerateKeyParameters;
import com.microsoft.azure.management.redis.RedisUpdateParameters;
import com.microsoft.azure.management.redis.implementation.NotificationListResponseInner;
import com.microsoft.azure.management.redis.implementation.PageImpl;
import com.microsoft.azure.management.redis.implementation.RedisAccessKeysInner;
import com.microsoft.azure.management.redis.implementation.RedisForceRebootResponseInner;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.redis.implementation.RedisResourceInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RedisInner
implements InnerSupportsGet<RedisResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<RedisResourceInner> {
    private RedisService service;
    private RedisManagementClientImpl client;

    public RedisInner(Retrofit retrofit, RedisManagementClientImpl client) {
        this.service = (RedisService)retrofit.create(RedisService.class);
        this.client = client;
    }

    public void checkNameAvailability(CheckNameAvailabilityParameters parameters) {
        ((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> checkNameAvailabilityAsync(CheckNameAvailabilityParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<Void> checkNameAvailabilityAsync(CheckNameAvailabilityParameters parameters) {
        return this.checkNameAvailabilityWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> checkNameAvailabilityWithServiceResponseAsync(CheckNameAvailabilityParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.checkNameAvailability(this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NotificationListResponseInner listUpgradeNotifications(String resourceGroupName, String name, double history) {
        return (NotificationListResponseInner)((ServiceResponse)this.listUpgradeNotificationsWithServiceResponseAsync(resourceGroupName, name, history).toBlocking().single()).body();
    }

    public ServiceFuture<NotificationListResponseInner> listUpgradeNotificationsAsync(String resourceGroupName, String name, double history, ServiceCallback<NotificationListResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUpgradeNotificationsWithServiceResponseAsync(resourceGroupName, name, history), serviceCallback);
    }

    public Observable<NotificationListResponseInner> listUpgradeNotificationsAsync(String resourceGroupName, String name, double history) {
        return this.listUpgradeNotificationsWithServiceResponseAsync(resourceGroupName, name, history).map((Func1)new Func1<ServiceResponse<NotificationListResponseInner>, NotificationListResponseInner>(){

            public NotificationListResponseInner call(ServiceResponse<NotificationListResponseInner> response) {
                return (NotificationListResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<NotificationListResponseInner>> listUpgradeNotificationsWithServiceResponseAsync(String resourceGroupName, String name, double history) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listUpgradeNotifications(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), history, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NotificationListResponseInner>>>(){

            public Observable<ServiceResponse<NotificationListResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.listUpgradeNotificationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NotificationListResponseInner> listUpgradeNotificationsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NotificationListResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisResourceInner create(String resourceGroupName, String name, RedisCreateParameters parameters) {
        return (RedisResourceInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<RedisResourceInner> createAsync(String resourceGroupName, String name, RedisCreateParameters parameters, ServiceCallback<RedisResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<RedisResourceInner> createAsync(String resourceGroupName, String name, RedisCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<RedisResourceInner>, RedisResourceInner>(){

            public RedisResourceInner call(ServiceResponse<RedisResourceInner> response) {
                return (RedisResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RedisResourceInner>> createWithServiceResponseAsync(String resourceGroupName, String name, RedisCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RedisResourceInner>(){}.getType());
    }

    public RedisResourceInner beginCreate(String resourceGroupName, String name, RedisCreateParameters parameters) {
        return (RedisResourceInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<RedisResourceInner> beginCreateAsync(String resourceGroupName, String name, RedisCreateParameters parameters, ServiceCallback<RedisResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<RedisResourceInner> beginCreateAsync(String resourceGroupName, String name, RedisCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<RedisResourceInner>, RedisResourceInner>(){

            public RedisResourceInner call(ServiceResponse<RedisResourceInner> response) {
                return (RedisResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RedisResourceInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String name, RedisCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisResourceInner>>>(){

            public Observable<ServiceResponse<RedisResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisResourceInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisResourceInner>(){}.getType()).register(201, new TypeToken<RedisResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisResourceInner update(String resourceGroupName, String name, RedisUpdateParameters parameters) {
        return (RedisResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<RedisResourceInner> updateAsync(String resourceGroupName, String name, RedisUpdateParameters parameters, ServiceCallback<RedisResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<RedisResourceInner> updateAsync(String resourceGroupName, String name, RedisUpdateParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<RedisResourceInner>, RedisResourceInner>(){

            public RedisResourceInner call(ServiceResponse<RedisResourceInner> response) {
                return (RedisResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RedisResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String name, RedisUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisResourceInner>>>(){

            public Observable<ServiceResponse<RedisResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisResourceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String name) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String name) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String name) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String name) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisResourceInner getByResourceGroup(String resourceGroupName, String name) {
        return (RedisResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body());
    }

    public ServiceFuture<RedisResourceInner> getByResourceGroupAsync(String resourceGroupName, String name, ServiceCallback<RedisResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<RedisResourceInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<RedisResourceInner>, RedisResourceInner>(){

            public RedisResourceInner call(ServiceResponse<RedisResourceInner> response) {
                return (RedisResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RedisResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisResourceInner>>>(){

            public Observable<ServiceResponse<RedisResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisResourceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RedisResourceInner>((Page)response.body()){

            public Page<RedisResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RedisInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisResourceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<RedisResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(String nextPageLink) {
                return RedisInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Page<RedisResourceInner>>(){

            public Page<RedisResourceInner> call(ServiceResponse<Page<RedisResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(ServiceResponse<Page<RedisResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RedisInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RedisInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisResourceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RedisResourceInner>((Page)response.body()){

            public Page<RedisResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RedisInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisResourceInner>> listAsync(ListOperationCallback<RedisResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(String nextPageLink) {
                return RedisInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Page<RedisResourceInner>>(){

            public Page<RedisResourceInner> call(ServiceResponse<Page<RedisResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(ServiceResponse<Page<RedisResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RedisInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RedisInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisAccessKeysInner listKeys(String resourceGroupName, String name) {
        return (RedisAccessKeysInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<RedisAccessKeysInner> listKeysAsync(String resourceGroupName, String name, ServiceCallback<RedisAccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<RedisAccessKeysInner> listKeysAsync(String resourceGroupName, String name) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<RedisAccessKeysInner>, RedisAccessKeysInner>(){

            public RedisAccessKeysInner call(ServiceResponse<RedisAccessKeysInner> response) {
                return (RedisAccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisAccessKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisAccessKeysInner>>>(){

            public Observable<ServiceResponse<RedisAccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisAccessKeysInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisAccessKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisAccessKeysInner regenerateKey(String resourceGroupName, String name, RedisKeyType keyType) {
        return (RedisAccessKeysInner)((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, name, keyType).toBlocking().single()).body();
    }

    public ServiceFuture<RedisAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String name, RedisKeyType keyType, ServiceCallback<RedisAccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, name, keyType), serviceCallback);
    }

    public Observable<RedisAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String name, RedisKeyType keyType) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, name, keyType).map((Func1)new Func1<ServiceResponse<RedisAccessKeysInner>, RedisAccessKeysInner>(){

            public RedisAccessKeysInner call(ServiceResponse<RedisAccessKeysInner> response) {
                return (RedisAccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisAccessKeysInner>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String name, RedisKeyType keyType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyType == null) {
            throw new IllegalArgumentException("Parameter keyType is required and cannot be null.");
        }
        RedisRegenerateKeyParameters parameters = new RedisRegenerateKeyParameters();
        parameters.withKeyType(keyType);
        return this.service.regenerateKey(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisAccessKeysInner>>>(){

            public Observable<ServiceResponse<RedisAccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.regenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisAccessKeysInner> regenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisAccessKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisForceRebootResponseInner forceReboot(String resourceGroupName, String name, RedisRebootParameters parameters) {
        return (RedisForceRebootResponseInner)((ServiceResponse)this.forceRebootWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<RedisForceRebootResponseInner> forceRebootAsync(String resourceGroupName, String name, RedisRebootParameters parameters, ServiceCallback<RedisForceRebootResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.forceRebootWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<RedisForceRebootResponseInner> forceRebootAsync(String resourceGroupName, String name, RedisRebootParameters parameters) {
        return this.forceRebootWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<RedisForceRebootResponseInner>, RedisForceRebootResponseInner>(){

            public RedisForceRebootResponseInner call(ServiceResponse<RedisForceRebootResponseInner> response) {
                return (RedisForceRebootResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisForceRebootResponseInner>> forceRebootWithServiceResponseAsync(String resourceGroupName, String name, RedisRebootParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.forceReboot(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisForceRebootResponseInner>>>(){

            public Observable<ServiceResponse<RedisForceRebootResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.forceRebootDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisForceRebootResponseInner> forceRebootDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisForceRebootResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void importData(String resourceGroupName, String name, ImportRDBParameters parameters) {
        ((ServiceResponse)this.importDataWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> importDataAsync(String resourceGroupName, String name, ImportRDBParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.importDataWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<Void> importDataAsync(String resourceGroupName, String name, ImportRDBParameters parameters) {
        return this.importDataWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> importDataWithServiceResponseAsync(String resourceGroupName, String name, ImportRDBParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.importData(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginImportData(String resourceGroupName, String name, ImportRDBParameters parameters) {
        ((ServiceResponse)this.beginImportDataWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginImportDataAsync(String resourceGroupName, String name, ImportRDBParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginImportDataWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<Void> beginImportDataAsync(String resourceGroupName, String name, ImportRDBParameters parameters) {
        return this.beginImportDataWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginImportDataWithServiceResponseAsync(String resourceGroupName, String name, ImportRDBParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginImportData(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.beginImportDataDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginImportDataDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void exportData(String resourceGroupName, String name, ExportRDBParameters parameters) {
        ((ServiceResponse)this.exportDataWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> exportDataAsync(String resourceGroupName, String name, ExportRDBParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportDataWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<Void> exportDataAsync(String resourceGroupName, String name, ExportRDBParameters parameters) {
        return this.exportDataWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> exportDataWithServiceResponseAsync(String resourceGroupName, String name, ExportRDBParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.exportData(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginExportData(String resourceGroupName, String name, ExportRDBParameters parameters) {
        ((ServiceResponse)this.beginExportDataWithServiceResponseAsync(resourceGroupName, name, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginExportDataAsync(String resourceGroupName, String name, ExportRDBParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginExportDataWithServiceResponseAsync(resourceGroupName, name, parameters), serviceCallback);
    }

    public Observable<Void> beginExportDataAsync(String resourceGroupName, String name, ExportRDBParameters parameters) {
        return this.beginExportDataWithServiceResponseAsync(resourceGroupName, name, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginExportDataWithServiceResponseAsync(String resourceGroupName, String name, ExportRDBParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginExportData(resourceGroupName, name, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RedisInner.this.beginExportDataDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginExportDataDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisResourceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisResourceInner>((Page)response.body()){

            public Page<RedisResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RedisInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisResourceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<RedisResourceInner>> serviceFuture, ListOperationCallback<RedisResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(String nextPageLink) {
                return RedisInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisResourceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Page<RedisResourceInner>>(){

            public Page<RedisResourceInner> call(ServiceResponse<Page<RedisResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(ServiceResponse<Page<RedisResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RedisInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RedisInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisResourceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisResourceInner>((Page)response.body()){

            public Page<RedisResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RedisInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisResourceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RedisResourceInner>> serviceFuture, ListOperationCallback<RedisResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(String nextPageLink) {
                return RedisInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisResourceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Page<RedisResourceInner>>(){

            public Page<RedisResourceInner> call(ServiceResponse<Page<RedisResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RedisResourceInner>>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(ServiceResponse<Page<RedisResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RedisInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisResourceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisResourceInner>>>>(){

            public Observable<ServiceResponse<Page<RedisResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RedisInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisResourceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RedisService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Cache/CheckNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Body CheckNameAvailabilityParameters var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis listUpgradeNotifications"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/listUpgradeNotifications")
        public Observable<Response<ResponseBody>> listUpgradeNotifications(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="history") double var5, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body RedisCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body RedisCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body RedisUpdateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Cache/Redis")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RedisRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis forceReboot"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/forceReboot")
        public Observable<Response<ResponseBody>> forceReboot(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body RedisRebootParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis importData"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/import")
        public Observable<Response<ResponseBody>> importData(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body ImportRDBParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis beginImportData"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/import")
        public Observable<Response<ResponseBody>> beginImportData(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body ImportRDBParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis exportData"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/export")
        public Observable<Response<ResponseBody>> exportData(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body ExportRDBParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis beginExportData"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/export")
        public Observable<Response<ResponseBody>> beginExportData(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Body ExportRDBParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.Redis listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

