/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ReplicationLinksInner {
    private ReplicationLinksService service;
    private SqlManagementClientImpl client;

    public ReplicationLinksInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ReplicationLinksService)retrofit.create(ReplicationLinksService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String serverName, String databaseName, String linkId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationLinksInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ReplicationLinkInner get(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return (ReplicationLinkInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().single()).body();
    }

    public ServiceFuture<ReplicationLinkInner> getAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<ReplicationLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<ReplicationLinkInner> getAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<ReplicationLinkInner>, ReplicationLinkInner>(){

            public ReplicationLinkInner call(ServiceResponse<ReplicationLinkInner> response) {
                return (ReplicationLinkInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ReplicationLinkInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationLinkInner>>>(){

            public Observable<ServiceResponse<ReplicationLinkInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationLinksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ReplicationLinkInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ReplicationLinkInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failover(String resourceGroupName, String serverName, String databaseName, String linkId) {
        ((ServiceResponse)this.failoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<Void> failoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.failoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.failover(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailover(String resourceGroupName, String serverName, String databaseName, String linkId) {
        ((ServiceResponse)this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<Void> beginFailoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.beginFailover(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationLinksInner.this.beginFailoverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) {
        ((ServiceResponse)this.failoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<Void> failoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.failoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.failoverAllowDataLoss(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) {
        ((ServiceResponse)this.beginFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId), serviceCallback);
    }

    public Observable<Void> beginFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        return this.beginFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, databaseName, linkId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String linkId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (linkId == null) {
            throw new IllegalArgumentException("Parameter linkId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.beginFailoverAllowDataLoss(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, linkId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationLinksInner.this.beginFailoverAllowDataLossDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverAllowDataLossDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ReplicationLinkInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ReplicationLinkInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<ReplicationLinkInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<ReplicationLinkInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<ReplicationLinkInner>>, List<ReplicationLinkInner>>(){

            public List<ReplicationLinkInner> call(ServiceResponse<List<ReplicationLinkInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ReplicationLinkInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByDatabase(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ReplicationLinkInner>>>>(){

            public Observable<ServiceResponse<List<ReplicationLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ReplicationLinksInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ReplicationLinkInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ReplicationLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ReplicationLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks failover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/failover")
        public Observable<Response<ResponseBody>> failover(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks beginFailover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/failover")
        public Observable<Response<ResponseBody>> beginFailover(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks failoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> failoverAllowDataLoss(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks beginFailoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> beginFailoverAllowDataLoss(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="linkId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ReplicationLinks listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

