/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.AsymmetricSignatureAlgorithm;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.Strings;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public abstract class RsaSignature
extends AsymmetricSignatureAlgorithm {
    private static final BigInteger TWO_FIVE_SIX = new BigInteger("256");
    private static final byte[] SHA_256_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};

    protected RsaSignature(String name) {
        super(name);
    }

    protected int getOctetLength(int bits) {
        return bits % 8 > 0 ? bits >> 4 : bits >> 3;
    }

    protected BigInteger OS2IP(byte[] x) {
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("x");
        }
        return new BigInteger(1, x);
    }

    protected byte[] I2OSP(BigInteger x, int xLen) {
        if (x == null) {
            throw new IllegalArgumentException("x");
        }
        if (xLen <= 0) {
            throw new IllegalArgumentException("xLen");
        }
        if (x.compareTo(TWO_FIVE_SIX.pow(xLen)) == 1) {
            throw new IllegalArgumentException("integer too large");
        }
        byte[] bigEndianBytes = x.toByteArray();
        byte[] bytes = bigEndianBytes.length == 257 && bigEndianBytes[0] == 0 ? Arrays.copyOfRange(bigEndianBytes, 1, 257) : bigEndianBytes;
        if (bytes.length > xLen) {
            throw new IllegalArgumentException("integer too large");
        }
        byte[] result = new byte[xLen];
        System.arraycopy(bytes, 0, result, xLen - bytes.length, bytes.length);
        return result;
    }

    protected BigInteger RSASP1(RSAPrivateKey key, BigInteger m) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (m == null) {
            throw new IllegalArgumentException("m");
        }
        BigInteger n = key.getModulus();
        BigInteger d = key.getPrivateExponent();
        if (m.compareTo(BigInteger.ONE) == -1 || m.compareTo(n) != -1) {
            throw new IllegalArgumentException("message representative out of range");
        }
        return m.modPow(d, n);
    }

    protected BigInteger RSAVP1(RSAPublicKey key, BigInteger s) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (s == null) {
            throw new IllegalArgumentException("s");
        }
        BigInteger n = key.getModulus();
        BigInteger e = key.getPublicExponent();
        if (s.compareTo(BigInteger.ONE) == -1 || s.compareTo(n) != -1) {
            throw new IllegalArgumentException("message representative out of range");
        }
        return s.modPow(e, n);
    }

    protected byte[] EMSA_PKCS1_V1_5_ENCODE(byte[] m, int emLen, String algorithm) throws NoSuchAlgorithmException {
        if (m == null || m.length == 0) {
            throw new IllegalArgumentException("m");
        }
        MessageDigest messageDigest = null;
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (!algorithm.equals("SHA-256")) {
            throw new IllegalArgumentException("algorithm");
        }
        messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(m);
        return this.EMSA_PKCS1_V1_5_ENCODE_HASH(digest, emLen, algorithm);
    }

    protected byte[] EMSA_PKCS1_V1_5_ENCODE_HASH(byte[] h, int emLen, String algorithm) throws NoSuchAlgorithmException {
        if (h == null || h.length == 0) {
            throw new IllegalArgumentException("m");
        }
        byte[] algorithmPrefix = null;
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (algorithm.equals("SHA-256")) {
            algorithmPrefix = SHA_256_PREFIX;
            if (h.length != 32) {
                throw new IllegalArgumentException("h is incorrect length for SHA-256");
            }
        } else {
            throw new IllegalArgumentException("algorithm");
        }
        byte[] t = new byte[algorithmPrefix.length + h.length];
        System.arraycopy(algorithmPrefix, 0, t, 0, algorithmPrefix.length);
        System.arraycopy(h, 0, t, algorithmPrefix.length, h.length);
        if (emLen < t.length + 11) {
            throw new IllegalArgumentException("intended encoded message length too short");
        }
        byte[] ps = new byte[emLen - t.length - 3];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = -1;
        }
        byte[] em = new byte[ps.length + t.length + 3];
        em[0] = 0;
        em[1] = 1;
        em[ps.length + 2] = 0;
        System.arraycopy(ps, 0, em, 2, ps.length);
        System.arraycopy(t, 0, em, ps.length + 3, t.length);
        return em;
    }

    public abstract ISignatureTransform createSignatureTransform(KeyPair var1);
}

