/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;

public class OverrideCombiner
extends NodeCombiner {
    @Override
    public ImmutableNode combine(ImmutableNode node1, ImmutableNode node2) {
        ImmutableNode.Builder result = new ImmutableNode.Builder();
        result.name(node1.getNodeName());
        for (ImmutableNode child : node1) {
            ImmutableNode child2 = this.canCombine(node1, node2, child);
            if (child2 != null) {
                result.addChild(this.combine(child, child2));
                continue;
            }
            result.addChild(child);
        }
        for (ImmutableNode child : node2) {
            if (HANDLER.getChildrenCount(node1, child.getNodeName()) >= 1) continue;
            result.addChild(child);
        }
        this.addAttributes(result, node1, node2);
        result.value(node1.getValue() != null ? node1.getValue() : node2.getValue());
        return result.create();
    }

    protected void addAttributes(ImmutableNode.Builder result, ImmutableNode node1, ImmutableNode node2) {
        result.addAttributes(node1.getAttributes());
        for (String attr : node2.getAttributes().keySet()) {
            if (node1.getAttributes().containsKey(attr)) continue;
            result.addAttribute(attr, HANDLER.getAttributeValue(node2, attr));
        }
    }

    protected ImmutableNode canCombine(ImmutableNode node1, ImmutableNode node2, ImmutableNode child) {
        if (HANDLER.getChildrenCount(node2, child.getNodeName()) == 1 && HANDLER.getChildrenCount(node1, child.getNodeName()) == 1 && !this.isListNode(child)) {
            return HANDLER.getChildren(node2, child.getNodeName()).get(0);
        }
        return null;
    }
}

