/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapconfigcheck;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.ranger.ldapconfigcheck.UserSync;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class AuthenticationCheck {
    private String ldapUrl = null;
    private String authMethod = "NONE";
    private String adDomain = null;
    private String userDnPattern = null;
    private String roleAttribute = null;
    private String groupSearchBase = null;
    private String groupSearchFilter = null;
    private PrintStream logFile = null;
    private PrintStream ambariProps = null;
    private PrintStream installProps = null;

    public AuthenticationCheck(String ldapUrl, UserSync userSyncObj, PrintStream logFile, PrintStream ambariProps, PrintStream installProps) {
        this.logFile = logFile;
        this.ambariProps = ambariProps;
        this.installProps = installProps;
        this.authMethod = userSyncObj.getUserNameAttribute().equalsIgnoreCase("sAMAccountName") ? "AD" : "LDAP";
        this.ldapUrl = ldapUrl;
        this.adDomain = userSyncObj.getSearchBase();
        this.userDnPattern = userSyncObj.getUserNameAttribute() + "={0}," + userSyncObj.getUserSearchBase();
        this.roleAttribute = userSyncObj.getGroupNameAttrName();
        this.groupSearchBase = userSyncObj.getGroupSearchBase();
        this.groupSearchFilter = userSyncObj.getGroupMemberName() + "=" + this.userDnPattern;
    }

    public void discoverAuthProperties() {
        this.ambariProps.println("\n# Possible values for authentication properties:");
        this.installProps.println("\n# Possible values for authentication properties:");
        if (this.authMethod.equalsIgnoreCase("AD")) {
            this.installProps.println("xa_ldap_ad_url=" + this.ldapUrl);
            this.installProps.println("xa_ldap_ad_domain=" + this.adDomain);
        } else {
            this.installProps.println("xa_ldap_url=" + this.ldapUrl);
            this.installProps.println("xa_ldap_userDNpattern=" + this.userDnPattern);
            this.installProps.println("xa_ldap_groupRoleAttribute=" + this.roleAttribute);
            this.installProps.println("xa_ldap_groupSearchBase=" + this.groupSearchBase);
            this.installProps.println("xa_ldap_groupSearchFilter=" + this.groupSearchFilter);
        }
        this.ambariProps.println("ranger.authentication.method=" + this.authMethod);
        if (this.authMethod.equalsIgnoreCase("AD")) {
            this.ambariProps.println("ranger.ldap.ad.url=" + this.ldapUrl);
            this.ambariProps.println("ranger.ldap.ad.domain=" + this.adDomain);
        } else {
            this.ambariProps.println("ranger.ldap.url=" + this.ldapUrl);
            this.ambariProps.println("ranger.ldap.user.dnpattern=" + this.userDnPattern);
            this.ambariProps.println("ranger.ldap.group.roleattribute=" + this.roleAttribute);
            this.ambariProps.println("ranger.ldap.group.searchbase=" + this.groupSearchBase);
            this.ambariProps.println("ranger.ldap.group.searchfilter=" + this.groupSearchFilter);
        }
    }

    public boolean isAuthenticated(String ldapUrl, String bindDn, String bindPassword, String userName, String userPassword) {
        boolean isAuthenticated = false;
        Authentication authentication = this.authMethod.equalsIgnoreCase("AD") ? this.getADBindAuthentication(ldapUrl, bindDn, bindPassword, userName, userPassword) : this.getLdapBindAuthentication(ldapUrl, bindDn, bindPassword, userName, userPassword);
        if (authentication != null) {
            isAuthenticated = authentication.isAuthenticated();
        }
        return isAuthenticated;
    }

    private Authentication getADBindAuthentication(String ldapUrl, String bindDn, String bindPassword, String userName, String userPassword) {
        Authentication result = null;
        try {
            DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(ldapUrl);
            ldapContextSource.setUserDn(bindDn);
            ldapContextSource.setPassword(bindPassword);
            ldapContextSource.setReferral("follow");
            ldapContextSource.setCacheEnvironmentProperties(true);
            ldapContextSource.setAnonymousReadOnly(false);
            ldapContextSource.setPooled(true);
            ldapContextSource.afterPropertiesSet();
            String searchFilter = "(sAMAccountName={0})";
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.adDomain, searchFilter, (BaseLdapPathContextSource)ldapContextSource);
            userSearch.setSearchSubtree(true);
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
            bindAuthenticator.setUserSearch((LdapUserSearch)userSearch);
            bindAuthenticator.afterPropertiesSet();
            LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator);
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                grantedAuths.add(new SimpleGrantedAuthority("ROLE_USER"));
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                result = ldapAuthenticationProvider.authenticate((Authentication)finalAuthentication);
            }
        }
        catch (BadCredentialsException bce) {
            this.logFile.println("ERROR: LDAP Authentication Failed. Please verify values for ranger.admin.auth.sampleuser and ranger.admin.auth.samplepassword\n");
        }
        catch (Exception e) {
            this.logFile.println("ERROR: LDAP Authentication Failed: " + e);
        }
        return result;
    }

    private Authentication getLdapBindAuthentication(String ldapUrl, String bindDn, String bindPassword, String userName, String userPassword) {
        Authentication result = null;
        try {
            DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(ldapUrl);
            ldapContextSource.setUserDn(bindDn);
            ldapContextSource.setPassword(bindPassword);
            ldapContextSource.setReferral("follow");
            ldapContextSource.setCacheEnvironmentProperties(false);
            ldapContextSource.setAnonymousReadOnly(true);
            ldapContextSource.setPooled(true);
            ldapContextSource.afterPropertiesSet();
            DefaultLdapAuthoritiesPopulator defaultLdapAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContextSource, this.groupSearchBase);
            defaultLdapAuthoritiesPopulator.setGroupRoleAttribute(this.roleAttribute);
            defaultLdapAuthoritiesPopulator.setGroupSearchFilter(this.groupSearchFilter);
            defaultLdapAuthoritiesPopulator.setIgnorePartialResultException(true);
            String searchFilter = "(uid={0})";
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.adDomain, searchFilter, (BaseLdapPathContextSource)ldapContextSource);
            userSearch.setSearchSubtree(true);
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
            bindAuthenticator.setUserSearch((LdapUserSearch)userSearch);
            String[] userDnPatterns = new String[]{this.userDnPattern};
            bindAuthenticator.setUserDnPatterns(userDnPatterns);
            bindAuthenticator.afterPropertiesSet();
            LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)defaultLdapAuthoritiesPopulator);
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                grantedAuths.add(new SimpleGrantedAuthority("ROLE_USER"));
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                result = ldapAuthenticationProvider.authenticate((Authentication)finalAuthentication);
            }
        }
        catch (BadCredentialsException bce) {
            this.logFile.println("ERROR: LDAP Authentication Failed. Please verify values for ranger.admin.auth.sampleuser and ranger.admin.auth.samplepassword\n");
        }
        catch (Exception e) {
            this.logFile.println("ERROR: LDAP Authentication Failed: " + e);
        }
        return result;
    }
}

