/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.provider.StandAloneAuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerAuditConfig;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerAdminUserStoreRetriever;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerRequestScriptEvaluator;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.apache.ranger.plugin.service.RangerChainedPlugin;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.PerfDataRecorder;
import org.apache.ranger.plugin.util.PolicyRefresher;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerRolesUtil;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerBasePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerBasePlugin.class);
    private final RangerPluginConfig pluginConfig;
    private final RangerPluginContext pluginContext;
    private final Map<String, LogHistory> logHistoryList = new Hashtable<String, LogHistory>();
    private final int logInterval = 30000;
    private final DownloadTrigger accessTrigger = new DownloadTrigger();
    private PolicyRefresher refresher;
    private RangerPolicyEngine policyEngine;
    private RangerAuthContext currentAuthContext;
    private RangerAccessResultProcessor resultProcessor;
    private RangerRoles roles;
    private final List<RangerChainedPlugin> chainedPlugins;
    private final boolean dedupStrings;
    private boolean isUserStoreEnricherAddedImplcitly = false;
    private Map<String, String> serviceConfigs;

    public RangerBasePlugin(String serviceType, String appId) {
        this(new RangerPluginConfig(serviceType, null, appId, null, null, null));
    }

    public RangerBasePlugin(String serviceType, String serviceName, String appId) {
        this(new RangerPluginConfig(serviceType, serviceName, appId, null, null, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RangerBasePlugin(RangerPluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
        this.pluginContext = new RangerPluginContext(pluginConfig);
        boolean usePerfDataRecorder = pluginConfig.getBoolean("ranger.perf.aggregate.data", false);
        int perfDataDumpInterval = pluginConfig.getInt("ranger.perf.aggregate.data.dump.interval", 0);
        boolean usePerfDataLock = pluginConfig.getBoolean("ranger.perf.aggregate.data.lock.enabled", false);
        String nullSafeSupplier = pluginConfig.get(pluginConfig.getPropertyPrefix() + ".null_safe.supplier", "v2");
        LOG.info(pluginConfig.getPropertyPrefix() + ".null_safe.supplier=" + nullSafeSupplier);
        RangerBaseModelObject.setNullSafeSupplier(nullSafeSupplier);
        PerfDataRecorder.initialize(usePerfDataRecorder, perfDataDumpInterval, usePerfDataLock, null);
        Set<String> superUsers = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".super.users"));
        Set<String> superGroups = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".super.groups"));
        Set<String> auditExcludeUsers = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.users"));
        Set<String> auditExcludeGroups = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.groups"));
        Set<String> auditExcludeRoles = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.roles"));
        Set<String> serviceAdmins = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".service.admins"));
        this.setSuperUsersAndGroups(superUsers, superGroups);
        this.setAuditExcludedUsersGroupsRoles(auditExcludeUsers, auditExcludeGroups, auditExcludeRoles);
        this.setIsFallbackSupported(pluginConfig.getBoolean(pluginConfig.getPropertyPrefix() + ".is.fallback.supported", false));
        this.setServiceAdmins(serviceAdmins);
        String ugiPrefix = pluginConfig.getPropertyPrefix() + ".ugi";
        boolean initUgi = pluginConfig.getBoolean(ugiPrefix + ".initialize", false);
        if (initUgi) {
            String ugiLoginType = pluginConfig.get(ugiPrefix + ".login.type");
            if (StringUtils.equalsIgnoreCase((String)ugiLoginType, (String)"keytab")) {
                String principal = pluginConfig.get(ugiPrefix + ".keytab.principal");
                String keytab = pluginConfig.get(ugiPrefix + ".keytab.file");
                if (StringUtils.isNotBlank((String)principal) && StringUtils.isNotBlank((String)keytab)) {
                    LOG.info("UGI login: principal={}, keytab={}", (Object)principal, (Object)keytab);
                    try {
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                    catch (IOException excp) {
                        LOG.error("UGI login: failed", (Throwable)excp);
                        throw new RuntimeException(excp);
                    }
                } else {
                    String msg = String.format("UGI login: invalid configuration: %s=%s, %s=%s", ugiPrefix + ".keytab.principal", principal, ugiPrefix + ".keytab.file", keytab);
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
            }
            if (StringUtils.equalsIgnoreCase((String)ugiLoginType, (String)"jaas")) {
                String jaasAppConfig = pluginConfig.get(ugiPrefix + ".jaas.appconfig");
                if (!StringUtils.isNotBlank((String)jaasAppConfig)) {
                    String msg = String.format("UGI login: invalid configuration: %s=%s", ugiPrefix + ".jaas.appconfig", jaasAppConfig);
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                LOG.info("UGI login: jaasAppConfig={}", (Object)jaasAppConfig);
                try {
                    MiscUtil.setUGIFromJAASConfig((String)jaasAppConfig);
                }
                catch (Exception excp) {
                    LOG.error("UGI login: jaasAppConfig={} failed", (Object)jaasAppConfig, (Object)excp);
                    throw new RuntimeException(excp);
                }
            } else {
                LOG.warn("UGI login: invalid configuration {}={}", (Object)(ugiPrefix + ".login.type"), (Object)ugiLoginType);
            }
        }
        RangerRequestScriptEvaluator.init(pluginConfig);
        this.dedupStrings = pluginConfig.getBoolean(pluginConfig.getPropertyPrefix() + ".dedup.strings", true);
        this.chainedPlugins = this.initChainedPlugins();
    }

    public RangerBasePlugin(RangerPluginConfig pluginConfig, ServicePolicies policies, ServiceTags tags, RangerRoles roles) {
        this(pluginConfig, policies, tags, roles, null);
    }

    public RangerBasePlugin(RangerPluginConfig pluginConfig, ServicePolicies policies, ServiceTags tags, RangerRoles roles, RangerUserStore userStore) {
        this(pluginConfig);
        this.init();
        this.setPolicies(policies);
        this.setRoles(roles);
        if (tags != null) {
            RangerTagEnricher tagEnricher = this.getTagEnricher();
            if (tagEnricher != null) {
                tagEnricher.setServiceTags(tags);
            } else {
                LOG.warn("RangerBasePlugin(tagsVersion=" + tags.getTagVersion() + "): no tag enricher found. Plugin will not enforce tag-based policies");
            }
        }
        if (userStore != null) {
            RangerUserStoreEnricher userStoreEnricher = this.getUserStoreEnricher();
            if (userStoreEnricher != null) {
                userStoreEnricher.setRangerUserStore(userStore);
            } else {
                LOG.warn("RangerBasePlugin(userStoreVersion=" + userStore.getUserStoreVersion() + "): no userstore enricher found. Plugin will not enforce user/group attribute-based policies");
            }
        }
    }

    public static AuditHandler getAuditProvider(String serviceName) {
        AuditProviderFactory providerFactory = RangerBasePlugin.getAuditProviderFactory(serviceName);
        AuditHandler ret = providerFactory.getAuditProvider();
        return ret;
    }

    public String getServiceType() {
        return this.pluginConfig.getServiceType();
    }

    public String getAppId() {
        return this.pluginConfig.getAppId();
    }

    public RangerPluginConfig getConfig() {
        return this.pluginConfig;
    }

    public String getClusterName() {
        return this.pluginConfig.getClusterName();
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    public RangerAuthContext getCurrentRangerAuthContext() {
        return this.currentAuthContext;
    }

    public List<RangerChainedPlugin> getChainedPlugins() {
        return this.chainedPlugins;
    }

    public RangerAuthContext createRangerAuthContext() {
        return this.currentAuthContext;
    }

    public RangerRoles getRoles() {
        return this.roles;
    }

    public void setRoles(RangerRoles roles) {
        this.roles = roles;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.setRoles(roles);
        }
        this.pluginContext.notifyAuthContextChanged();
    }

    public void setAuditExcludedUsersGroupsRoles(Set<String> users, Set<String> groups, Set<String> roles) {
        this.pluginConfig.setAuditExcludedUsersGroupsRoles(users, groups, roles);
    }

    public void setSuperUsersAndGroups(Set<String> users, Set<String> groups) {
        this.pluginConfig.setSuperUsersGroups(users, groups);
    }

    public void setIsFallbackSupported(boolean isFallbackSupported) {
        this.pluginConfig.setIsFallbackSupported(isFallbackSupported);
    }

    public void setServiceAdmins(Set<String> users) {
        this.pluginConfig.setServiceAdmins(users);
    }

    public RangerServiceDef getServiceDef() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        return policyEngine != null ? policyEngine.getServiceDef() : null;
    }

    public int getServiceDefId() {
        RangerServiceDef serviceDef = this.getServiceDef();
        return serviceDef != null && serviceDef.getId() != null ? serviceDef.getId().intValue() : -1;
    }

    public String getServiceName() {
        return this.pluginConfig.getServiceName();
    }

    public AuditProviderFactory getAuditProviderFactory() {
        return RangerBasePlugin.getAuditProviderFactory(this.getServiceName());
    }

    public void init() {
        this.cleanup();
        AuditProviderFactory providerFactory = AuditProviderFactory.getInstance();
        if (!providerFactory.isInitDone()) {
            if (this.pluginConfig.getProperties() != null) {
                providerFactory.init(this.pluginConfig.getProperties(), this.getAppId());
            } else {
                LOG.error("Audit subsystem is not initialized correctly. Please check audit configuration. ");
                LOG.error("No authorization audits will be generated. ");
            }
        }
        if (!this.pluginConfig.getPolicyEngineOptions().disablePolicyRefresher) {
            this.refresher = new PolicyRefresher(this);
            LOG.info("Created PolicyRefresher Thread(" + this.refresher.getName() + ")");
            this.refresher.setDaemon(true);
            this.refresher.startRefresher();
        }
        for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
            chainedPlugin.init();
        }
    }

    public long getPoliciesVersion() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        Long ret = policyEngine != null ? Long.valueOf(policyEngine.getPolicyVersion()) : null;
        return ret != null ? ret : -1L;
    }

    public long getTagsVersion() {
        RangerTagEnricher tagEnricher = this.getTagEnricher();
        Long ret = tagEnricher != null ? tagEnricher.getServiceTagsVersion() : null;
        return ret != null ? ret : -1L;
    }

    public long getRolesVersion() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        Long ret = policyEngine != null ? Long.valueOf(policyEngine.getRoleVersion()) : null;
        return ret != null ? ret : -1L;
    }

    public long getUserStoreVersion() {
        RangerUserStoreEnricher userStoreEnricher = this.getUserStoreEnricher();
        Long ret = userStoreEnricher != null ? userStoreEnricher.getUserStoreVersion() : null;
        return ret != null ? ret : -1L;
    }

    public void setPolicies(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setPolicies(" + policies + ")");
        }
        Map<String, String> map = this.serviceConfigs = policies != null && policies.getServiceConfig() != null ? policies.getServiceConfig() : new HashMap<String, String>();
        if (this.pluginConfig.isEnableImplicitUserStoreEnricher() && policies != null && !ServiceDefUtil.isUserStoreEnricherPresent(policies)) {
            String retrieverClassName = this.pluginConfig.get("userStoreRetrieverClassName", RangerAdminUserStoreRetriever.class.getCanonicalName());
            String retrieverPollIntMs = this.pluginConfig.get("userStoreRefresherPollingInterval", Integer.toString(60000));
            if (RangerPolicyDeltaUtil.hasPolicyDeltas(policies) == Boolean.TRUE && this.isUserStoreEnricherAddedImplcitly) {
                ServiceDefUtil.addUserStoreEnricher(policies, retrieverClassName, retrieverPollIntMs);
            } else {
                this.isUserStoreEnricherAddedImplcitly = this.pluginConfig.isUseRangerGroups() || this.pluginConfig.isConvertEmailToUsername() ? ServiceDefUtil.addUserStoreEnricher(policies, retrieverClassName, retrieverPollIntMs) : ServiceDefUtil.addUserStoreEnricherIfNeeded(policies, retrieverClassName, retrieverPollIntMs);
            }
        }
        try {
            RangerPolicyEngine oldPolicyEngine = this.policyEngine;
            ServicePolicies servicePolicies = null;
            boolean isNewEngineNeeded = true;
            boolean usePolicyDeltas = false;
            if (policies == null) {
                policies = this.getDefaultSvcPolicies();
                if (policies == null) {
                    LOG.error("Could not get default Service Policies. Keeping old policy-engine!");
                    isNewEngineNeeded = false;
                }
            } else {
                Boolean hasPolicyDeltas;
                if (this.dedupStrings) {
                    policies.dedupStrings();
                }
                if ((hasPolicyDeltas = RangerPolicyDeltaUtil.hasPolicyDeltas(policies)) == null) {
                    LOG.info("Downloaded policies do not require policy change !! [" + policies + "]");
                    if (this.policyEngine == null) {
                        LOG.info("There are no material changes, and current policy-engine is null! Creating a policy-engine with default service policies");
                        ServicePolicies defaultSvcPolicies = this.getDefaultSvcPolicies();
                        if (defaultSvcPolicies == null) {
                            LOG.error("Could not get default Service Policies. Keeping old policy-engine! This is a FATAL error as the old policy-engine is null!");
                            isNewEngineNeeded = false;
                        } else {
                            defaultSvcPolicies.setPolicyVersion(policies.getPolicyVersion());
                            policies = defaultSvcPolicies;
                            isNewEngineNeeded = true;
                        }
                    } else {
                        LOG.info("Keeping old policy-engine!");
                        isNewEngineNeeded = false;
                    }
                } else if (hasPolicyDeltas.equals(Boolean.TRUE)) {
                    RangerPolicyEngineImpl policyEngine = (RangerPolicyEngineImpl)oldPolicyEngine;
                    servicePolicies = ServicePolicies.applyDelta(policies, policyEngine);
                    if (servicePolicies != null) {
                        usePolicyDeltas = true;
                    } else {
                        LOG.error("Could not apply deltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()));
                        LOG.warn("Keeping old policy-engine!");
                        isNewEngineNeeded = false;
                    }
                } else {
                    if (policies.getPolicies() == null) {
                        policies.setPolicies(new ArrayList<RangerPolicy>());
                    }
                    if (MapUtils.isNotEmpty(policies.getSecurityZones())) {
                        for (ServicePolicies.SecurityZoneInfo element : policies.getSecurityZones().values()) {
                            if (element.getPolicies() != null) continue;
                            element.setPolicies(new ArrayList<RangerPolicy>());
                        }
                    }
                }
            }
            if (isNewEngineNeeded) {
                RangerPolicyEngine newPolicyEngine = null;
                boolean isPolicyEngineShared = false;
                if (!usePolicyDeltas) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating engine from policies");
                    }
                    newPolicyEngine = new RangerPolicyEngineImpl(policies, this.pluginContext, this.roles);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("policy-deltas are not null");
                    }
                    if (CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) || MapUtils.isNotEmpty(policies.getSecurityZones())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Non empty policy-deltas found. Cloning engine using policy-deltas");
                        }
                        if (oldPolicyEngine != null) {
                            RangerPolicyEngineImpl oldPolicyEngineImpl = (RangerPolicyEngineImpl)oldPolicyEngine;
                            newPolicyEngine = RangerPolicyEngineImpl.getPolicyEngine(oldPolicyEngineImpl, policies);
                        }
                        if (newPolicyEngine != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Applied policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + ")");
                            }
                            isPolicyEngineShared = true;
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Failed to apply policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + "), Creating engine from policies");
                                LOG.debug("Creating new engine from servicePolicies:[" + servicePolicies + "]");
                            }
                            newPolicyEngine = new RangerPolicyEngineImpl(servicePolicies, this.pluginContext, this.roles);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Empty policy-deltas. No need to change policy engine");
                    }
                }
                if (newPolicyEngine != null) {
                    if (!isPolicyEngineShared) {
                        newPolicyEngine.setUseForwardedIPAddress(this.pluginConfig.isUseForwardedIPAddress());
                        newPolicyEngine.setTrustedProxyAddresses(this.pluginConfig.getTrustedProxyAddresses());
                    }
                    LOG.info("Switching policy engine from [" + this.getPolicyVersion() + "]");
                    this.policyEngine = newPolicyEngine;
                    LOG.info("Switched policy engine to [" + this.getPolicyVersion() + "]");
                    this.currentAuthContext = this.pluginContext.getAuthContext();
                    this.pluginContext.notifyAuthContextChanged();
                    if (oldPolicyEngine != null && oldPolicyEngine != newPolicyEngine) {
                        ((RangerPolicyEngineImpl)oldPolicyEngine).releaseResources(!isPolicyEngineShared);
                    }
                    if (this.refresher != null) {
                        boolean doPreserveDeltas = this.pluginConfig.getBoolean(this.pluginConfig.getPropertyPrefix() + ".preserve.deltas", false);
                        if (!doPreserveDeltas) {
                            this.refresher.saveToCache(usePolicyDeltas ? servicePolicies : policies);
                        } else {
                            this.refresher.saveToCache(policies);
                            if (usePolicyDeltas) {
                                this.refresher.saveToCache(servicePolicies);
                            }
                        }
                    }
                }
            } else {
                LOG.warn("Leaving current policy engine as-is");
                LOG.warn("Policies are not saved to cache. policyVersion in the policy-cache may be different than in Ranger-admin, even though the policies are the same!");
                LOG.warn("Ranger-PolicyVersion:[" + (policies != null ? policies.getPolicyVersion() : -1L) + "], Cached-PolicyVersion:[" + this.getPoliciesVersion() + "]");
            }
        }
        catch (Exception e) {
            LOG.error("setPolicies: policy engine initialization failed!  Leaving current policy engine as-is. Exception : ", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== setPolicies(" + policies + ")");
        }
    }

    public void cleanup() {
        PolicyRefresher refresher = this.refresher;
        this.refresher = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        this.policyEngine = null;
        if (refresher != null) {
            refresher.stopRefresher();
        }
        if (policyEngine != null) {
            ((RangerPolicyEngineImpl)policyEngine).releaseResources(true);
        }
    }

    public void setResultProcessor(RangerAccessResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public RangerAccessResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request) {
        return this.isAccessAllowed(request, this.resultProcessor);
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests) {
        return this.isAccessAllowed(requests, this.resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerAccessResult ret = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 0, null);
        }
        if (ret != null) {
            for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                RangerAccessResult chainedResult;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BasePlugin.isAccessAllowed result=[" + ret + "]");
                    LOG.debug("Calling chainedPlugin.isAccessAllowed for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "]");
                }
                if ((chainedResult = ret.getIsAccessDetermined() && chainedPlugin.skipAccessCheckIfAlreadyDetermined ? null : chainedPlugin.isAccessAllowed(request)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("chainedPlugin.isAccessAllowed for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "] returned result=[" + chainedResult + "]");
                }
                this.updateResultFromChainedResult(ret, chainedResult);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("After updating result from chainedPlugin.isAccessAllowed for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "], result=" + ret + "]");
            }
        }
        if (policyEngine != null) {
            policyEngine.evaluateAuditPolicies(ret);
        }
        if (resultProcessor != null) {
            resultProcessor.processResult(ret);
        }
        return ret;
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        Collection<RangerAccessResult> ret = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(requests, 0, null);
        }
        if (CollectionUtils.isNotEmpty(ret)) {
            for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                Collection<RangerAccessResult> chainedResults = chainedPlugin.isAccessAllowed(requests);
                if (!CollectionUtils.isNotEmpty(chainedResults)) continue;
                Iterator<RangerAccessResult> iterRet = ret.iterator();
                Iterator<RangerAccessResult> iterChainedResults = chainedResults.iterator();
                while (iterRet.hasNext() && iterChainedResults.hasNext()) {
                    RangerAccessResult result = iterRet.next();
                    RangerAccessResult chainedResult = iterChainedResults.next();
                    if (result == null || chainedResult == null) continue;
                    this.updateResultFromChainedResult(result, chainedResult);
                }
            }
        }
        if (policyEngine != null && CollectionUtils.isNotEmpty(ret)) {
            for (RangerAccessResult result : ret) {
                policyEngine.evaluateAuditPolicies(result);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        return ret;
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        RangerAccessResult ret = null;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 1, resultProcessor);
            if (ret != null) {
                for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                    RangerAccessResult chainedResult;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BasePlugin.evalDataMaskPolicies result=[" + ret + "]");
                        LOG.debug("Calling chainedPlugin.evalDataMaskPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "]");
                    }
                    if ((chainedResult = chainedPlugin.evalDataMaskPolicies(request)) == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("chainedPlugin.evalDataMaskPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "] returned result=[" + chainedResult + "]");
                    }
                    this.updateResultFromChainedResult(ret, chainedResult);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("After updating result from chainedPlugin.evalDataMaskPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "], result=" + ret + "]");
                }
            }
            policyEngine.evaluateAuditPolicies(ret);
        }
        return ret;
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        RangerAccessResult ret = null;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 2, resultProcessor);
            if (ret != null) {
                for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                    RangerAccessResult chainedResult;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BasePlugin.evalRowFilterPolicies result=[" + ret + "]");
                        LOG.debug("Calling chainedPlugin.evalRowFilterPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "]");
                    }
                    if ((chainedResult = chainedPlugin.evalRowFilterPolicies(request)) == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("chainedPlugin.evalRowFilterPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "] returned result=[" + chainedResult + "]");
                    }
                    this.updateResultFromChainedResult(ret, chainedResult);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("After updating result from chainedPlugin.evalRowFilterPolicies for service:[" + chainedPlugin.plugin.pluginConfig.getServiceName() + "], result=" + ret + "]");
                }
            }
            policyEngine.evaluateAuditPolicies(ret);
        }
        return ret;
    }

    public void evalAuditPolicies(RangerAccessResult result) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.evaluateAuditPolicies(result);
        }
    }

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getResourceAccessInfo(request);
        }
        return null;
    }

    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        return this.getResourceACLs(request, null);
    }

    public RangerResourceACLs getResourceACLs(RangerAccessRequest request, Integer policyType) {
        RangerResourceACLs ret = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            ret = policyEngine.getResourceACLs(request, policyType);
        }
        for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
            RangerResourceACLs chainedResourceACLs = chainedPlugin.getResourceACLs(request, policyType);
            if (chainedResourceACLs != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chained-plugin returned non-null ACLs!!");
                }
                if (chainedPlugin.isAuthorizeOnlyWithChainedPlugin()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Chained-plugin is configured to ignore Base-plugin's ACLs");
                    }
                    ret = chainedResourceACLs;
                    break;
                }
                if (ret == null) continue;
                ret = RangerBasePlugin.getMergedResourceACLs(ret, chainedResourceACLs);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Chained-plugin returned null ACLs!!");
        }
        return ret;
    }

    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getRolesFromUserAndGroups(user, groups);
        }
        return null;
    }

    public RangerRoles getRangerRoles() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getRangerRoles();
        }
        return null;
    }

    public Set<RangerRole> getRangerRoleForPrincipal(String principal, String type) {
        HashSet<RangerRole> ret = new HashSet<RangerRole>();
        RangerPolicyEngine policyEngine = this.policyEngine;
        RangerRoles roles = policyEngine != null ? policyEngine.getRangerRoles() : null;
        Set<RangerRole> rangerRoles = roles != null ? roles.getRangerRoles() : null;
        Map<String, Set<String>> roleMapping = null;
        if (rangerRoles != null) {
            Set principalRoles;
            RangerRolesUtil rangerRolesUtil;
            RangerAuthContext rangerAuthContext;
            RangerPluginContext rangerPluginContext = policyEngine.getPluginContext();
            if (rangerPluginContext != null && (rangerAuthContext = rangerPluginContext.getAuthContext()) != null && (rangerRolesUtil = rangerAuthContext.getRangerRolesUtil()) != null) {
                switch (type) {
                    case "USER": {
                        roleMapping = rangerRolesUtil.getUserRoleMapping();
                        break;
                    }
                    case "GROUP": {
                        roleMapping = rangerRolesUtil.getGroupRoleMapping();
                        break;
                    }
                    case "ROLE": {
                        roleMapping = rangerRolesUtil.getRoleRoleMapping();
                    }
                }
            }
            if (roleMapping != null && CollectionUtils.isNotEmpty((Collection)(principalRoles = (Set)roleMapping.get(principal)))) {
                for (String role : principalRoles) {
                    for (RangerRole rangerRole : rangerRoles) {
                        if (!rangerRole.getName().equals(role)) continue;
                        ret.add(rangerRole);
                    }
                }
            }
        }
        return ret;
    }

    public boolean isServiceAdmin(String userName) {
        boolean ret = false;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            RangerPolicyEngineImpl rangerPolicyEngine = (RangerPolicyEngineImpl)policyEngine;
            ret = rangerPolicyEngine.isServiceAdmin(userName);
        }
        return ret;
    }

    public RangerRole createRole(RangerRole request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.createRole(" + request + ")");
        }
        RangerRole ret = this.getAdminClient().createRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.createRole(" + request + ")");
        }
        return ret;
    }

    public void dropRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.dropRole(" + roleName + ")");
        }
        this.getAdminClient().dropRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.dropRole(" + roleName + ")");
        }
    }

    public List<String> getUserRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.getUserRoleNames(" + execUser + ")");
        }
        List<String> ret = this.getAdminClient().getUserRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.getUserRoleNames(" + execUser + ")");
        }
        return ret;
    }

    public List<String> getAllRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.getAllRoles()");
        }
        List<String> ret = this.getAdminClient().getAllRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.getAllRoles()");
        }
        return ret;
    }

    public RangerRole getRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.getPrincipalsForRole(" + roleName + ")");
        }
        RangerRole ret = this.getAdminClient().getRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.getPrincipalsForRole(" + roleName + ")");
        }
        return ret;
    }

    public void grantRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.grantRole(" + request + ")");
        }
        this.getAdminClient().grantRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.grantRole(" + request + ")");
        }
    }

    public void revokeRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.revokeRole(" + request + ")");
        }
        this.getAdminClient().revokeRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.revokeRole(" + request + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.grantAccess(" + request + ")");
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getUniquelyMatchedZoneName(request));
            }
            this.getAdminClient().grantAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "grant", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.grantAccess(" + request + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.revokeAccess(" + request + ")");
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getUniquelyMatchedZoneName(request));
            }
            this.getAdminClient().revokeAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "revoke", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.revokeAccess(" + request + ")");
        }
    }

    public void registerAuthContextEventListener(RangerAuthContextListener authContextListener) {
        this.pluginContext.setAuthContextListener(authContextListener);
    }

    public static RangerAdminClient createAdminClient(RangerPluginConfig pluginConfig) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + ")");
        }
        RangerAdminClient ret = null;
        String propertyName = pluginConfig.getPropertyPrefix() + ".policy.source.impl";
        String policySourceImpl = pluginConfig.get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Value for property[%s] was null or empty. Unexpected! Will use policy source of type[%s]", propertyName, RangerAdminRESTClient.class.getName()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Value for property[%s] was [%s].", propertyName, policySourceImpl));
            }
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error("failed to instantiate policy source of type '" + policySourceImpl + "'. Will use policy source of type '" + RangerAdminRESTClient.class.getName() + "'", (Throwable)excp);
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), pluginConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + "): policySourceImpl=" + policySourceImpl + ", client=" + ret);
        }
        return ret;
    }

    public void refreshPoliciesAndTags() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> refreshPoliciesAndTags()");
        }
        try {
            RangerTagEnricher tagEnricher;
            long newPolicyVersion;
            long oldPolicyVersion = this.getPoliciesVersion();
            if (this.refresher != null) {
                this.refresher.syncPoliciesWithAdmin(this.accessTrigger);
            }
            if (oldPolicyVersion == (newPolicyVersion = this.getPoliciesVersion()) && (tagEnricher = this.getTagEnricher()) != null) {
                tagEnricher.syncTagsWithAdmin(this.accessTrigger);
            }
        }
        catch (InterruptedException exception) {
            LOG.error("Failed to update policy-engine, continuing to use old policy-engine and/or tags", (Throwable)exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== refreshPoliciesAndTags()");
        }
    }

    private void auditGrantRevoke(GrantRevokeRequest request, String action, boolean isSuccess, RangerAccessResultProcessor resultProcessor) {
        if (request != null && resultProcessor != null) {
            RangerAccessRequestImpl accessRequest = new RangerAccessRequestImpl();
            accessRequest.setResource(new RangerAccessResourceImpl(StringUtil.toStringObjectMap(request.getResource())));
            accessRequest.setUser(request.getGrantor());
            accessRequest.setAccessType("_any");
            accessRequest.setAction(action);
            accessRequest.setClientIPAddress(request.getClientIPAddress());
            accessRequest.setClientType(request.getClientType());
            accessRequest.setRequestData(request.getRequestData());
            accessRequest.setSessionId(request.getSessionId());
            RangerAccessResult accessResult = this.isAccessAllowed(accessRequest, null);
            if (accessResult != null && accessResult.getIsAudited()) {
                accessRequest.setAccessType(action);
                accessResult.setIsAllowed(isSuccess);
                if (!isSuccess) {
                    accessResult.setPolicyId(-1L);
                }
                resultProcessor.processResult(accessResult);
            }
        }
    }

    private RangerServiceDef getDefaultServiceDef() {
        RangerServiceDef ret = null;
        if (StringUtils.isNotBlank((String)this.getServiceType())) {
            try {
                ret = EmbeddedServiceDefsUtil.instance().getEmbeddedServiceDef(this.getServiceType());
            }
            catch (Exception exp) {
                LOG.error("Could not get embedded service-def for " + this.getServiceType());
            }
        }
        return ret;
    }

    private ServicePolicies getDefaultSvcPolicies() {
        ServicePolicies ret = null;
        RangerServiceDef serviceDef = this.getServiceDef();
        if (serviceDef == null) {
            serviceDef = this.getDefaultServiceDef();
        }
        if (serviceDef != null) {
            ret = new ServicePolicies();
            ret.setServiceDef(serviceDef);
            ret.setServiceName(this.getServiceName());
            ret.setPolicies(new ArrayList<RangerPolicy>());
        }
        return ret;
    }

    public boolean logErrorMessage(String message) {
        LogHistory log = this.logHistoryList.get(message);
        if (log == null) {
            log = new LogHistory();
            this.logHistoryList.put(message, log);
        }
        if (System.currentTimeMillis() - log.lastLogTime > 30000L) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            LOG.error(message);
            return true;
        }
        ++log.counter;
        return false;
    }

    private Set<String> toSet(String value) {
        return StringUtils.isNotBlank((String)value) ? StringUtil.toSet(value) : Collections.emptySet();
    }

    public RangerTagEnricher getTagEnricher() {
        Map<RangerContextEnricher, Object> contextEnricherMap;
        RangerTagEnricher ret = null;
        RangerAuthContext authContext = this.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty(contextEnricherMap = authContext.getRequestContextEnrichers())) {
            Set<RangerContextEnricher> contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerTagEnricher)) continue;
                ret = (RangerTagEnricher)enricher;
                break;
            }
        }
        return ret;
    }

    public RangerUserStoreEnricher getUserStoreEnricher() {
        Map<RangerContextEnricher, Object> contextEnricherMap;
        RangerUserStoreEnricher ret = null;
        RangerAuthContext authContext = this.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty(contextEnricherMap = authContext.getRequestContextEnrichers())) {
            Set<RangerContextEnricher> contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerUserStoreEnricher)) continue;
                ret = (RangerUserStoreEnricher)enricher;
                ret.getRangerUserStore();
                break;
            }
        }
        return ret;
    }

    public static RangerResourceACLs getMergedResourceACLs(RangerResourceACLs baseACLs, RangerResourceACLs chainedACLs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.getMergedResourceACLs()");
            LOG.debug("baseACLs:[" + baseACLs + "]");
            LOG.debug("chainedACLS:[" + chainedACLs + "]");
        }
        RangerBasePlugin.overrideACLs(chainedACLs, baseACLs, RangerRolesUtil.ROLES_FOR.USER);
        RangerBasePlugin.overrideACLs(chainedACLs, baseACLs, RangerRolesUtil.ROLES_FOR.GROUP);
        RangerBasePlugin.overrideACLs(chainedACLs, baseACLs, RangerRolesUtil.ROLES_FOR.ROLE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.getMergedResourceACLs() : ret:[" + baseACLs + "]");
        }
        return baseACLs;
    }

    public Map<String, String> getServiceConfigs() {
        return this.serviceConfigs;
    }

    protected RangerPolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    private RangerAdminClient getAdminClient() throws Exception {
        RangerAdminClient admin;
        PolicyRefresher refresher = this.refresher;
        RangerAdminClient rangerAdminClient = admin = refresher == null ? null : refresher.getRangerAdminClient();
        if (admin == null) {
            throw new Exception("ranger-admin client is null");
        }
        return admin;
    }

    private List<RangerChainedPlugin> initChainedPlugins() {
        ArrayList<RangerChainedPlugin> ret = new ArrayList<RangerChainedPlugin>();
        String chainedServicePropPrefix = this.pluginConfig.getPropertyPrefix() + ".chained.services";
        for (String chainedService : StringUtil.toList(this.pluginConfig.get(chainedServicePropPrefix))) {
            if (StringUtils.isBlank((String)chainedService)) continue;
            String className = this.pluginConfig.get(chainedServicePropPrefix + "." + chainedService + ".impl");
            if (StringUtils.isBlank((String)className)) {
                LOG.error("Ignoring chained service " + chainedService + ": no impl class specified");
                continue;
            }
            try {
                Class<?> pluginClass = Class.forName(className);
                RangerChainedPlugin chainedPlugin = (RangerChainedPlugin)pluginClass.getConstructor(RangerBasePlugin.class, String.class).newInstance(this, chainedService);
                ret.add(chainedPlugin);
            }
            catch (Throwable t) {
                LOG.error("initChainedPlugins(): error instantiating plugin impl " + className, t);
            }
        }
        return ret;
    }

    private void updateResultFromChainedResult(RangerAccessResult result, RangerAccessResult chainedResult) {
        boolean overrideResult = false;
        int policyType = result.getPolicyType();
        if (chainedResult.getIsAccessDetermined()) {
            boolean bl = overrideResult = chainedResult.getPolicyPriority() > result.getPolicyPriority() || !result.getIsAccessDetermined() || !result.getIsAllowed() && result.getPolicyId() == -1L;
            if (!overrideResult && chainedResult.getPolicyPriority() == result.getPolicyPriority() && !chainedResult.getIsAllowed() && chainedResult.getPolicyId() != -1L && result.getIsAllowed()) {
                overrideResult = true;
            }
        }
        if (overrideResult) {
            result.setIsAllowed(chainedResult.getIsAllowed());
            result.setIsAccessDetermined(chainedResult.getIsAccessDetermined());
            result.setPolicyId(chainedResult.getPolicyId());
            result.setPolicyVersion(chainedResult.getPolicyVersion());
            result.setPolicyPriority(chainedResult.getPolicyPriority());
            result.setZoneName(chainedResult.getZoneName());
            if (policyType == 1) {
                result.setMaskType(chainedResult.getMaskType());
                result.setMaskCondition(chainedResult.getMaskCondition());
                result.setMaskedValue(chainedResult.getMaskedValue());
            } else if (policyType == 2) {
                result.setFilterExpr(chainedResult.getFilterExpr());
            }
        }
        if (!result.getIsAuditedDetermined() && chainedResult.getIsAuditedDetermined()) {
            result.setIsAudited(chainedResult.getIsAudited());
            result.setAuditPolicyId(chainedResult.getAuditPolicyId());
        }
    }

    private static void overrideACLs(RangerResourceACLs chainedResourceACLs, RangerResourceACLs baseResourceACLs, RangerRolesUtil.ROLES_FOR userType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.overrideACLs(isUser=" + userType.name() + ")");
        }
        Map<String, Map<String, RangerResourceACLs.AccessResult>> chainedACLs = null;
        Map<String, Map<String, RangerResourceACLs.AccessResult>> baseACLs = null;
        switch (userType) {
            case USER: {
                chainedACLs = chainedResourceACLs.getUserACLs();
                baseACLs = baseResourceACLs.getUserACLs();
                break;
            }
            case GROUP: {
                chainedACLs = chainedResourceACLs.getGroupACLs();
                baseACLs = baseResourceACLs.getGroupACLs();
                break;
            }
            case ROLE: {
                chainedACLs = chainedResourceACLs.getRoleACLs();
                baseACLs = baseResourceACLs.getRoleACLs();
                break;
            }
        }
        for (Map.Entry chainedPermissionsMap : chainedACLs.entrySet()) {
            String name = (String)chainedPermissionsMap.getKey();
            Map chainedPermissions = (Map)chainedPermissionsMap.getValue();
            Map<String, RangerResourceACLs.AccessResult> basePermissions = baseACLs.get(name);
            for (Map.Entry chainedPermission : chainedPermissions.entrySet()) {
                RangerResourceACLs.AccessResult baseAccessResult;
                String chainedAccessType = (String)chainedPermission.getKey();
                RangerResourceACLs.AccessResult chainedAccessResult = (RangerResourceACLs.AccessResult)chainedPermission.getValue();
                RangerResourceACLs.AccessResult accessResult = baseAccessResult = basePermissions == null ? null : basePermissions.get(chainedAccessType);
                boolean useChainedAccessResult = baseAccessResult == null ? true : (chainedAccessResult.getPolicy().getPolicyPriority() > baseAccessResult.getPolicy().getPolicyPriority() ? true : (chainedAccessResult.getPolicy().getPolicyPriority().equals(baseAccessResult.getPolicy().getPolicyPriority()) ? (chainedAccessResult.getResult() == baseAccessResult.getResult() ? true : chainedAccessResult.getResult() == RangerPolicyEvaluator.ACCESS_DENIED.intValue()) : false));
                RangerResourceACLs.AccessResult finalAccessResult = useChainedAccessResult ? chainedAccessResult : baseAccessResult;
                switch (userType) {
                    case USER: {
                        baseResourceACLs.setUserAccessInfo(name, chainedAccessType, finalAccessResult.getResult(), finalAccessResult.getPolicy());
                        break;
                    }
                    case GROUP: {
                        baseResourceACLs.setGroupAccessInfo(name, chainedAccessType, finalAccessResult.getResult(), finalAccessResult.getPolicy());
                        break;
                    }
                    case ROLE: {
                        baseResourceACLs.setRoleAccessInfo(name, chainedAccessType, finalAccessResult.getResult(), finalAccessResult.getPolicy());
                        break;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.mergeACLsOneWay(isUser=" + userType.name() + ")");
        }
    }

    private static AuditProviderFactory getAuditProviderFactory(String serviceName) {
        AuditProviderFactory ret = AuditProviderFactory.getInstance();
        if (!ret.isInitDone()) {
            RangerAuditConfig conf;
            LOG.warn("RangerBasePlugin.getAuditProviderFactory(serviceName=" + serviceName + "): audit not initialized yet. Will use stand-alone audit factory");
            ret = StandAloneAuditProviderFactory.getInstance();
            if (!ret.isInitDone() && (conf = new RangerAuditConfig()).isInitSuccess()) {
                ret.init(conf.getProperties(), "StandAlone");
            }
        }
        return ret;
    }

    public Long getPolicyVersion() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        return policyEngine == null ? -1L : policyEngine.getPolicyVersion();
    }

    private static final class LogHistory {
        long lastLogTime;
        int counter;

        private LogHistory() {
        }
    }
}

