/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import org.apache.commons.lang.StringUtils;

public class RangerServiceNotFoundException
extends Exception {
    private static final String formatString = "\"RANGER_ERROR_SERVICE_NOT_FOUND: ServiceName=%s\"";

    public RangerServiceNotFoundException(String serviceName) {
        super(serviceName);
    }

    public static final String buildExceptionMsg(String serviceName) {
        return String.format(formatString, serviceName);
    }

    public static final void throwExceptionIfServiceNotFound(String serviceName, String exceptionMsg) throws RangerServiceNotFoundException {
        String expectedExceptionMsg = RangerServiceNotFoundException.buildExceptionMsg(serviceName);
        if (StringUtils.startsWith((String)exceptionMsg, (String)expectedExceptionMsg)) {
            throw new RangerServiceNotFoundException(serviceName);
        }
    }
}

