/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kms.authorizer;

import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKmsAuthorizer
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKmsAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kms";
    private static final String RANGER_KMS_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kms.authorizer.RangerKmsAuthorizer";
    private Object impl = null;
    private Runnable implRunnable = null;
    private KeyAuthorizationKeyProvider.KeyACLs implKeyACLs = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerKmsAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.RangerKmsAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.RangerKmsAuthorizer()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_KMS_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.impl = cls.newInstance();
            this.implRunnable = (Runnable)this.impl;
            this.implKeyACLs = (KeyAuthorizationKeyProvider.KeyACLs)this.impl;
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerKMSPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.init()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.hasAccessToKey(" + keyName + ", " + ugi + ", " + opType + ")");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.implKeyACLs.hasAccessToKey(keyName, ugi, opType);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.hasAccessToKey(" + keyName + ", " + ugi + ", " + opType + ")");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isACLPresent(String aclName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.isACLPresent(" + aclName + ", " + opType + ")");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.implKeyACLs.isACLPresent(aclName, opType);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.isACLPresent(" + aclName + ", " + opType + ")");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, String clientIp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.hasAccess(" + aclType + ", " + ugi + ")");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.implKeyACLs.hasAccess(aclType, ugi, clientIp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.hasAccess(" + aclType + ", " + ugi + ")");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key, String clientIp) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.assertAccess(" + key + ", " + ugi + ", " + aclType + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.implKeyACLs.assertAccess(aclType, ugi, operation, key, clientIp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.assertAccess(" + key + ", " + ugi + ", " + aclType + ")");
        }
    }

    public void startReloader() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.startReloader()");
        }
        try {
            this.activatePluginClassLoader();
            this.implKeyACLs.startReloader();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.startReloader()");
        }
    }

    public void stopReloader() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.stopReloader()");
        }
        try {
            this.activatePluginClassLoader();
            this.implKeyACLs.stopReloader();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.stopReloader()");
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.run()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRunnable.run();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.run()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

