/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;

public class SslOptions
implements Cloneable {
    public static final String DEFAULT_STORE_TYPE = "jks";
    public static final String DEFAULT_CONTEXT_PROTOCOL = "TLS";
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final List<String> DEFAULT_DISABLED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
    public static final int DEFAULT_SSL_PORT = 5671;
    public static final boolean DEFAULT_ALLOW_NATIVE_SSL = false;
    private static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private String keyStoreLocation;
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String keyStoreType;
    private String trustStoreType;
    private String[] enabledCipherSuites;
    private String[] disabledCipherSuites;
    private String[] enabledProtocols;
    private String[] disabledProtocols = DEFAULT_DISABLED_PROTOCOLS.toArray(new String[0]);
    private String contextProtocol = "TLS";
    private boolean trustAll = false;
    private boolean verifyHost = true;
    private String keyAlias;
    private int defaultSslPort = 5671;
    private SSLContext sslContextOverride;
    private boolean sslEnabled;
    private boolean allowNativeSSL = false;

    public SslOptions() {
        this.keyStoreLocation(System.getProperty(JAVAX_NET_SSL_KEY_STORE));
        this.keyStoreType(System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.keyStorePassword(System.getProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD));
        this.trustStoreLocation(System.getProperty(JAVAX_NET_SSL_TRUST_STORE));
        this.trustStoreType(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.trustStorePassword(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD));
    }

    public SslOptions clone() {
        return this.copyInto(new SslOptions());
    }

    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    public SslOptions sslEnabled(boolean enable) {
        this.sslEnabled = enable;
        return this;
    }

    public String keyStoreLocation() {
        return this.keyStoreLocation;
    }

    public SslOptions keyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
        return this;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public SslOptions keyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String trustStoreLocation() {
        return this.trustStoreLocation;
    }

    public SslOptions trustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
        return this;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public SslOptions trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslOptions storeType(String storeType) {
        this.keyStoreType(storeType);
        this.trustStoreType(storeType);
        return this;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public SslOptions keyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public String trustStoreType() {
        return this.trustStoreType;
    }

    public SslOptions trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public String[] enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public SslOptions enabledCipherSuites(String ... enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
        return this;
    }

    public String[] disabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public SslOptions disabledCipherSuites(String ... disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
        return this;
    }

    public String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    public SslOptions enabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public String[] disabledProtocols() {
        return this.disabledProtocols;
    }

    public SslOptions disabledProtocols(String ... disabledProtocols) {
        this.disabledProtocols = disabledProtocols;
        return this;
    }

    public String contextProtocol() {
        return this.contextProtocol;
    }

    public SslOptions contextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
        return this;
    }

    public boolean trustAll() {
        return this.trustAll;
    }

    public SslOptions trustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public boolean verifyHost() {
        return this.verifyHost;
    }

    public SslOptions verifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public SslOptions keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public int defaultSslPort() {
        return this.defaultSslPort;
    }

    public SslOptions defaultSslPort(int defaultSslPort) {
        this.defaultSslPort = defaultSslPort;
        return this;
    }

    public SSLContext sslContextOverride() {
        return this.sslContextOverride;
    }

    public SslOptions sslContextOverride(SSLContext sslContextOverride) {
        this.sslContextOverride = sslContextOverride;
        return this;
    }

    public boolean allowNativeSSL() {
        return this.allowNativeSSL;
    }

    public SslOptions allowNativeSSL(boolean allowNativeSSL) {
        this.allowNativeSSL = allowNativeSSL;
        return this;
    }

    protected SslOptions copyInto(SslOptions other) {
        other.sslEnabled(this.sslEnabled());
        other.keyStoreLocation(this.keyStoreLocation());
        other.keyStorePassword(this.keyStorePassword());
        other.trustStoreLocation(this.trustStoreLocation());
        other.trustStorePassword(this.trustStorePassword());
        other.keyStoreType(this.keyStoreType());
        other.trustStoreType(this.trustStoreType());
        other.enabledCipherSuites(this.enabledCipherSuites());
        other.disabledCipherSuites(this.disabledCipherSuites());
        other.enabledProtocols(this.enabledProtocols());
        other.disabledProtocols(this.disabledProtocols());
        other.trustAll(this.trustAll());
        other.verifyHost(this.verifyHost());
        other.keyAlias(this.keyAlias());
        other.contextProtocol(this.contextProtocol());
        other.defaultSslPort(this.defaultSslPort());
        other.sslContextOverride(this.sslContextOverride());
        other.allowNativeSSL(this.allowNativeSSL());
        return other;
    }
}

