/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectMethodAttribute;
import org.apache.qpid.server.model.DerivedAttribute;

public class ConfiguredDerivedMethodAttribute<C extends ConfiguredObject, T>
extends ConfiguredObjectMethodAttribute<C, T> {
    private final DerivedAttribute _annotation;
    private final Pattern _secureValuePattern;

    ConfiguredDerivedMethodAttribute(Class<C> clazz, Method getter, DerivedAttribute annotation) {
        super(clazz, getter);
        this._annotation = annotation;
        String secureValueFilter = this._annotation.secureValueFilter();
        this._secureValuePattern = secureValueFilter == null || "".equals(secureValueFilter) ? null : Pattern.compile(secureValueFilter);
    }

    @Override
    public boolean isAutomated() {
        return false;
    }

    @Override
    public boolean isDerived() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return this._annotation.secure();
    }

    @Override
    public boolean isPersisted() {
        return this._annotation.persist();
    }

    @Override
    public boolean isOversized() {
        return this._annotation.oversize();
    }

    @Override
    public boolean updateAttributeDespiteUnchangedValue() {
        return false;
    }

    @Override
    public String getOversizedAltText() {
        return "";
    }

    @Override
    public String getDescription() {
        return this._annotation.description();
    }

    @Override
    public Pattern getSecureValueFilter() {
        return this._secureValuePattern;
    }

    public T convertValue(Object input, C configuredObject) {
        AttributeValueConverter converter = AttributeValueConverter.getConverter(this.getType(), this.getGetter().getGenericReturnType());
        return (T)converter.convert(input, (ConfiguredObject)configuredObject);
    }
}

