/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;

final class QpidByteBufferOutputStream
extends OutputStream {
    private final LinkedList<QpidByteBuffer> _buffers = new LinkedList();
    private int _bufferPosition = 0;
    private final byte[] _buffer;
    private final boolean _isDirect;
    private final int _maximumBufferSize;
    private boolean _closed;

    public QpidByteBufferOutputStream(boolean isDirect, int maximumBufferSize) {
        if (maximumBufferSize <= 0) {
            throw new IllegalArgumentException("Negative or zero maximumBufferSize illegal : " + maximumBufferSize);
        }
        this._isDirect = isDirect;
        this._maximumBufferSize = maximumBufferSize;
        this._buffer = new byte[this._maximumBufferSize];
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        this.allocateDataBuffers(data, offset, len);
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        this._buffers.forEach(QpidByteBuffer::dispose);
        this._buffers.clear();
    }

    QpidByteBuffer fetchAccumulatedBuffer() {
        if (this._bufferPosition != 0) {
            this.addSingleQpidByteBuffer(this._buffer, 0, this._bufferPosition);
        }
        QpidByteBuffer combined = QpidByteBuffer.concatenate(this._buffers);
        return combined;
    }

    private void allocateDataBuffers(byte[] data, int offset, int len) throws IOException {
        if (this._closed) {
            throw new IOException("Stream is closed");
        }
        do {
            int bytesWeCanWrite = Math.min(this._buffer.length - this._bufferPosition, len);
            System.arraycopy(data, offset, this._buffer, this._bufferPosition, bytesWeCanWrite);
            offset += bytesWeCanWrite;
            len -= bytesWeCanWrite;
            this._bufferPosition += bytesWeCanWrite;
            if (this._buffer.length != this._bufferPosition) continue;
            this.addSingleQpidByteBuffer(this._buffer, 0, this._buffer.length);
        } while (len != 0);
    }

    private void addSingleQpidByteBuffer(byte[] buffer, int offset, int length) {
        QpidByteBuffer current = this._isDirect ? QpidByteBuffer.allocateDirect(length) : QpidByteBuffer.allocate(length);
        current.put(buffer, offset, length);
        current.flip();
        this._buffers.add(current);
        this._bufferPosition = 0;
    }
}

