# PIP-119: Enable consistent hashing by default on KeyShared dispatcher

The consistent hashing implementation to uniformly assign keys to consumers
in the context of a KeyShared subscription, was introduced in
https://github.com/apache/pulsar/pull/6791, which was released in Pulsar 2.6.0.

While consistent hashing can use slightly more memory in certain cases, it is
more suitable as a general default implementation, as it leads to a fairer
distribution of keys across consumers, and avoiding corner cases that depend
on the sequence of addition/removal of consumers.

## Proposed changes

In 2.10 release, for the setting:

```properties
# On KeyShared subscriptions, with default AUTO_SPLIT mode, use splitting ranges or
# consistent hashing to reassign keys to new consumers
subscriptionKeySharedUseConsistentHashing=false
```

Change its default value to `true`.

The `AUTO_SPLIT` mode will not be removed nor deprecated. Users will still be
able to use the old implementation.
