/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.EntityAlreadyExistsException;
import org.apache.polaris.core.persistence.IntegrationPersistence;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.ChangeTrackingResult;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityWithPath;
import org.apache.polaris.core.persistence.dao.entity.ListEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.dao.entity.LoadPolicyMappingsResult;
import org.apache.polaris.core.persistence.dao.entity.PolicyAttachmentResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyMappingUtil;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationMetaStoreManager
extends BaseMetaStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicOperationMetaStoreManager.class);
    private final Clock clock;

    public AtomicOperationMetaStoreManager(Clock clock, PolarisDiagnostics diagnostics) {
        super(diagnostics);
        this.clock = clock;
    }

    private EntityResult persistNewEntity(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity) {
        entity = this.prepareToPersistNewEntity(callCtx, ms, entity);
        try {
            ms.writeEntity(callCtx, entity, true, null);
        }
        catch (EntityAlreadyExistsException e) {
            if (e.getExistingEntity().getId() == entity.getId()) {
                return new EntityResult(entity);
            }
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, e.getExistingEntity().getSubTypeCode());
        }
        return new EntityResult(entity);
    }

    @Nonnull
    private PolarisBaseEntity persistEntityAfterChange(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nonnull PolarisBaseEntity originalEntity) {
        entity = this.prepareToPersistEntityAfterChange(callCtx, ms, entity, nameOrParentChanged, originalEntity);
        ms.writeEntity(callCtx, entity, nameOrParentChanged, originalEntity);
        return entity;
    }

    private void dropEntity(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_dpo");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_name");
        this.getDiagnostics().check(entity.getDropTimestamp() == 0L, "already_dropped");
        ms.deleteEntity(callCtx, entity);
        List<PolarisGrantRecord> grantsOnGrantee = entity.getType().isGrantee() ? ms.loadAllGrantRecordsOnGrantee(callCtx, entity.getCatalogId(), entity.getId()) : List.of();
        List<PolarisGrantRecord> grantsOnSecurable = ms.loadAllGrantRecordsOnSecurable(callCtx, entity.getCatalogId(), entity.getId());
        ms.deleteAllEntityGrantRecords(callCtx, entity, grantsOnGrantee, grantsOnSecurable);
        if (entity.getType() == PolarisEntityType.POLICY || PolicyMappingUtil.isValidTargetEntityType(entity.getType(), entity.getSubType())) {
            try {
                List<PolarisPolicyMappingRecord> mappingOnPolicy = entity.getType() == PolarisEntityType.POLICY ? ms.loadAllTargetsOnPolicy(callCtx, entity.getCatalogId(), entity.getId(), PolicyEntity.of(entity).getPolicyTypeCode()) : List.of();
                List<PolarisPolicyMappingRecord> mappingOnTarget = entity.getType() == PolarisEntityType.POLICY ? List.of() : ms.loadAllPoliciesOnTarget(callCtx, entity.getCatalogId(), entity.getId());
                ms.deleteAllEntityPolicyMappingRecords(callCtx, entity, mappingOnTarget, mappingOnPolicy);
            }
            catch (UnsupportedOperationException mappingOnPolicy) {
                // empty catch block
            }
        }
        HashSet entityIdsGrantChanged = new HashSet();
        grantsOnGrantee.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getSecurableCatalogId(), gr.getSecurableId())));
        grantsOnSecurable.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getGranteeCatalogId(), gr.getGranteeId())));
        List<PolarisBaseEntity> entities = ms.lookupEntities(callCtx, new ArrayList<PolarisEntityId>(entityIdsGrantChanged));
        for (PolarisBaseEntity originalEntity : entities) {
            PolarisBaseEntity entityGrantChanged = originalEntity.withGrantRecordsVersion(originalEntity.getGrantRecordsVersion() + 1);
            ms.writeEntity(callCtx, entityGrantChanged, false, originalEntity);
        }
        if (entity.getType() == PolarisEntityType.PRINCIPAL) {
            PrincipalEntity principalEntity = PrincipalEntity.of(entity);
            String clientId = principalEntity.getClientId();
            ((IntegrationPersistence)((Object)ms)).deletePrincipalSecrets(callCtx, clientId, entity.getId());
        }
    }

    @Nonnull
    private PolarisGrantRecord persistNewGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisPrivilege priv) {
        this.getDiagnostics().checkNotNull(securable, "unexpected_null_securable");
        this.getDiagnostics().checkNotNull(grantee, "unexpected_null_grantee");
        this.getDiagnostics().checkNotNull(priv, "unexpected_null_priv");
        this.getDiagnostics().check(grantee.getType().isGrantee(), "entity_must_be_grantee", "entity={}", grantee);
        PolarisGrantRecord grantRecord = new PolarisGrantRecord(securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), priv.getCode());
        ms.writeToGrantRecords(callCtx, grantRecord);
        PolarisBaseEntity granteeEntity = ms.lookupEntity(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        this.getDiagnostics().checkNotNull(granteeEntity, "grantee_not_found", "grantee={}", grantee);
        PolarisBaseEntity updatedGranteeEntity = granteeEntity.withGrantRecordsVersion(granteeEntity.getGrantRecordsVersion() + 1);
        ms.writeEntity(callCtx, updatedGranteeEntity, false, granteeEntity);
        PolarisBaseEntity securableEntity = ms.lookupEntity(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        this.getDiagnostics().checkNotNull(securableEntity, "securable_not_found", "securable={}", securable);
        PolarisBaseEntity updatedSecurableEntity = securableEntity.withGrantRecordsVersion(securableEntity.getGrantRecordsVersion() + 1);
        ms.writeEntity(callCtx, updatedSecurableEntity, false, securableEntity);
        return grantRecord;
    }

    private void revokeGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisGrantRecord grantRecord) {
        this.getDiagnostics().check(securable.getCatalogId() == grantRecord.getSecurableCatalogId() && securable.getId() == grantRecord.getSecurableId(), "securable_mismatch", "securable={} grantRec={}", securable, grantRecord);
        this.getDiagnostics().check(grantee.getCatalogId() == grantRecord.getGranteeCatalogId() && grantee.getId() == grantRecord.getGranteeId(), "grantee_mismatch", "grantee={} grantRec={}", grantee, grantRecord);
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        ms.deleteFromGrantRecords(callCtx, grantRecord);
        PolarisBaseEntity refreshGrantee = ms.lookupEntity(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        this.getDiagnostics().checkNotNull(refreshGrantee, "missing_grantee", "grantRecord={} grantee={}", grantRecord, grantee);
        PolarisBaseEntity updatedRefreshGrantee = refreshGrantee.withGrantRecordsVersion(refreshGrantee.getGrantRecordsVersion() + 1);
        ms.writeEntity(callCtx, updatedRefreshGrantee, false, refreshGrantee);
        PolarisBaseEntity refreshSecurable = ms.lookupEntity(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        this.getDiagnostics().checkNotNull(refreshSecurable, "missing_securable", "grantRecord={} securable={}", grantRecord, securable);
        PolarisBaseEntity updatedRefreshSecurable = refreshSecurable.withGrantRecordsVersion(refreshSecurable.getGrantRecordsVersion() + 1);
        ms.writeEntity(callCtx, updatedRefreshSecurable, false, refreshSecurable);
    }

    @Override
    @Nonnull
    public CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity catalog, @Nonnull List<PolarisEntityCore> principalRoles) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(catalog, "unexpected_null_catalog");
        Map<String, String> internalProp = catalog.getInternalPropertiesAsMap();
        String integrationIdentifierOrId = internalProp.get(PolarisEntityConstants.getStorageIntegrationIdentifierPropertyName());
        String storageConfigInfoStr = internalProp.get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        PolarisStorageIntegration integration = storageConfigInfoStr != null && integrationIdentifierOrId == null ? ((IntegrationPersistence)((Object)ms)).createStorageIntegration(callCtx, catalog.getCatalogId(), catalog.getId(), PolarisStorageConfigurationInfo.deserialize(storageConfigInfoStr)) : null;
        PolarisBaseEntity refreshCatalog = ms.lookupEntity(callCtx, catalog.getCatalogId(), catalog.getId(), catalog.getTypeCode());
        if (refreshCatalog != null) {
            this.getDiagnostics().check(refreshCatalog.getTypeCode() == PolarisEntityType.CATALOG.getCode(), "not_a_catalog", "catalog={}", catalog);
            PolarisBaseEntity catalogAdminRole = ms.lookupEntityByName(callCtx, refreshCatalog.getId(), refreshCatalog.getId(), PolarisEntityType.CATALOG_ROLE.getCode(), PolarisEntityConstants.getNameOfCatalogAdminRole());
            this.getDiagnostics().checkNotNull(catalogAdminRole, "catalog_admin_role_not_found", "catalog={}", refreshCatalog);
            return new CreateCatalogResult(refreshCatalog, catalogAdminRole);
        }
        ((IntegrationPersistence)((Object)ms)).persistStorageIntegrationIfNeeded(callCtx, catalog, integration);
        EntityResult lowLevelResult = this.persistNewEntity(callCtx, ms, catalog);
        if (lowLevelResult.getReturnStatus() == BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS) {
            return new CreateCatalogResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        long adminRoleId = ms.generateNewId(callCtx);
        PolarisBaseEntity adminRole = new PolarisBaseEntity(catalog.getId(), adminRoleId, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.NULL_SUBTYPE, catalog.getId(), PolarisEntityConstants.getNameOfCatalogAdminRole());
        this.persistNewEntity(callCtx, ms, adminRole);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_ACCESS);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_METADATA);
        if (principalRoles.isEmpty()) {
            PolarisBaseEntity serviceAdminRole = ms.lookupEntityByName(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
            this.getDiagnostics().checkNotNull(serviceAdminRole, "missing_service_admin_role");
            this.persistNewGrantRecord(callCtx, ms, adminRole, serviceAdminRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
        } else {
            for (PolarisEntityCore principalRole : principalRoles) {
                this.getDiagnostics().checkNotNull(principalRole, "null principal role");
                this.getDiagnostics().check(principalRole.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode(), "not_principal_role", "type={}", new Object[]{principalRole.getType()});
                this.persistNewGrantRecord(callCtx, ms, adminRole, principalRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
            }
        }
        return new CreateCatalogResult(catalog, adminRole);
    }

    @Override
    @Nonnull
    public BaseResult bootstrapPolarisService(@Nonnull PolarisCallContext callCtx) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
        this.persistNewEntity(callCtx, ms, rootContainer);
        long rootPrincipalId = ms.generateNewId(callCtx);
        PrincipalEntity rootPrincipal = ((PrincipalEntity.Builder)((PrincipalEntity.Builder)((PrincipalEntity.Builder)new PrincipalEntity.Builder().setId(rootPrincipalId)).setName(PolarisEntityConstants.getRootPrincipalName())).setCreateTimestamp(System.currentTimeMillis())).build();
        this.createPrincipal(callCtx, rootPrincipal);
        long serviceAdminPrincipalRoleId = ms.generateNewId(callCtx);
        PrincipalRoleEntity serviceAdminPrincipalRole = ((PrincipalRoleEntity.Builder)((PrincipalRoleEntity.Builder)((PrincipalRoleEntity.Builder)new PrincipalRoleEntity.Builder().setId(serviceAdminPrincipalRoleId)).setName(PolarisEntityConstants.getNameOfPrincipalServiceAdminRole())).setCreateTimestamp(System.currentTimeMillis())).build();
        this.persistNewEntity(callCtx, ms, serviceAdminPrincipalRole);
        this.persistNewGrantRecord(callCtx, ms, serviceAdminPrincipalRole, rootPrincipal, PolarisPrivilege.PRINCIPAL_ROLE_USAGE);
        this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminPrincipalRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Override
    @Nonnull
    public BaseResult purge(@Nonnull PolarisCallContext callCtx) {
        BasePersistence ms = callCtx.getMetaStore();
        LOGGER.warn("Deleting all metadata in the metastore...");
        ms.deleteAll(callCtx);
        LOGGER.warn("Finished deleting all metadata in the metastore");
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Override
    @Nonnull
    public EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        long parentId;
        long catalogId;
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntityByName(callCtx, catalogId = catalogPath == null || catalogPath.size() == 0 ? 0L : catalogPath.get(0).getId(), parentId = catalogPath == null || catalogPath.size() == 0 ? 0L : catalogPath.get(catalogPath.size() - 1).getId(), entityType.getCode(), name);
        if (entity != null && entitySubType != PolarisEntitySubType.ANY_SUBTYPE && entity.getSubTypeCode() != entitySubType.getCode()) {
            entity = null;
        }
        return entity == null ? new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new EntityResult(entity);
    }

    @Override
    @Nonnull
    public ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        BasePersistence ms = callCtx.getMetaStore();
        long catalogId = catalogPath == null || catalogPath.isEmpty() ? 0L : catalogPath.get(0).getId();
        long parentId = catalogPath == null || catalogPath.isEmpty() ? 0L : catalogPath.get(catalogPath.size() - 1).getId();
        Page<EntityNameLookupRecord> resultPage = ms.listEntities(callCtx, catalogId, parentId, entityType, entitySubType, pageToken);
        return ListEntitiesResult.fromPage(resultPage);
    }

    @Override
    @Nonnull
    public Page<PolarisBaseEntity> listFullEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        BasePersistence ms = callCtx.getMetaStore();
        long catalogId = catalogPath == null || catalogPath.isEmpty() ? 0L : catalogPath.get(0).getId();
        long parentId = catalogPath == null || catalogPath.isEmpty() ? 0L : catalogPath.get(catalogPath.size() - 1).getId();
        return ms.listFullEntities(callCtx, catalogId, parentId, entityType, entitySubType, entity -> true, Function.identity(), pageToken);
    }

    @Override
    @Nonnull
    public CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull PrincipalEntity principal) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(principal, "unexpected_null_principal");
        PrincipalEntity refreshPrincipal = PrincipalEntity.of(ms.lookupEntity(callCtx, principal.getCatalogId(), principal.getId(), principal.getTypeCode()));
        if (refreshPrincipal != null) {
            String clientId = refreshPrincipal.getClientId();
            this.getDiagnostics().checkNotNull(clientId, "null_client_id", "principal={}", refreshPrincipal);
            this.getDiagnostics().check(!clientId.isEmpty(), "empty_client_id", "principal={}", refreshPrincipal);
            PolarisPrincipalSecrets principalSecrets = ((IntegrationPersistence)((Object)ms)).loadPrincipalSecrets(callCtx, clientId);
            this.getDiagnostics().checkNotNull(principalSecrets, "missing_principal_secrets", "clientId={} principal={}", clientId, refreshPrincipal);
            return new CreatePrincipalResult(refreshPrincipal, principalSecrets);
        }
        PolarisPrincipalSecrets principalSecrets = ((IntegrationPersistence)((Object)ms)).generateNewPrincipalSecrets(callCtx, principal.getName(), principal.getId());
        PrincipalEntity updatedPrincipal = new PrincipalEntity.Builder(principal).setClientId(principalSecrets.getPrincipalClientId()).build();
        EntityResult lowLevelResult = this.persistNewEntity(callCtx, ms, updatedPrincipal);
        if (lowLevelResult.getReturnStatus() == BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS) {
            ((IntegrationPersistence)((Object)ms)).deletePrincipalSecrets(callCtx, principalSecrets.getPrincipalClientId(), updatedPrincipal.getId());
            return new CreatePrincipalResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        return new CreatePrincipalResult(updatedPrincipal, principalSecrets);
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisPrincipalSecrets secrets = ((IntegrationPersistence)((Object)ms)).loadPrincipalSecrets(callCtx, clientId);
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    public void deletePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        BasePersistence ms = callCtx.getMetaStore();
        ((IntegrationPersistence)((Object)ms)).deletePrincipalSecrets(callCtx, clientId, principalId);
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        BasePersistence ms = callCtx.getMetaStore();
        Optional<PrincipalEntity> principalLookup = this.findPrincipalById(callCtx, principalId);
        if (principalLookup.isEmpty()) {
            return new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        PrincipalEntity principal = principalLookup.get();
        Map<String, String> internalProps = principal.getInternalPropertiesAsMap();
        boolean doReset = reset || internalProps.get("CREDENTIAL_ROTATION_REQUIRED") != null;
        PolarisPrincipalSecrets secrets = ((IntegrationPersistence)((Object)ms)).rotatePrincipalSecrets(callCtx, clientId, principalId, doReset, oldSecretHash);
        PolarisBaseEntity.Builder principalBuilder = new PolarisBaseEntity.Builder(principal);
        if (reset && !internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.put("CREDENTIAL_ROTATION_REQUIRED", "true");
            principalBuilder.internalPropertiesAsMap(internalProps);
            principalBuilder.entityVersion(principal.getEntityVersion() + 1);
            ms.writeEntity(callCtx, principalBuilder.build(), true, principal);
        } else if (internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.remove("CREDENTIAL_ROTATION_REQUIRED");
            principalBuilder.internalPropertiesAsMap(internalProps);
            principalBuilder.entityVersion(principal.getEntityVersion() + 1);
            ms.writeEntity(callCtx, principalBuilder.build(), true, principal);
        }
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult resetPrincipalSecrets(@Nonnull PolarisCallContext callCtx, long principalId, @Nonnull String resolvedClientId, String customClientSecret) {
        BasePersistence ms = callCtx.getMetaStore();
        Optional<PrincipalEntity> principalEntity = this.findPrincipalById(callCtx, principalId);
        if (principalEntity.isEmpty()) {
            return new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        PolarisPrincipalSecrets secrets = ((IntegrationPersistence)((Object)ms)).storePrincipalSecrets(callCtx, principalId, resolvedClientId, customClientSecret);
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    @Nonnull
    public EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_entity_name");
        return this.persistNewEntity(callCtx, ms, entity);
    }

    @Override
    @Nonnull
    public EntitiesResult createEntitiesIfNotExist(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull List<? extends PolarisBaseEntity> entities) {
        BasePersistence ms = callCtx.getMetaStore();
        ArrayList<PolarisBaseEntity> createdEntities = new ArrayList<PolarisBaseEntity>(entities.size());
        for (PolarisBaseEntity polarisBaseEntity : entities) {
            PolarisBaseEntity entityToCreate = this.prepareToPersistNewEntity(callCtx, ms, new PolarisBaseEntity.Builder(polarisBaseEntity).build());
            createdEntities.add(entityToCreate);
        }
        try {
            ms.writeEntities(callCtx, createdEntities, null);
        }
        catch (EntityAlreadyExistsException e) {
            return new EntitiesResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, String.format("Existing entity id: '%s', type %s subtype %s", e.getExistingEntity().getId(), e.getExistingEntity().getTypeCode(), e.getExistingEntity().getSubTypeCode()));
        }
        return new EntitiesResult(Page.fromItems(createdEntities));
    }

    @Override
    @Nonnull
    public EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        try {
            PolarisBaseEntity persistedEntity = this.persistEntityAfterChange(callCtx, ms, entity, false, entity);
            return new EntityResult(persistedEntity);
        }
        catch (RetryOnConcurrencyException e) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, e.getMessage());
        }
    }

    @Override
    @Nonnull
    public EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull List<EntityWithPath> entities) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(entities, "unexpected_null_entities");
        ArrayList<PolarisBaseEntity> updatedEntities = new ArrayList<PolarisBaseEntity>(entities.size());
        ArrayList<PolarisBaseEntity> originalEntities = new ArrayList<PolarisBaseEntity>(entities.size());
        for (EntityWithPath entityWithPath : entities) {
            PolarisBaseEntity updatedEntity = this.prepareToPersistEntityAfterChange(callCtx, ms, new PolarisBaseEntity.Builder(entityWithPath.getEntity()).build(), false, entityWithPath.getEntity());
            originalEntities.add(entityWithPath.getEntity());
            updatedEntities.add(updatedEntity);
        }
        try {
            ms.writeEntities(callCtx, updatedEntities, originalEntities);
        }
        catch (RetryOnConcurrencyException e) {
            return new EntitiesResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, e.getMessage());
        }
        return new EntitiesResult(Page.fromItems(updatedEntities));
    }

    @Override
    @Nonnull
    public EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisEntity renamedEntity) {
        long parentId;
        PolarisBaseEntity refreshEntityToRename;
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(entityToRename, "unexpected_null_entityToRename");
        this.getDiagnostics().checkNotNull(renamedEntity, "unexpected_null_renamedEntity");
        this.getDiagnostics().check(newCatalogPath == null || catalogPath != null, "newCatalogPath_specified_without_catalogPath");
        if (newCatalogPath == null) {
            newCatalogPath = catalogPath;
        }
        if ((refreshEntityToRename = ms.lookupEntity(callCtx, entityToRename.getCatalogId(), entityToRename.getId(), entityToRename.getTypeCode())) == null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToRename.getEntityVersion() != renamedEntity.getEntityVersion()) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, null);
        }
        if (refreshEntityToRename.cannotBeDroppedOrRenamed()) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RENAMED, null);
        }
        long catalogId = newCatalogPath == null || newCatalogPath.size() == 0 ? 0L : newCatalogPath.get(0).getId();
        EntityNameLookupRecord entityActiveRecord = ms.lookupEntityIdAndSubTypeByName(callCtx, catalogId, parentId = newCatalogPath == null || newCatalogPath.size() == 0 ? 0L : newCatalogPath.get(newCatalogPath.size() - 1).getId(), refreshEntityToRename.getTypeCode(), renamedEntity.getName());
        if (entityActiveRecord != null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, entityActiveRecord.getSubTypeCode());
        }
        PolarisBaseEntity.Builder refreshEntityToRenameBuilder = new PolarisBaseEntity.Builder(refreshEntityToRename);
        refreshEntityToRenameBuilder.name(renamedEntity.getName());
        refreshEntityToRenameBuilder.properties(renamedEntity.getProperties());
        refreshEntityToRenameBuilder.internalProperties(renamedEntity.getInternalProperties());
        if (newCatalogPath != null) {
            refreshEntityToRenameBuilder.parentId(parentId);
        }
        PolarisBaseEntity renamedEntityToReturn = this.persistEntityAfterChange(callCtx, ms, refreshEntityToRenameBuilder.build(), true, refreshEntityToRename);
        return new EntityResult(renamedEntityToReturn);
    }

    @Override
    @Nonnull
    public DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().checkNotNull(entityToDrop, "unexpected_null_entity");
        PolarisBaseEntity refreshEntityToDrop = ms.lookupEntity(callCtx, entityToDrop.getCatalogId(), entityToDrop.getId(), entityToDrop.getTypeCode());
        if (refreshEntityToDrop == null) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToDrop.cannotBeDroppedOrRenamed()) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_UNDROPPABLE, null);
        }
        if (refreshEntityToDrop.getType() == PolarisEntityType.CATALOG) {
            long catalogId = refreshEntityToDrop.getId();
            CatalogEntity catalogEntityToDrop = CatalogEntity.of(refreshEntityToDrop);
            if (!(catalogEntityToDrop.isPassthroughFacade() && callCtx.getRealmConfig().getConfig(FeatureConfiguration.ALLOW_DROPPING_NON_EMPTY_PASSTHROUGH_FACADE_CATALOG, catalogEntityToDrop).booleanValue() || !ms.hasChildren(callCtx, PolarisEntityType.NAMESPACE, catalogId, catalogId))) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, catalogEntityToDrop.isPassthroughFacade() ? String.format("Set %s to true to drop non-empty passthrough facade catalogs", FeatureConfiguration.ALLOW_DROPPING_NON_EMPTY_PASSTHROUGH_FACADE_CATALOG.key()) : null);
            }
            List catalogRoles = ms.listFullEntities(callCtx, catalogId, catalogId, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.ANY_SUBTYPE, entity -> true, Function.identity(), PageToken.fromLimit(2)).items();
            if (catalogRoles.size() > 1) {
                return new DropEntityResult(BaseResult.ReturnStatus.CATALOG_NOT_EMPTY, null);
            }
            if (!catalogRoles.isEmpty()) {
                this.dropEntity(callCtx, ms, (PolarisBaseEntity)catalogRoles.get(0));
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.NAMESPACE) {
            if (ms.hasChildren(callCtx, null, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId())) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, null);
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.POLICY && !cleanup) {
            try {
                List<PolarisPolicyMappingRecord> records = ms.loadAllTargetsOnPolicy(callCtx, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId(), PolicyEntity.of(refreshEntityToDrop).getPolicyTypeCode());
                if (!records.isEmpty()) {
                    return new DropEntityResult(BaseResult.ReturnStatus.POLICY_HAS_MAPPINGS, null);
                }
            }
            catch (UnsupportedOperationException records) {
                // empty catch block
            }
        }
        this.dropEntity(callCtx, ms, refreshEntityToDrop);
        if (cleanup && refreshEntityToDrop.getType() != PolarisEntityType.POLICY) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("taskType", String.valueOf(AsyncTaskType.ENTITY_CLEANUP_SCHEDULER.typeCode()));
            properties.put("data", PolarisObjectMapperUtil.serialize(refreshEntityToDrop));
            PolarisBaseEntity.Builder taskEntityBuilder = ((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)new PolarisBaseEntity.Builder().propertiesAsMap(properties).id(ms.generateNewId(callCtx))).catalogId(0L)).name("entityCleanup_" + entityToDrop.getId())).typeCode(PolarisEntityType.TASK.getCode())).subTypeCode(PolarisEntitySubType.NULL_SUBTYPE.getCode()).createTimestamp(this.clock.millis());
            if (cleanupProperties != null) {
                taskEntityBuilder.internalPropertiesAsMap(cleanupProperties);
            }
            PolarisBaseEntity taskEntity = taskEntityBuilder.build();
            this.createEntityIfNotExists(callCtx, null, taskEntity);
            return new DropEntityResult(taskEntity.getId());
        }
        return new DropEntityResult();
    }

    @Override
    @Nonnull
    public PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, role, grantee, usagePriv);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        PolarisGrantRecord grantRecord = ms.lookupGrantRecord(callCtx, role.getCatalogId(), role.getId(), grantee.getCatalogId(), grantee.getId(), usagePriv.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, role, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, securable, grantee, privilege);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisGrantRecord grantRecord = ms.lookupGrantRecord(callCtx, securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), privilege.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, securable, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, PolarisEntityCore securable) {
        return this.loadGrantsOnSecurable(callCtx, securable.getCatalogId(), securable.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        BasePersistence ms = callCtx.getMetaStore();
        int grantsVersion = ms.lookupEntityGrantRecordsVersion(callCtx, securableCatalogId, securableId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnSecurable(callCtx, securableCatalogId, securableId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getGranteeCatalogId(), grantRecord.getGranteeId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntities(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, PolarisEntityCore grantee) {
        return this.loadGrantsToGrantee(callCtx, grantee.getCatalogId(), grantee.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        BasePersistence ms = callCtx.getMetaStore();
        int grantsVersion = ms.lookupEntityGrantRecordsVersion(callCtx, granteeCatalogId, granteeId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnGrantee(callCtx, granteeCatalogId, granteeId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getSecurableCatalogId(), grantRecord.getSecurableId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntities(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityId> entityIds) {
        BasePersistence ms = callCtx.getMetaStore();
        List<PolarisChangeTrackingVersions> changeTracking = ms.lookupEntityVersions(callCtx, entityIds);
        return new ChangeTrackingResult(changeTracking);
    }

    @Override
    @Nonnull
    public EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, @Nonnull PolarisEntityType entityType) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntity(callCtx, entityCatalogId, entityId, entityType.getCode());
        return entity != null ? new EntityResult(entity) : new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
    }

    @Override
    @Nonnull
    public EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, String executorId, PageToken pageToken) {
        BasePersistence ms = callCtx.getMetaStore();
        Page availableTasks = ms.listFullEntities(callCtx, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.TASK, PolarisEntitySubType.ANY_SUBTYPE, entity -> {
            PolarisObjectMapperUtil.TaskExecutionState taskState = PolarisObjectMapperUtil.parseTaskState(entity);
            long taskAgeTimeout = callCtx.getRealmConfig().getConfig("POLARIS_TASK_TIMEOUT_MILLIS", 300000L);
            return taskState == null || taskState.executor == null || this.clock.millis() - taskState.lastAttemptStartTime > taskAgeTimeout;
        }, Function.identity(), pageToken);
        AtomicInteger failedLeaseCount = new AtomicInteger(0);
        List loadedTasks = availableTasks.items().stream().map(task -> {
            PolarisBaseEntity.Builder updatedTaskBuilder = new PolarisBaseEntity.Builder((PolarisBaseEntity)task);
            Map<String, String> properties = task.getPropertiesAsMap();
            properties.put("lastAttemptExecutorId", executorId);
            properties.put("lastAttemptStartTime", String.valueOf(this.clock.millis()));
            properties.put("attemptCount", String.valueOf(Integer.parseInt(properties.getOrDefault("attemptCount", "0")) + 1));
            updatedTaskBuilder.propertiesAsMap(properties);
            EntityResult result = this.updateEntityPropertiesIfNotChanged(callCtx, null, updatedTaskBuilder.build());
            if (result.getReturnStatus() == BaseResult.ReturnStatus.SUCCESS) {
                return result.getEntity();
            }
            failedLeaseCount.getAndIncrement();
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (loadedTasks.isEmpty() && failedLeaseCount.get() > 0) {
            throw new RetryOnConcurrencyException("Failed to lease any of %s tasks due to concurrent leases", failedLeaseCount.get());
        }
        return EntitiesResult.fromPage(Page.fromItems(loadedTasks));
    }

    @Override
    @Nonnull
    public ScopedCredentialsResult getSubscopedCredsForEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, @Nonnull PolarisEntityType entityType, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        BasePersistence ms = callCtx.getMetaStore();
        this.getDiagnostics().check(!allowedReadLocations.isEmpty() || !allowedWriteLocations.isEmpty(), "allowed_locations_to_subscope_is_required");
        EntityResult reloadedEntity = this.loadEntity(callCtx, catalogId, entityId, entityType);
        if (reloadedEntity.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return new ScopedCredentialsResult(reloadedEntity.getReturnStatus(), reloadedEntity.getExtraInformation());
        }
        PolarisStorageIntegration storageIntegration = ((IntegrationPersistence)((Object)ms)).loadPolarisStorageIntegration(callCtx, reloadedEntity.getEntity());
        this.getDiagnostics().checkNotNull(storageIntegration, "storage_integration_not_exists", "catalogId={}, entityId={}", catalogId, entityId);
        try {
            StorageAccessConfig storageAccessConfig = storageIntegration.getSubscopedCreds(callCtx.getRealmConfig(), allowListOperation, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
            return new ScopedCredentialsResult(storageAccessConfig);
        }
        catch (Exception ex) {
            return new ScopedCredentialsResult(BaseResult.ReturnStatus.SUBSCOPE_CREDS_ERROR, ex.getMessage());
        }
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, PolarisEntityType entityType) {
        List<PolarisGrantRecord> grantRecords;
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntity(callCtx, entityCatalogId, entityId, entityType.getCode());
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGrantee(callCtx, entityCatalogId, entityId));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entityId));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entityId);
        }
        return new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        List<PolarisGrantRecord> grantRecords;
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntityByName(callCtx, entityCatalogId, parentId, entityType.getCode(), entityName);
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGrantee(callCtx, entityCatalogId, entity.getId()));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entity.getId()));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entity.getId());
        }
        ResolvedEntityResult result = new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
        if (PolarisEntityConstants.getRootContainerName().equals(entityName) && entityType == PolarisEntityType.ROOT && !result.isSuccess()) {
            PolarisBaseEntity serviceAdminRole;
            PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
            EntityResult backfillResult = this.createEntityIfNotExists(callCtx, null, rootContainer);
            if (backfillResult.isSuccess() && (serviceAdminRole = ms.lookupEntityByName(callCtx, 0L, 0L, PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole())) != null) {
                this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
            }
            result = this.loadResolvedEntityByName(callCtx, entityCatalogId, parentId, entityType, entityName);
        }
        return result;
    }

    @Override
    @Nonnull
    public ResolvedEntitiesResult loadResolvedEntities(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityType entityType, @Nonnull List<PolarisEntityId> entityIds) {
        BasePersistence ms = callCtx.getMetaStore();
        return AtomicOperationMetaStoreManager.getResolvedEntitiesResult(callCtx, ms, entityIds, i -> entityType);
    }

    private static ResolvedEntitiesResult getResolvedEntitiesResult(PolarisCallContext callCtx, BasePersistence ms, List<PolarisEntityId> entityIds, Function<Integer, PolarisEntityType> entityTypeForIndex) {
        List<PolarisBaseEntity> entities = ms.lookupEntities(callCtx, entityIds);
        List<ResolvedPolarisEntity> ret = IntStream.range(0, entityIds.size()).mapToObj(i -> {
            if (entities.get(i) != null && !((PolarisBaseEntity)entities.get(i)).getType().equals(entityTypeForIndex.apply(i))) {
                return null;
            }
            return (PolarisBaseEntity)entities.get(i);
        }).map(e -> AtomicOperationMetaStoreManager.toResolvedPolarisEntity(callCtx, e, ms)).collect(Collectors.toList());
        return new ResolvedEntitiesResult(ret);
    }

    private static ResolvedPolarisEntity toResolvedPolarisEntity(PolarisCallContext callCtx, PolarisBaseEntity e, BasePersistence ms) {
        if (e == null) {
            return null;
        }
        List<PolarisGrantRecord> grantRecordsAsSecurable = ms.loadAllGrantRecordsOnSecurable(callCtx, e.getCatalogId(), e.getId());
        List<PolarisGrantRecord> grantRecordsAsGrantee = e.getType().isGrantee() ? ms.loadAllGrantRecordsOnGrantee(callCtx, e.getCatalogId(), e.getId()) : List.of();
        return new ResolvedPolarisEntity(PolarisEntity.of(e), grantRecordsAsGrantee, grantRecordsAsSecurable);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity;
        BasePersistence ms = callCtx.getMetaStore();
        PolarisChangeTrackingVersions entityVersions = ms.lookupEntityVersions(callCtx, List.of(new PolarisEntityId(entityCatalogId, entityId))).get(0);
        if (entityVersions == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entityVersion != entityVersions.getEntityVersion()) {
            entity = ms.lookupEntity(callCtx, entityCatalogId, entityId, entityType.getCode());
            if (entity == null) {
                return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
            }
        } else {
            entity = null;
        }
        if (entityVersions.getGrantRecordsVersion() != entityGrantRecordsVersion) {
            if (entityType.isGrantee()) {
                grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGrantee(callCtx, entityCatalogId, entityId));
                grantRecords.addAll(ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entityId));
            } else {
                grantRecords = ms.loadAllGrantRecordsOnSecurable(callCtx, entityCatalogId, entityId);
            }
        } else {
            grantRecords = null;
        }
        return new ResolvedEntityResult(entity, entityVersions.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        BasePersistence ms = callContext.getMetaStore();
        return ms.hasOverlappingSiblings(callContext, entity);
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult attachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        BasePersistence ms = callCtx.getMetaStore();
        return this.persistNewPolicyMappingRecord(callCtx, ms, target, policy, parameters);
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult detachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisPolicyMappingRecord mappingRecord = ms.lookupPolicyMappingRecord(callCtx, target.getCatalogId(), target.getId(), policy.getPolicyTypeCode(), policy.getCatalogId(), policy.getId());
        if (mappingRecord == null) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_NOT_FOUND, null);
        }
        ms.deleteFromPolicyMappingRecords(callCtx, mappingRecord);
        return new PolicyAttachmentResult(mappingRecord);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntity(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadAllPoliciesOnTarget(callCtx, target.getCatalogId(), target.getId());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        BasePersistence ms = callCtx.getMetaStore();
        PolarisBaseEntity entity = ms.lookupEntity(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadPoliciesOnTargetByType(callCtx, target.getCatalogId(), target.getId(), policyType.getCode());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Nonnull
    private PolicyAttachmentResult persistNewPolicyMappingRecord(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisEntityCore target, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        this.getDiagnostics().checkNotNull(target, "unexpected_null_target");
        this.getDiagnostics().checkNotNull(policy, "unexpected_null_policy");
        PolarisPolicyMappingRecord mappingRecord = new PolarisPolicyMappingRecord(target.getCatalogId(), target.getId(), policy.getCatalogId(), policy.getId(), policy.getPolicyTypeCode(), parameters);
        try {
            ms.writeToPolicyMappingRecords(callCtx, mappingRecord);
        }
        catch (IllegalArgumentException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.UNEXPECTED_ERROR_SIGNALED, "Unknown policy type");
        }
        catch (PolicyMappingAlreadyExistsException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_OF_SAME_TYPE_ALREADY_EXISTS, e.getExistingRecord().getPolicyTypeCode());
        }
        return new PolicyAttachmentResult(mappingRecord);
    }

    private List<PolarisBaseEntity> loadPoliciesFromMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull List<PolarisPolicyMappingRecord> policyMappingRecords) {
        List<PolarisEntityId> policyEntityIds = policyMappingRecords.stream().map(policyMappingRecord -> new PolarisEntityId(policyMappingRecord.getPolicyCatalogId(), policyMappingRecord.getPolicyId())).distinct().collect(Collectors.toList());
        return ms.lookupEntities(callCtx, policyEntityIds);
    }
}

