/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.common;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;

public class LocationUtils {
    private static final HashFunction HASH_FUNC = Hashing.murmur3_32_fixed();
    public static final int HASH_BINARY_STRING_BITS = 20;
    public static final int ENTROPY_DIR_LENGTH = 4;
    public static final int ENTROPY_DIR_DEPTH = 3;

    public static String computeHash(@Nonnull String fileName) {
        HashCode hashCode = HASH_FUNC.hashString((CharSequence)fileName, StandardCharsets.UTF_8);
        String hashAsBinaryString = Integer.toBinaryString(hashCode.asInt() | Integer.MIN_VALUE);
        String hash = hashAsBinaryString.substring(hashAsBinaryString.length() - 20);
        return LocationUtils.dirsFromHash(hash);
    }

    private static String dirsFromHash(String hash) {
        StringBuilder hashWithDirs = new StringBuilder();
        for (int i = 0; i < 12; i += 4) {
            if (i > 0) {
                hashWithDirs.append("/");
            }
            hashWithDirs.append(hash, i, Math.min(i + 4, hash.length()));
        }
        if (hash.length() > 12) {
            hashWithDirs.append("/").append(hash, 12, hash.length());
        }
        return hashWithDirs.toString();
    }
}

