/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.TenantDatabase;

public class DescribeTenantDatabasesPublisher
implements SdkPublisher<DescribeTenantDatabasesResponse> {
    private final RdsAsyncClient client;
    private final DescribeTenantDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTenantDatabasesPublisher(RdsAsyncClient client, DescribeTenantDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTenantDatabasesPublisher(RdsAsyncClient client, DescribeTenantDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTenantDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTenantDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TenantDatabase> tenantDatabases() {
        Function<DescribeTenantDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenantDatabases() != null) {
                return response.tenantDatabases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTenantDatabasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTenantDatabasesResponseFetcher
    implements AsyncPageFetcher<DescribeTenantDatabasesResponse> {
        private DescribeTenantDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTenantDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTenantDatabasesResponse> nextPage(DescribeTenantDatabasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTenantDatabasesPublisher.this.client.describeTenantDatabases(DescribeTenantDatabasesPublisher.this.firstRequest);
            }
            return DescribeTenantDatabasesPublisher.this.client.describeTenantDatabases((DescribeTenantDatabasesRequest)((Object)DescribeTenantDatabasesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

