/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public class DescribeDBClusterParametersIterable
implements SdkIterable<DescribeDbClusterParametersResponse> {
    private final RdsClient client;
    private final DescribeDbClusterParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterParametersIterable(RdsClient client, DescribeDbClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbClusterParametersResponseFetcher();
    }

    public Iterator<DescribeDbClusterParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDbClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterParametersResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterParametersResponse> {
        private DescribeDbClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterParametersResponse nextPage(DescribeDbClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterParametersIterable.this.client.describeDBClusterParameters(DescribeDBClusterParametersIterable.this.firstRequest);
            }
            return DescribeDBClusterParametersIterable.this.client.describeDBClusterParameters((DescribeDbClusterParametersRequest)((Object)DescribeDBClusterParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

