/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.ServerInterceptor;
import io.grpc.xds.ConfigOrError;
import io.grpc.xds.Filter;
import io.grpc.xds.RbacConfig;
import io.grpc.xds.RbacFilter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.rbac.v3.RBAC;

@Internal
public final class InternalRbacFilter {
    private InternalRbacFilter() {
    }

    public static ServerInterceptor createInterceptor(RBAC rbac) {
        ConfigOrError<RbacConfig> filterConfig = RbacFilter.Provider.parseRbacConfig(rbac);
        if (filterConfig.errorDetail != null) {
            throw new IllegalArgumentException(String.format("Failed to parse Rbac policy: %s", filterConfig.errorDetail));
        }
        return new RbacFilter.Provider().newInstance("internalRbacFilter").buildServerInterceptor((Filter.FilterConfig)filterConfig.config, null);
    }
}

