/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.health;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceSupport;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class DataSourceHealthCheck
implements HealthCheck {
    @Inject
    Instance<DataSourceSupport> dataSourceSupport;
    @Inject
    Instance<AgroalDataSourceSupport> agroalDataSourceSupport;
    private final Map<String, DataSource> checkedDataSources = new HashMap<String, DataSource>();

    @PostConstruct
    protected void init() {
        if (!this.dataSourceSupport.isResolvable() || !this.agroalDataSourceSupport.isResolvable()) {
            return;
        }
        DataSourceSupport support = (DataSourceSupport)this.dataSourceSupport.get();
        Set healthCheckExcludedNames = support.getHealthCheckExcludedNames();
        for (String name : ((AgroalDataSourceSupport)this.agroalDataSourceSupport.get()).entries.keySet()) {
            Optional<AgroalDataSource> dataSource;
            if (healthCheckExcludedNames.contains(name) || !(dataSource = AgroalDataSourceUtil.dataSourceIfActive(name)).isPresent()) continue;
            this.checkedDataSources.put(name, (DataSource)dataSource.get());
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Database connections health check").up();
        for (Map.Entry<String, DataSource> dataSource : this.checkedDataSources.entrySet()) {
            String data;
            boolean isDefault = DataSourceUtil.isDefault((String)dataSource.getKey());
            AgroalDataSource ads = (AgroalDataSource)dataSource.getValue();
            String dsName = dataSource.getKey();
            try {
                boolean valid = ads.isHealthy(false);
                if (!valid) {
                    data = isDefault ? "validation check failed for the default DataSource" : "validation check failed for DataSource '" + dataSource.getKey() + "'";
                    builder.down().withData(dsName, data);
                    continue;
                }
                builder.withData(dsName, "UP");
            }
            catch (SQLException e) {
                data = isDefault ? "Unable to execute the validation check for the default DataSource: " : "Unable to execute the validation check for DataSource '" + dataSource.getKey() + "': ";
                builder.down().withData(dsName, data + e.getMessage());
            }
        }
        return builder.build();
    }

    protected Map<String, DataSource> getCheckedDataSources() {
        return Collections.unmodifiableMap(this.checkedDataSources);
    }
}

