/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SignatureData is the corresponding interface of SignatureData
type SignatureData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAlgorithm returns Algorithm (property field)
	GetAlgorithm() PascalString
	// GetSignature returns Signature (property field)
	GetSignature() PascalByteString
	// IsSignatureData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSignatureData()
	// CreateBuilder creates a SignatureDataBuilder
	CreateSignatureDataBuilder() SignatureDataBuilder
}

// _SignatureData is the data-structure of this message
type _SignatureData struct {
	ExtensionObjectDefinitionContract
	Algorithm PascalString
	Signature PascalByteString
}

var _ SignatureData = (*_SignatureData)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_SignatureData)(nil)

// NewSignatureData factory function for _SignatureData
func NewSignatureData(algorithm PascalString, signature PascalByteString) *_SignatureData {
	if algorithm == nil {
		panic("algorithm of type PascalString for SignatureData must not be nil")
	}
	if signature == nil {
		panic("signature of type PascalByteString for SignatureData must not be nil")
	}
	_result := &_SignatureData{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Algorithm:                         algorithm,
		Signature:                         signature,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SignatureDataBuilder is a builder for SignatureData
type SignatureDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(algorithm PascalString, signature PascalByteString) SignatureDataBuilder
	// WithAlgorithm adds Algorithm (property field)
	WithAlgorithm(PascalString) SignatureDataBuilder
	// WithAlgorithmBuilder adds Algorithm (property field) which is build by the builder
	WithAlgorithmBuilder(func(PascalStringBuilder) PascalStringBuilder) SignatureDataBuilder
	// WithSignature adds Signature (property field)
	WithSignature(PascalByteString) SignatureDataBuilder
	// WithSignatureBuilder adds Signature (property field) which is build by the builder
	WithSignatureBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) SignatureDataBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the SignatureData or returns an error if something is wrong
	Build() (SignatureData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SignatureData
}

// NewSignatureDataBuilder() creates a SignatureDataBuilder
func NewSignatureDataBuilder() SignatureDataBuilder {
	return &_SignatureDataBuilder{_SignatureData: new(_SignatureData)}
}

type _SignatureDataBuilder struct {
	*_SignatureData

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (SignatureDataBuilder) = (*_SignatureDataBuilder)(nil)

func (b *_SignatureDataBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._SignatureData
}

func (b *_SignatureDataBuilder) WithMandatoryFields(algorithm PascalString, signature PascalByteString) SignatureDataBuilder {
	return b.WithAlgorithm(algorithm).WithSignature(signature)
}

func (b *_SignatureDataBuilder) WithAlgorithm(algorithm PascalString) SignatureDataBuilder {
	b.Algorithm = algorithm
	return b
}

func (b *_SignatureDataBuilder) WithAlgorithmBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) SignatureDataBuilder {
	builder := builderSupplier(b.Algorithm.CreatePascalStringBuilder())
	var err error
	b.Algorithm, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_SignatureDataBuilder) WithSignature(signature PascalByteString) SignatureDataBuilder {
	b.Signature = signature
	return b
}

func (b *_SignatureDataBuilder) WithSignatureBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) SignatureDataBuilder {
	builder := builderSupplier(b.Signature.CreatePascalByteStringBuilder())
	var err error
	b.Signature, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_SignatureDataBuilder) Build() (SignatureData, error) {
	if b.Algorithm == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'algorithm' not set"))
	}
	if b.Signature == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'signature' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SignatureData.deepCopy(), nil
}

func (b *_SignatureDataBuilder) MustBuild() SignatureData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SignatureDataBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_SignatureDataBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_SignatureDataBuilder) DeepCopy() any {
	_copy := b.CreateSignatureDataBuilder().(*_SignatureDataBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSignatureDataBuilder creates a SignatureDataBuilder
func (b *_SignatureData) CreateSignatureDataBuilder() SignatureDataBuilder {
	if b == nil {
		return NewSignatureDataBuilder()
	}
	return &_SignatureDataBuilder{_SignatureData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SignatureData) GetExtensionId() int32 {
	return int32(458)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SignatureData) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SignatureData) GetAlgorithm() PascalString {
	return m.Algorithm
}

func (m *_SignatureData) GetSignature() PascalByteString {
	return m.Signature
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSignatureData(structType any) SignatureData {
	if casted, ok := structType.(SignatureData); ok {
		return casted
	}
	if casted, ok := structType.(*SignatureData); ok {
		return *casted
	}
	return nil
}

func (m *_SignatureData) GetTypeName() string {
	return "SignatureData"
}

func (m *_SignatureData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (algorithm)
	lengthInBits += m.Algorithm.GetLengthInBits(ctx)

	// Simple field (signature)
	lengthInBits += m.Signature.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SignatureData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SignatureData) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__signatureData SignatureData, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SignatureData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SignatureData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	algorithm, err := ReadSimpleField[PascalString](ctx, "algorithm", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'algorithm' field"))
	}
	m.Algorithm = algorithm

	signature, err := ReadSimpleField[PascalByteString](ctx, "signature", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'signature' field"))
	}
	m.Signature = signature

	if closeErr := readBuffer.CloseContext("SignatureData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SignatureData")
	}

	return m, nil
}

func (m *_SignatureData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SignatureData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SignatureData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SignatureData")
		}

		if err := WriteSimpleField[PascalString](ctx, "algorithm", m.GetAlgorithm(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'algorithm' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "signature", m.GetSignature(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'signature' field")
		}

		if popErr := writeBuffer.PopContext("SignatureData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SignatureData")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SignatureData) IsSignatureData() {}

func (m *_SignatureData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SignatureData) deepCopy() *_SignatureData {
	if m == nil {
		return nil
	}
	_SignatureDataCopy := &_SignatureData{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Algorithm),
		utils.DeepCopy[PascalByteString](m.Signature),
	}
	_SignatureDataCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _SignatureDataCopy
}

func (m *_SignatureData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
