/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonActionMetaDataMessage is the corresponding interface of JsonActionMetaDataMessage
type JsonActionMetaDataMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetDataSetWriterName returns DataSetWriterName (property field)
	GetDataSetWriterName() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetActionTargets returns ActionTargets (property field)
	GetActionTargets() []ActionTargetDataType
	// GetRequest returns Request (property field)
	GetRequest() DataSetMetaDataType
	// GetResponse returns Response (property field)
	GetResponse() DataSetMetaDataType
	// GetActionMethods returns ActionMethods (property field)
	GetActionMethods() []ActionMethodDataType
	// IsJsonActionMetaDataMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonActionMetaDataMessage()
	// CreateBuilder creates a JsonActionMetaDataMessageBuilder
	CreateJsonActionMetaDataMessageBuilder() JsonActionMetaDataMessageBuilder
}

// _JsonActionMetaDataMessage is the data-structure of this message
type _JsonActionMetaDataMessage struct {
	ExtensionObjectDefinitionContract
	MessageId         PascalString
	MessageType       PascalString
	PublisherId       PascalString
	DataSetWriterId   uint16
	DataSetWriterName PascalString
	Timestamp         int64
	ActionTargets     []ActionTargetDataType
	Request           DataSetMetaDataType
	Response          DataSetMetaDataType
	ActionMethods     []ActionMethodDataType
}

var _ JsonActionMetaDataMessage = (*_JsonActionMetaDataMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonActionMetaDataMessage)(nil)

// NewJsonActionMetaDataMessage factory function for _JsonActionMetaDataMessage
func NewJsonActionMetaDataMessage(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, dataSetWriterName PascalString, timestamp int64, actionTargets []ActionTargetDataType, request DataSetMetaDataType, response DataSetMetaDataType, actionMethods []ActionMethodDataType) *_JsonActionMetaDataMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonActionMetaDataMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonActionMetaDataMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonActionMetaDataMessage must not be nil")
	}
	if dataSetWriterName == nil {
		panic("dataSetWriterName of type PascalString for JsonActionMetaDataMessage must not be nil")
	}
	if request == nil {
		panic("request of type DataSetMetaDataType for JsonActionMetaDataMessage must not be nil")
	}
	if response == nil {
		panic("response of type DataSetMetaDataType for JsonActionMetaDataMessage must not be nil")
	}
	_result := &_JsonActionMetaDataMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		DataSetWriterId:                   dataSetWriterId,
		DataSetWriterName:                 dataSetWriterName,
		Timestamp:                         timestamp,
		ActionTargets:                     actionTargets,
		Request:                           request,
		Response:                          response,
		ActionMethods:                     actionMethods,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonActionMetaDataMessageBuilder is a builder for JsonActionMetaDataMessage
type JsonActionMetaDataMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, dataSetWriterName PascalString, timestamp int64, actionTargets []ActionTargetDataType, request DataSetMetaDataType, response DataSetMetaDataType, actionMethods []ActionMethodDataType) JsonActionMetaDataMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonActionMetaDataMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonActionMetaDataMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonActionMetaDataMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) JsonActionMetaDataMessageBuilder
	// WithDataSetWriterName adds DataSetWriterName (property field)
	WithDataSetWriterName(PascalString) JsonActionMetaDataMessageBuilder
	// WithDataSetWriterNameBuilder adds DataSetWriterName (property field) which is build by the builder
	WithDataSetWriterNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonActionMetaDataMessageBuilder
	// WithActionTargets adds ActionTargets (property field)
	WithActionTargets(...ActionTargetDataType) JsonActionMetaDataMessageBuilder
	// WithRequest adds Request (property field)
	WithRequest(DataSetMetaDataType) JsonActionMetaDataMessageBuilder
	// WithRequestBuilder adds Request (property field) which is build by the builder
	WithRequestBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonActionMetaDataMessageBuilder
	// WithResponse adds Response (property field)
	WithResponse(DataSetMetaDataType) JsonActionMetaDataMessageBuilder
	// WithResponseBuilder adds Response (property field) which is build by the builder
	WithResponseBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonActionMetaDataMessageBuilder
	// WithActionMethods adds ActionMethods (property field)
	WithActionMethods(...ActionMethodDataType) JsonActionMetaDataMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonActionMetaDataMessage or returns an error if something is wrong
	Build() (JsonActionMetaDataMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonActionMetaDataMessage
}

// NewJsonActionMetaDataMessageBuilder() creates a JsonActionMetaDataMessageBuilder
func NewJsonActionMetaDataMessageBuilder() JsonActionMetaDataMessageBuilder {
	return &_JsonActionMetaDataMessageBuilder{_JsonActionMetaDataMessage: new(_JsonActionMetaDataMessage)}
}

type _JsonActionMetaDataMessageBuilder struct {
	*_JsonActionMetaDataMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonActionMetaDataMessageBuilder) = (*_JsonActionMetaDataMessageBuilder)(nil)

func (b *_JsonActionMetaDataMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonActionMetaDataMessage
}

func (b *_JsonActionMetaDataMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, dataSetWriterName PascalString, timestamp int64, actionTargets []ActionTargetDataType, request DataSetMetaDataType, response DataSetMetaDataType, actionMethods []ActionMethodDataType) JsonActionMetaDataMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithDataSetWriterId(dataSetWriterId).WithDataSetWriterName(dataSetWriterName).WithTimestamp(timestamp).WithActionTargets(actionTargets...).WithRequest(request).WithResponse(response).WithActionMethods(actionMethods...)
}

func (b *_JsonActionMetaDataMessageBuilder) WithMessageId(messageId PascalString) JsonActionMetaDataMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithMessageType(messageType PascalString) JsonActionMetaDataMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithPublisherId(publisherId PascalString) JsonActionMetaDataMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithDataSetWriterId(dataSetWriterId uint16) JsonActionMetaDataMessageBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithDataSetWriterName(dataSetWriterName PascalString) JsonActionMetaDataMessageBuilder {
	b.DataSetWriterName = dataSetWriterName
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithDataSetWriterNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.DataSetWriterName.CreatePascalStringBuilder())
	var err error
	b.DataSetWriterName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithTimestamp(timestamp int64) JsonActionMetaDataMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithActionTargets(actionTargets ...ActionTargetDataType) JsonActionMetaDataMessageBuilder {
	b.ActionTargets = actionTargets
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithRequest(request DataSetMetaDataType) JsonActionMetaDataMessageBuilder {
	b.Request = request
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithRequestBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.Request.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.Request, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithResponse(response DataSetMetaDataType) JsonActionMetaDataMessageBuilder {
	b.Response = response
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithResponseBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonActionMetaDataMessageBuilder {
	builder := builderSupplier(b.Response.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.Response, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) WithActionMethods(actionMethods ...ActionMethodDataType) JsonActionMetaDataMessageBuilder {
	b.ActionMethods = actionMethods
	return b
}

func (b *_JsonActionMetaDataMessageBuilder) Build() (JsonActionMetaDataMessage, error) {
	if b.MessageId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'publisherId' not set"))
	}
	if b.DataSetWriterName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataSetWriterName' not set"))
	}
	if b.Request == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'request' not set"))
	}
	if b.Response == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'response' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonActionMetaDataMessage.deepCopy(), nil
}

func (b *_JsonActionMetaDataMessageBuilder) MustBuild() JsonActionMetaDataMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonActionMetaDataMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonActionMetaDataMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonActionMetaDataMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonActionMetaDataMessageBuilder().(*_JsonActionMetaDataMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonActionMetaDataMessageBuilder creates a JsonActionMetaDataMessageBuilder
func (b *_JsonActionMetaDataMessage) CreateJsonActionMetaDataMessageBuilder() JsonActionMetaDataMessageBuilder {
	if b == nil {
		return NewJsonActionMetaDataMessageBuilder()
	}
	return &_JsonActionMetaDataMessageBuilder{_JsonActionMetaDataMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonActionMetaDataMessage) GetExtensionId() int32 {
	return int32(19320)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonActionMetaDataMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonActionMetaDataMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonActionMetaDataMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonActionMetaDataMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonActionMetaDataMessage) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_JsonActionMetaDataMessage) GetDataSetWriterName() PascalString {
	return m.DataSetWriterName
}

func (m *_JsonActionMetaDataMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonActionMetaDataMessage) GetActionTargets() []ActionTargetDataType {
	return m.ActionTargets
}

func (m *_JsonActionMetaDataMessage) GetRequest() DataSetMetaDataType {
	return m.Request
}

func (m *_JsonActionMetaDataMessage) GetResponse() DataSetMetaDataType {
	return m.Response
}

func (m *_JsonActionMetaDataMessage) GetActionMethods() []ActionMethodDataType {
	return m.ActionMethods
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonActionMetaDataMessage(structType any) JsonActionMetaDataMessage {
	if casted, ok := structType.(JsonActionMetaDataMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonActionMetaDataMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonActionMetaDataMessage) GetTypeName() string {
	return "JsonActionMetaDataMessage"
}

func (m *_JsonActionMetaDataMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (dataSetWriterName)
	lengthInBits += m.DataSetWriterName.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Implicit Field (noOfActionTargets)
	lengthInBits += 32

	// Array field
	if len(m.ActionTargets) > 0 {
		for _curItem, element := range m.ActionTargets {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ActionTargets), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (request)
	lengthInBits += m.Request.GetLengthInBits(ctx)

	// Simple field (response)
	lengthInBits += m.Response.GetLengthInBits(ctx)

	// Implicit Field (noOfActionMethods)
	lengthInBits += 32

	// Array field
	if len(m.ActionMethods) > 0 {
		for _curItem, element := range m.ActionMethods {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ActionMethods), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_JsonActionMetaDataMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonActionMetaDataMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonActionMetaDataMessage JsonActionMetaDataMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonActionMetaDataMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonActionMetaDataMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	dataSetWriterName, err := ReadSimpleField[PascalString](ctx, "dataSetWriterName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterName' field"))
	}
	m.DataSetWriterName = dataSetWriterName

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	noOfActionTargets, err := ReadImplicitField[int32](ctx, "noOfActionTargets", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfActionTargets' field"))
	}
	_ = noOfActionTargets

	actionTargets, err := ReadCountArrayField[ActionTargetDataType](ctx, "actionTargets", ReadComplex[ActionTargetDataType](ExtensionObjectDefinitionParseWithBufferProducer[ActionTargetDataType]((int32)(int32(18595))), readBuffer), uint64(noOfActionTargets))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargets' field"))
	}
	m.ActionTargets = actionTargets

	request, err := ReadSimpleField[DataSetMetaDataType](ctx, "request", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'request' field"))
	}
	m.Request = request

	response, err := ReadSimpleField[DataSetMetaDataType](ctx, "response", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'response' field"))
	}
	m.Response = response

	noOfActionMethods, err := ReadImplicitField[int32](ctx, "noOfActionMethods", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfActionMethods' field"))
	}
	_ = noOfActionMethods

	actionMethods, err := ReadCountArrayField[ActionMethodDataType](ctx, "actionMethods", ReadComplex[ActionMethodDataType](ExtensionObjectDefinitionParseWithBufferProducer[ActionMethodDataType]((int32)(int32(18599))), readBuffer), uint64(noOfActionMethods))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionMethods' field"))
	}
	m.ActionMethods = actionMethods

	if closeErr := readBuffer.CloseContext("JsonActionMetaDataMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonActionMetaDataMessage")
	}

	return m, nil
}

func (m *_JsonActionMetaDataMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonActionMetaDataMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonActionMetaDataMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonActionMetaDataMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetWriterName", m.GetDataSetWriterName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterName' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}
		noOfActionTargets := int32(utils.InlineIf(bool((m.GetActionTargets()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetActionTargets()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfActionTargets", noOfActionTargets, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfActionTargets' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "actionTargets", m.GetActionTargets(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargets' field")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "request", m.GetRequest(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'request' field")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "response", m.GetResponse(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'response' field")
		}
		noOfActionMethods := int32(utils.InlineIf(bool((m.GetActionMethods()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetActionMethods()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfActionMethods", noOfActionMethods, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfActionMethods' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "actionMethods", m.GetActionMethods(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'actionMethods' field")
		}

		if popErr := writeBuffer.PopContext("JsonActionMetaDataMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonActionMetaDataMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonActionMetaDataMessage) IsJsonActionMetaDataMessage() {}

func (m *_JsonActionMetaDataMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonActionMetaDataMessage) deepCopy() *_JsonActionMetaDataMessage {
	if m == nil {
		return nil
	}
	_JsonActionMetaDataMessageCopy := &_JsonActionMetaDataMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.DataSetWriterId,
		utils.DeepCopy[PascalString](m.DataSetWriterName),
		m.Timestamp,
		utils.DeepCopySlice[ActionTargetDataType, ActionTargetDataType](m.ActionTargets),
		utils.DeepCopy[DataSetMetaDataType](m.Request),
		utils.DeepCopy[DataSetMetaDataType](m.Response),
		utils.DeepCopySlice[ActionMethodDataType, ActionMethodDataType](m.ActionMethods),
	}
	_JsonActionMetaDataMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonActionMetaDataMessageCopy
}

func (m *_JsonActionMetaDataMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
