/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om.quota;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.repair.om.quota.QuotaStatus;
import org.apache.hadoop.ozone.repair.om.quota.QuotaTrigger;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.protocol.ClientId;
import picocli.CommandLine;

@CommandLine.Command(name="quota", subcommands={QuotaStatus.class, QuotaTrigger.class}, description={"Operational tool to repair quota in OM DB."})
public class QuotaRepair
extends AbstractSubcommand {
    public OzoneManagerProtocolClientSideTranslatorPB createOmClient(String omServiceID, String omHost, boolean forceHA) throws Exception {
        OzoneConfiguration conf = this.getOzoneConf();
        if (omHost != null && !omHost.isEmpty()) {
            omServiceID = null;
            conf.set("ozone.om.address", omHost);
        } else if (omServiceID == null || omServiceID.isEmpty()) {
            omServiceID = this.getTheOnlyConfiguredOmServiceIdOrThrow();
        }
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        String clientId = ClientId.randomId().toString();
        if (!forceHA || forceHA && OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceID)) {
            OmTransport omTransport = new Hadoop3OmTransportFactory().createOmTransport((ConfigurationSource)conf, this.getUser(), omServiceID);
            return new OzoneManagerProtocolClientSideTranslatorPB(omTransport, clientId);
        }
        throw new OzoneClientException("This command works only on OzoneManager HA cluster. Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids") + "\n");
    }

    private String getTheOnlyConfiguredOmServiceIdOrThrow() {
        if (this.getConfiguredServiceIds().size() != 1) {
            throw new IllegalArgumentException("There is no Ozone Manager service ID specified, but there are either zero, or more than one service IDconfigured.");
        }
        return this.getConfiguredServiceIds().iterator().next();
    }

    private Collection<String> getConfiguredServiceIds() {
        OzoneConfiguration conf = this.getOzoneConf();
        Collection omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        return omServiceIds;
    }

    public UserGroupInformation getUser() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }
}

