/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.states;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.ratis.util.Preconditions;

public class ContainerAttribute<T extends Enum<T>> {
    private final Class<T> attributeClass;
    private final ImmutableMap<T, NavigableMap<ContainerID, ContainerInfo>> attributeMap;

    public ContainerAttribute(Class<T> attributeClass) {
        this.attributeClass = attributeClass;
        EnumMap map = new EnumMap(attributeClass);
        for (Enum t : (Enum[])attributeClass.getEnumConstants()) {
            map.put(t, new TreeMap());
        }
        this.attributeMap = Maps.immutableEnumMap(map);
    }

    public void addNonExisting(T key, ContainerInfo info) {
        Objects.requireNonNull(info, "value == null");
        ContainerInfo previous = this.get(key).put(info.containerID(), info);
        Preconditions.assertNull((Object)previous, (String)"previous");
    }

    public void clearSet(T key) {
        this.get(key).clear();
    }

    public ContainerInfo remove(T key, ContainerID id) {
        Objects.requireNonNull(id, "id == null");
        return (ContainerInfo)this.get(key).remove(id);
    }

    public void removeExisting(T key, ContainerInfo existing) {
        Objects.requireNonNull(existing, "existing == null");
        ContainerInfo removed = this.remove(key, existing.containerID());
        Preconditions.assertSame((Object)existing, (Object)removed, (String)"removed");
    }

    NavigableMap<ContainerID, ContainerInfo> get(T attribute) {
        Objects.requireNonNull(attribute, "attribute == null");
        NavigableMap map = (NavigableMap)this.attributeMap.get(attribute);
        if (map == null) {
            throw new IllegalStateException("Attribute not found: " + attribute + " (" + this.attributeClass.getSimpleName() + ")");
        }
        return map;
    }

    public List<ContainerInfo> getCollection(T key) {
        return new ArrayList<ContainerInfo>(this.get(key).values());
    }

    public SortedMap<ContainerID, ContainerInfo> tailMap(T key, ContainerID start) {
        Objects.requireNonNull(start, "start == null");
        return this.get(key).tailMap(start);
    }

    public int count(T key) {
        return this.get(key).size();
    }

    public void update(T currentKey, T newKey, ContainerID value) throws SCMException {
        if (currentKey == newKey) {
            return;
        }
        Objects.requireNonNull(newKey, "newKey == null");
        ContainerInfo removed = this.remove(currentKey, value);
        if (removed == null) {
            throw new SCMException("Failed to update Container " + value + " from " + currentKey + " to " + newKey + ": Container " + value + " not found in attribute " + currentKey, SCMException.ResultCodes.FAILED_TO_CHANGE_CONTAINER_STATE);
        }
        this.addNonExisting(newKey, removed);
    }
}

