/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.yaml.snakeyaml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.Node;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.ScalarNode;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import org.apache.ozone.shaded.org.yaml.snakeyaml.nodes.Tag;
import org.apache.ozone.shaded.org.yaml.snakeyaml.util.Tuple;

public abstract class MergeUtils {
    public abstract MappingNode asMappingNode(Node var1);

    public List<NodeTuple> flatten(MappingNode node) {
        List<NodeTuple> toProcess;
        List<NodeTuple> result2 = toProcess = node.getValue();
        boolean process = true;
        while (process) {
            process = false;
            ArrayList<NodeTuple> updated = new ArrayList<NodeTuple>(toProcess.size());
            HashSet<String> keys2 = new HashSet<String>(toProcess.size());
            ArrayList<NodeTuple> merges = new ArrayList<NodeTuple>(2);
            for (NodeTuple tuple : toProcess) {
                Node keyNode = tuple.getKeyNode();
                if (keyNode.getTag().equals(Tag.MERGE)) {
                    merges.add(tuple);
                    continue;
                }
                updated.add(tuple);
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sNode = (ScalarNode)keyNode;
                keys2.add(sNode.getValue());
            }
            for (NodeTuple tuple : merges) {
                Node valueNode = tuple.getValueNode();
                if (valueNode instanceof SequenceNode) {
                    SequenceNode seqNode = (SequenceNode)valueNode;
                    for (Node ref : seqNode.getValue()) {
                        MappingNode mergable = this.asMappingNode(ref);
                        process = process || mergable.isMerged();
                        Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys2);
                        updated.addAll((Collection<NodeTuple>)filtered._1());
                        keys2.addAll((Collection<String>)filtered._2());
                    }
                    continue;
                }
                MappingNode mergable = this.asMappingNode(valueNode);
                process = process || mergable.isMerged();
                Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys2);
                updated.addAll((Collection<NodeTuple>)filtered._1());
                keys2.addAll((Collection<String>)filtered._2());
            }
            result2 = updated;
            if (!process) continue;
            toProcess = updated;
        }
        return result2;
    }

    private Tuple<List<NodeTuple>, Set<String>> filter(List<NodeTuple> mergables, Set<String> filter) {
        int size = mergables.size();
        HashSet<String> keys2 = new HashSet<String>(size);
        ArrayList<NodeTuple> result2 = new ArrayList<NodeTuple>(size);
        for (NodeTuple tuple : mergables) {
            Node key = tuple.getKeyNode();
            if (key instanceof ScalarNode) {
                ScalarNode sNode = (ScalarNode)key;
                String nodeValue = sNode.getValue();
                if (filter.contains(nodeValue)) continue;
                result2.add(tuple);
                keys2.add(nodeValue);
                continue;
            }
            result2.add(tuple);
        }
        return new Tuple<List<NodeTuple>, Set<String>>(result2, keys2);
    }
}

