/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeer;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeerId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ozone.shaded.org.apache.ratis.util.ConcurrentUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.IOUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.LifeCycle;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedFunction;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerProxyMap<PROXY extends Closeable>
implements RaftPeer.Add,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(PeerProxyMap.class);
    private final String name;
    private final Map<RaftPeerId, PeerAndProxy> peers = new ConcurrentHashMap<RaftPeerId, PeerAndProxy>();
    private final Object resetLock = new Object();
    private final CheckedFunction<RaftPeer, PROXY, IOException> createProxy;
    private final AtomicBoolean closed = new AtomicBoolean();

    public PeerProxyMap(String name, CheckedFunction<RaftPeer, PROXY, IOException> createProxy) {
        this.name = name;
        this.createProxy = createProxy;
    }

    public String getName() {
        return this.name;
    }

    private PROXY createProxyImpl(RaftPeer peer) throws IOException {
        if (this.closed.get()) {
            throw new AlreadyClosedException(this.name + ": Failed to create proxy for " + peer);
        }
        return (PROXY)((Closeable)this.createProxy.apply(peer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROXY getProxy(RaftPeerId id) throws IOException {
        Objects.requireNonNull(id, "id == null");
        PeerAndProxy p = this.peers.get(id);
        if (p == null) {
            Object object = this.resetLock;
            synchronized (object) {
                p = Objects.requireNonNull(this.peers.get(id), () -> this.name + ": Server " + id + " not found: peers=" + this.peers.keySet());
            }
        }
        return p.getProxy();
    }

    @Override
    public void addRaftPeers(Collection<RaftPeer> newPeers) {
        for (RaftPeer p : newPeers) {
            this.computeIfAbsent(p);
        }
    }

    public CheckedSupplier<PROXY, IOException> computeIfAbsent(RaftPeer peer) {
        PeerAndProxy peerAndProxy = this.peers.computeIfAbsent(peer.getId(), k -> new PeerAndProxy(peer));
        return peerAndProxy::getProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProxy(RaftPeerId id) {
        PeerAndProxy pp;
        LOG.debug("{}: reset proxy for {}", (Object)this.name, (Object)id);
        Optional<Closeable> optional = Optional.empty();
        Object object = this.resetLock;
        synchronized (object) {
            pp = this.peers.remove(id);
            if (pp != null) {
                RaftPeer peer = pp.getPeer();
                optional = pp.setNullProxyAndClose();
                this.computeIfAbsent(peer);
            }
        }
        optional.map(proxy -> this.closeProxy(proxy, pp)).ifPresent(e -> LOG.warn("Failed to close the previous proxy", (Throwable)e));
    }

    public boolean handleException(RaftPeerId serverId, Throwable e, boolean reconnect) {
        if (reconnect || IOUtils.shouldReconnect(e)) {
            this.resetProxy(serverId);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        List exceptions = Collections.synchronizedList(new ArrayList());
        ConcurrentUtils.parallelForEachAsync(this.peers.values(), pp -> pp.setNullProxyAndClose().map(proxy -> this.closeProxy((PROXY)proxy, (PeerAndProxy)pp)).ifPresent(exceptions::add), r -> new Thread(r).start()).join();
        int size = exceptions.size();
        if (size > 0) {
            Iterator i = exceptions.iterator();
            IOException e = new IOException(this.name + ": Failed to close proxy map", (Throwable)i.next());
            while (i.hasNext()) {
                e.addSuppressed((Throwable)i.next());
            }
            LOG.warn("{}: {} exception(s)", new Object[]{this.name, size, e});
        }
    }

    private IOException closeProxy(PROXY proxy, PeerAndProxy pp) {
        try {
            LOG.debug("{}: Closing proxy {} {} for peer {}", new Object[]{this.name, proxy.getClass().getSimpleName(), proxy, pp});
            proxy.close();
            return null;
        }
        catch (IOException e) {
            return new IOException(this.name + ": Failed to close proxy for peer " + pp + ", " + proxy.getClass(), e);
        }
    }

    private class PeerAndProxy {
        private final RaftPeer peer;
        private volatile PROXY proxy = null;
        private final LifeCycle lifeCycle;

        PeerAndProxy(RaftPeer peer) {
            this.peer = peer;
            this.lifeCycle = new LifeCycle(peer);
        }

        RaftPeer getPeer() {
            return this.peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PROXY getProxy() throws IOException {
            if (this.proxy == null) {
                PeerAndProxy peerAndProxy = this;
                synchronized (peerAndProxy) {
                    if (this.proxy == null) {
                        LifeCycle.State current = this.lifeCycle.getCurrentState();
                        if (current.isClosingOrClosed()) {
                            throw new AlreadyClosedException(PeerProxyMap.this.name + " is already " + (Object)((Object)current));
                        }
                        this.lifeCycle.startAndTransition(() -> {
                            this.proxy = PeerProxyMap.this.createProxyImpl(this.peer);
                        }, IOException.class);
                    }
                }
            }
            return this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Optional<PROXY> setNullProxyAndClose() {
            Object p;
            PeerAndProxy peerAndProxy = this;
            synchronized (peerAndProxy) {
                p = this.proxy;
                this.lifeCycle.checkStateAndClose(() -> {
                    this.proxy = null;
                });
            }
            return Optional.ofNullable(p);
        }

        public String toString() {
            return this.peer.getId().toString();
        }
    }
}

