/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.metrics;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;

public class MetricRegistryInfo {
    private final String prefix;
    private final String metricsDescription;
    private final String metricsComponentName;
    private final String applicationName;
    private final Supplier<Integer> hash = MemoizedSupplier.valueOf(this::computeHash);

    public MetricRegistryInfo(String prefix, String applicationName, String metricsComponentName, String metricsDescription) {
        this.prefix = prefix;
        this.applicationName = applicationName;
        this.metricsComponentName = metricsComponentName;
        this.metricsDescription = metricsDescription;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getMetricsComponentName() {
        return this.metricsComponentName;
    }

    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetricRegistryInfo)) {
            return false;
        }
        MetricRegistryInfo that = (MetricRegistryInfo)obj;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.metricsDescription, that.metricsDescription) && Objects.equals(this.metricsComponentName, that.metricsComponentName) && Objects.equals(this.applicationName, that.applicationName);
    }

    public int hashCode() {
        return this.hash.get();
    }

    private Integer computeHash() {
        return Objects.hash(this.prefix, this.metricsDescription, this.metricsComponentName);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ": applicationName=" + this.getApplicationName() + ", metricsComponentName=" + this.getMetricsComponentName() + ", prefix=" + this.getPrefix() + ", metricsDescription=" + this.getMetricsDescription();
    }
}

