/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.view;

import java.util.function.Supplier;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.RandomSupplier;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleSumAggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongSumAggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class SumAggregation
implements Aggregation,
AggregatorFactory {
    private static final SumAggregation INSTANCE = new SumAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private SumAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongSumAggregator(instrumentDescriptor, reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleSumAggregator(instrumentDescriptor, reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case OBSERVABLE_COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SumAggregation";
    }
}

