/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

class FilteredExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir<T> reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerLongMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

