/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previous, DoublePointData current) {
        return current;
    }

    @Override
    public void diffInPlace(DoublePointData previousReusable, DoublePointData current) {
        ((MutableDoublePointData)previousReusable).set(current);
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        private final AtomicReference<AtomicLong> current = new AtomicReference<Object>(null);
        private final AtomicLong valueBits = new AtomicLong();
        @Nullable
        private final MutableDoublePointData reusablePoint;

        private Handle(ExemplarReservoir<DoubleExemplarData> reservoir, MemoryMode memoryMode) {
            super(reservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            AtomicLong valueBits = Objects.requireNonNull(reset ? (AtomicLong)this.current.getAndSet(null) : this.current.get());
            double value = Double.longBitsToDouble(valueBits.get());
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.valueBits.set(Double.doubleToLongBits(value));
            this.current.compareAndSet(null, this.valueBits);
        }
    }
}

