/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.BatchCallback;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleCounter;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongCounter;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.SdkMeter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;

class SdkObservableInstrument
implements ObservableDoubleCounter,
ObservableLongCounter,
ObservableDoubleGauge,
ObservableLongGauge,
ObservableDoubleUpDownCounter,
ObservableLongUpDownCounter,
BatchCallback {
    private static final Logger logger = Logger.getLogger(SdkObservableInstrument.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final SdkMeter sdkMeter;
    private final CallbackRegistration callbackRegistration;
    private final AtomicBoolean removed = new AtomicBoolean(false);

    SdkObservableInstrument(SdkMeter sdkMeter, CallbackRegistration callbackRegistration) {
        this.sdkMeter = sdkMeter;
        this.callbackRegistration = callbackRegistration;
    }

    @Override
    public void close() {
        if (!this.removed.compareAndSet(false, true)) {
            this.throttlingLogger.log(Level.WARNING, this.callbackRegistration + " has called close() multiple times.");
            return;
        }
        this.sdkMeter.removeCallback(this.callbackRegistration);
    }

    public String toString() {
        return "SdkObservableInstrument{callback=" + this.callbackRegistration + "}";
    }
}

