/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.internal;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.RateLimiter;

public class ThrottlingLogger {
    private static final double DEFAULT_RATE_LIMIT = 5.0;
    private static final double DEFAULT_THROTTLED_RATE_LIMIT = 1.0;
    private static final TimeUnit DEFAULT_RATE_TIME_UNIT = TimeUnit.MINUTES;
    private final Logger delegate;
    private final AtomicBoolean throttled = new AtomicBoolean(false);
    private final RateLimiter fastRateLimiter;
    private final RateLimiter throttledRateLimiter;
    private final double rateLimit;
    private final double throttledRateLimit;
    private final TimeUnit rateTimeUnit;

    public ThrottlingLogger(Logger delegate) {
        this(delegate, Clock.getDefault());
    }

    public ThrottlingLogger(Logger delegate, double rateLimit, double throttledRateLimit, TimeUnit rateTimeUnit) {
        this(delegate, Clock.getDefault(), rateLimit, throttledRateLimit, rateTimeUnit);
    }

    ThrottlingLogger(Logger delegate, Clock clock) {
        this(delegate, clock, 5.0, 1.0, DEFAULT_RATE_TIME_UNIT);
    }

    ThrottlingLogger(Logger delegate, Clock clock, double rateLimit, double throttledRateLimit, TimeUnit rateTimeUnit) {
        this.delegate = delegate;
        this.rateLimit = rateLimit;
        this.throttledRateLimit = throttledRateLimit;
        this.rateTimeUnit = rateTimeUnit;
        this.fastRateLimiter = new RateLimiter(this.rateLimit / (double)this.rateTimeUnit.toSeconds(1L), this.rateLimit, clock);
        this.throttledRateLimiter = new RateLimiter(this.throttledRateLimit / (double)this.rateTimeUnit.toSeconds(1L), this.throttledRateLimit, clock);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, @Nullable Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (this.throttled.get()) {
            if (this.throttledRateLimiter.trySpend(1.0)) {
                this.doLog(level, message, throwable);
            }
            return;
        }
        if (this.fastRateLimiter.trySpend(1.0)) {
            this.doLog(level, message, throwable);
            return;
        }
        if (this.throttled.compareAndSet(false, true)) {
            this.throttledRateLimiter.trySpend(this.throttledRateLimit);
            String timeUnitString = this.rateTimeUnit.toString().toLowerCase(Locale.ROOT);
            String throttleMessage = String.format(Locale.ROOT, "Too many log messages detected. Will only log %.0f time(s) per %s from now on.", this.throttledRateLimit, timeUnitString.substring(0, timeUnitString.length() - 1));
            this.delegate.log(level, throttleMessage);
            this.doLog(level, message, throwable);
        }
    }

    private void doLog(Level level, String message, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.delegate.log(level, message, throwable);
        } else {
            this.delegate.log(level, message);
        }
    }

    public boolean isLoggable(Level level) {
        return this.delegate.isLoggable(level);
    }
}

