/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.OpenTelemetrySdk;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import org.apache.ozone.shaded.io.opentelemetry.sdk.logs.export.LogRecordExporter;

public class OtlpLogRecordExporterProvider
implements ConfigurableLogRecordExporterProvider,
AutoConfigureListener {
    private final AtomicReference<MeterProvider> meterProviderRef = new AtomicReference<MeterProvider>(MeterProvider.noop());

    @Override
    public LogRecordExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("logs", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setComponentLoader, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setComponentLoader, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP logs protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }

    @Override
    public void afterAutoConfigure(OpenTelemetrySdk sdk) {
        this.meterProviderRef.set(sdk.getMeterProvider());
    }
}

