/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.HistogramDataPointStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.proto.metrics.v1.internal.Histogram;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.HistogramData;

final class HistogramStatelessMarshaler
implements StatelessMarshaler<HistogramData> {
    static final HistogramStatelessMarshaler INSTANCE = new HistogramStatelessMarshaler();
    private static final MarshalerContext.Key DATA_POINT_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key DATA_POINT_WRITER_KEY = MarshalerContext.key();

    private HistogramStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, HistogramData histogram, MarshalerContext context) throws IOException {
        output.serializeRepeatedMessageWithContext(Histogram.DATA_POINTS, histogram.getPoints(), HistogramDataPointStatelessMarshaler.INSTANCE, context, DATA_POINT_WRITER_KEY);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    @Override
    public int getBinarySerializedSize(HistogramData histogram, MarshalerContext context) {
        int size = 0;
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Histogram.DATA_POINTS, histogram.getPoints(), HistogramDataPointStatelessMarshaler.INSTANCE, context, DATA_POINT_SIZE_CALCULATOR_KEY);
        return size += MarshalerUtil.sizeEnum(Histogram.AGGREGATION_TEMPORALITY, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }
}

