/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Value;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.ArrayAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.BoolAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.BytesAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.DoubleAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.IntAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.StringAnyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.common.v1.internal.AnyValue;

public final class AnyValueStatelessMarshaler
implements StatelessMarshaler<Value<?>> {
    public static final AnyValueStatelessMarshaler INSTANCE = new AnyValueStatelessMarshaler();

    private AnyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, Value<?> value, MarshalerContext context) throws IOException {
        switch (value.getType()) {
            case STRING: {
                StringAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (String)value.getValue(), context);
                return;
            }
            case BOOLEAN: {
                BoolAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Boolean)value.getValue(), context);
                return;
            }
            case LONG: {
                IntAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Long)value.getValue(), context);
                return;
            }
            case DOUBLE: {
                DoubleAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Double)value.getValue(), context);
                return;
            }
            case ARRAY: {
                output.serializeMessageWithContext(AnyValue.ARRAY_VALUE, (List)value.getValue(), ArrayAnyValueStatelessMarshaler.INSTANCE, context);
                return;
            }
            case KEY_VALUE_LIST: {
                output.serializeMessageWithContext(AnyValue.KVLIST_VALUE, (List)value.getValue(), KeyValueListAnyValueStatelessMarshaler.INSTANCE, context);
                return;
            }
            case BYTES: {
                BytesAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (ByteBuffer)value.getValue(), context);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    @Override
    public int getBinarySerializedSize(Value<?> value, MarshalerContext context) {
        switch (value.getType()) {
            case STRING: {
                return StringAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((String)value.getValue(), context);
            }
            case BOOLEAN: {
                return BoolAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Boolean)value.getValue(), context);
            }
            case LONG: {
                return IntAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Long)value.getValue(), context);
            }
            case DOUBLE: {
                return DoubleAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Double)value.getValue(), context);
            }
            case ARRAY: {
                return StatelessMarshalerUtil.sizeMessageWithContext(AnyValue.ARRAY_VALUE, (List)value.getValue(), ArrayAnyValueStatelessMarshaler.INSTANCE, context);
            }
            case KEY_VALUE_LIST: {
                return StatelessMarshalerUtil.sizeMessageWithContext(AnyValue.KVLIST_VALUE, (List)value.getValue(), KeyValueListAnyValueStatelessMarshaler.INSTANCE, context);
            }
            case BYTES: {
                return BytesAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((ByteBuffer)value.getValue(), context);
            }
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }
}

